/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.FhirContext;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface IContextValidationSupport<EVS_IN, EVS_OUT, SDT, CST, CDCT, IST> {
    public EVS_OUT expandValueSet(FhirContext var1, EVS_IN var2);

    public List<IBaseResource> fetchAllConformanceResources(FhirContext var1);

    public List<SDT> fetchAllStructureDefinitions(FhirContext var1);

    public CST fetchCodeSystem(FhirContext var1, String var2);

    public <T extends IBaseResource> T fetchResource(FhirContext var1, Class<T> var2, String var3);

    public SDT fetchStructureDefinition(FhirContext var1, String var2);

    public boolean isCodeSystemSupported(FhirContext var1, String var2);

    public CodeValidationResult<CDCT, IST> validateCode(FhirContext var1, String var2, String var3, String var4);

    public static class CodeValidationResult<CDCT, IST> {
        private CDCT definition;
        private String message;
        private IST severity;

        public CodeValidationResult(CDCT theNext) {
            this.definition = theNext;
        }

        public CodeValidationResult(IST severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public CodeValidationResult(IST severity, String message, CDCT definition) {
            this.severity = severity;
            this.message = message;
            this.definition = definition;
        }

        public CDCT asConceptDefinition() {
            return this.definition;
        }

        public String getMessage() {
            return this.message;
        }

        public IST getSeverity() {
            return this.severity;
        }

        public boolean isOk() {
            return this.definition != null;
        }
    }
}

