/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.XmlUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

@DatatypeDef(name="xhtml")
public class XhtmlDt
extends BasePrimitive<List<XMLEvent>> {
    private static final String DECL_XMLNS = " xmlns=\"http://www.w3.org/1999/xhtml\"";
    private static final String DIV_OPEN_FIRST = "<div xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final long serialVersionUID = 1L;

    public XhtmlDt() {
    }

    @SimpleSetter
    public XhtmlDt(@SimpleSetter.Parameter(name="theTextDiv") String theTextDiv) {
        this.setValueAsString(theTextDiv);
    }

    @Override
    protected String encode(List<XMLEvent> theValue) {
        try {
            StringWriter w = new StringWriter();
            XMLEventWriter ew = XmlUtil.createXmlFragmentWriter(w);
            for (XMLEvent next : (List)this.getValue()) {
                if (next.isCharacters()) {
                    ew.add(next);
                    continue;
                }
                ew.add(next);
            }
            ew.close();
            return w.toString();
        }
        catch (XMLStreamException e) {
            throw new DataFormatException("Problem with the contained XML events", e);
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean hasContent() {
        return this.getValue() != null && ((List)this.getValue()).size() > 0;
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && (this.getValue() == null || ((List)this.getValue()).isEmpty());
    }

    @Override
    protected List<XMLEvent> parse(String theValue) {
        boolean hasProcessingInstruction;
        String val = theValue.trim();
        if (!val.startsWith("<")) {
            val = DIV_OPEN_FIRST + val + "</div>";
        }
        if ((hasProcessingInstruction = val.startsWith("<?")) && val.endsWith("?>")) {
            return null;
        }
        try {
            ArrayList<XMLEvent> value = new ArrayList<XMLEvent>();
            StringReader reader = new StringReader(val);
            XMLEventReader er = XmlUtil.createXmlReader(reader);
            boolean first = true;
            while (er.hasNext()) {
                XMLEvent next = er.nextEvent();
                if (first) {
                    first = false;
                    continue;
                }
                if (!er.hasNext()) continue;
                value.add(next);
            }
            return value;
        }
        catch (XMLStreamException e) {
            throw new DataFormatException("String does not appear to be valid XML/XHTML (error is \"" + e.getMessage() + "\"): " + theValue, e);
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        if (theValue == null || theValue.isEmpty()) {
            super.setValueAsString(null);
        } else {
            String value = theValue.trim();
            value = XhtmlDt.preprocessXhtmlNamespaceDeclaration(value);
            super.setValueAsString(value);
        }
    }

    public static String preprocessXhtmlNamespaceDeclaration(String value) {
        boolean hasProcessingInstruction;
        int firstTagIndex;
        if (value.charAt(0) != '<') {
            value = DIV_OPEN_FIRST + value + "</div>";
        }
        if ((firstTagIndex = value.indexOf("<", (hasProcessingInstruction = value.startsWith("<?")) ? 1 : 0)) != -1) {
            String firstTag;
            int firstTagEnd = value.indexOf(">", firstTagIndex);
            int firstSlash = value.indexOf("/", firstTagIndex);
            if (firstTagEnd != -1 && firstSlash > firstTagEnd && !(firstTag = value.substring(firstTagIndex, firstTagEnd)).contains(" xmlns")) {
                value = value.substring(0, firstTagEnd) + DECL_XMLNS + value.substring(firstTagEnd);
            }
        }
        return value;
    }
}

