/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.TagListParam;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.DateAndListParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import ca.uhn.fhir.rest.param.binder.QueryParameterAndBinder;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterUtil {
    private static final String LABEL = "label=\"";
    private static final Logger ourLog = LoggerFactory.getLogger(ParameterUtil.class);
    private static final String SCHEME = "scheme=\"";

    public static <T extends IIdType> T convertIdToType(IIdType value, Class<T> theIdParamType) {
        if (value != null && !theIdParamType.isAssignableFrom(value.getClass())) {
            IIdType newValue = (IIdType)ReflectionUtil.newInstance(theIdParamType);
            newValue.setValue(value.getValue());
            value = newValue;
        }
        return (T)value;
    }

    public static IQueryParameterAnd<?> parseQueryParams(FhirContext theContext, RestSearchParameterTypeEnum paramType, String theUnqualifiedParamName, List<QualifiedParamList> theParameters) {
        QueryParameterAndBinder binder = null;
        switch (paramType) {
            case COMPOSITE: {
                throw new UnsupportedOperationException();
            }
            case DATE: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)DateAndListParam.class, Collections.emptyList());
                break;
            }
            case NUMBER: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)NumberAndListParam.class, Collections.emptyList());
                break;
            }
            case QUANTITY: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)QuantityAndListParam.class, Collections.emptyList());
                break;
            }
            case REFERENCE: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)ReferenceAndListParam.class, Collections.emptyList());
                break;
            }
            case STRING: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)StringAndListParam.class, Collections.emptyList());
                break;
            }
            case TOKEN: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)TokenAndListParam.class, Collections.emptyList());
                break;
            }
            case URI: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)UriAndListParam.class, Collections.emptyList());
                break;
            }
            case HAS: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)HasAndListParam.class, Collections.emptyList());
            }
        }
        return binder.parse(theContext, theUnqualifiedParamName, (List)theParameters);
    }

    public static IQueryParameterAnd<?> parseQueryParams(FhirContext theContext, RuntimeSearchParam theParamDef, String theUnqualifiedParamName, List<QualifiedParamList> theParameters) {
        RestSearchParameterTypeEnum paramType = theParamDef.getParamType();
        return ParameterUtil.parseQueryParams(theContext, paramType, theUnqualifiedParamName, theParameters);
    }

    public static String escape(String theValue) {
        if (theValue == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theValue.length(); ++i) {
            char next = theValue.charAt(i);
            switch (next) {
                case '$': 
                case ',': 
                case '\\': 
                case '|': {
                    b.append('\\');
                    break;
                }
            }
            b.append(next);
        }
        return b.toString();
    }

    public static String escapeAndUrlEncode(String theValue) {
        if (theValue == null) {
            return null;
        }
        String escaped = ParameterUtil.escape(theValue);
        return UrlUtil.escape(escaped);
    }

    public static String escapeWithDefault(Object theValue) {
        if (theValue == null) {
            return "";
        }
        return ParameterUtil.escape(theValue.toString());
    }

    public static Integer findIdParameterIndex(Method theMethod, FhirContext theContext) {
        Integer index = ParameterUtil.findParamAnnotationIndex(theMethod, IdParam.class);
        if (index != null) {
            boolean usesHapiId;
            Class<?> paramType = theMethod.getParameterTypes()[index];
            if (IIdType.class.equals(paramType)) {
                return index;
            }
            boolean isRi = theContext.getVersion().getVersion().isRi();
            if (isRi == (usesHapiId = IdDt.class.equals(paramType))) {
                throw new ConfigurationException("Method uses the wrong Id datatype (IdDt / IdType) for the given context FHIR version: " + theMethod.toString());
            }
        }
        return index;
    }

    public static Integer findParamAnnotationIndex(Method theMethod, Class<?> toFind) {
        int paramIndex = 0;
        for (Annotation[] annotations : theMethod.getParameterAnnotations()) {
            for (int annotationIndex = 0; annotationIndex < annotations.length; ++annotationIndex) {
                Annotation nextAnnotation = annotations[annotationIndex];
                Class<? extends Annotation> class1 = nextAnnotation.annotationType();
                if (!toFind.isAssignableFrom(class1)) continue;
                return paramIndex;
            }
            ++paramIndex;
        }
        return null;
    }

    public static Integer findTagListParameterIndex(Method theMethod) {
        return ParameterUtil.findParamAnnotationIndex(theMethod, TagListParam.class);
    }

    public static Object fromInteger(Class<?> theType, IntegerDt theArgument) {
        if (theType.equals(Integer.class)) {
            if (theArgument == null) {
                return null;
            }
            return theArgument.getValue();
        }
        IPrimitiveType retVal = (IPrimitiveType)ReflectionUtil.newInstance(theType);
        retVal.setValueAsString(theArgument.getValueAsString());
        return retVal;
    }

    public static boolean isBindableIntegerType(Class<?> theClass) {
        return Integer.class.isAssignableFrom(theClass) || IPrimitiveType.class.isAssignableFrom(theClass);
    }

    public static int nonEscapedIndexOf(String theString, char theCharacter) {
        for (int i = 0; i < theString.length(); ++i) {
            if (theString.charAt(i) != theCharacter || i != 0 && theString.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    public static String parseETagValue(String value) {
        String eTagVersion = (value = value.trim()).length() > 1 ? (value.charAt(value.length() - 1) == '\"' ? (value.charAt(0) == '\"' ? value.substring(1, value.length() - 1) : (value.length() > 3 && value.charAt(0) == 'W' && value.charAt(1) == '/' && value.charAt(2) == '\"' ? value.substring(3, value.length() - 1) : value)) : value) : value;
        return eTagVersion;
    }

    public static IQueryParameterOr<?> singleton(final IQueryParameterType theParam, String theParamName) {
        return new IQueryParameterOr<IQueryParameterType>(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<IQueryParameterType> getValuesAsQueryTokens() {
                return Collections.singletonList(theParam);
            }

            @Override
            public void setValuesAsQueryTokens(FhirContext theContext, String theParamName, QualifiedParamList theParameters) {
                if (theParameters.isEmpty()) {
                    return;
                }
                if (theParameters.size() > 1) {
                    throw new IllegalArgumentException("Type " + theParam.getClass().getCanonicalName() + " does not support multiple values");
                }
                theParam.setValueAsQueryToken(theContext, theParamName, theParameters.getQualifier(), (String)theParameters.get(0));
            }
        };
    }

    static List<String> splitParameterString(String theInput, boolean theUnescapeComponents) {
        return ParameterUtil.splitParameterString(theInput, ',', theUnescapeComponents);
    }

    static List<String> splitParameterString(String theInput, char theDelimiter, boolean theUnescapeComponents) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (theInput != null) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < theInput.length(); ++i) {
                char next = theInput.charAt(i);
                if (next == theDelimiter) {
                    if (i == 0) {
                        b.append(next);
                        continue;
                    }
                    char prevChar = theInput.charAt(i - 1);
                    if (prevChar == '\\') {
                        b.append(next);
                        continue;
                    }
                    if (b.length() > 0) {
                        retVal.add(b.toString());
                    } else {
                        retVal.add(null);
                    }
                    b.setLength(0);
                    continue;
                }
                b.append(next);
            }
            if (b.length() > 0) {
                retVal.add(b.toString());
            }
        }
        if (theUnescapeComponents) {
            for (int i = 0; i < retVal.size(); ++i) {
                retVal.set(i, ParameterUtil.unescape(retVal.get(i)));
            }
        }
        return retVal;
    }

    public static IntegerDt toInteger(Object theArgument) {
        if (theArgument instanceof IntegerDt) {
            return (IntegerDt)theArgument;
        }
        if (theArgument instanceof Integer) {
            return new IntegerDt((Integer)theArgument);
        }
        if (theArgument instanceof IPrimitiveType) {
            IPrimitiveType pt = (IPrimitiveType)theArgument;
            return new IntegerDt(pt.getValueAsString());
        }
        return null;
    }

    public static String unescape(String theValue) {
        if (theValue == null) {
            return theValue;
        }
        if (theValue.indexOf(92) == -1) {
            return theValue;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theValue.length(); ++i) {
            char next = theValue.charAt(i);
            if (next == '\\') {
                if (i == theValue.length() - 1) {
                    b.append(next);
                    continue;
                }
                switch (theValue.charAt(i + 1)) {
                    case '$': 
                    case ',': 
                    case '\\': 
                    case '|': {
                        break;
                    }
                    default: {
                        b.append(next);
                        break;
                    }
                }
                continue;
            }
            b.append(next);
        }
        return b.toString();
    }
}

