/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation.schematron;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationContext;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.schematron.ISchematronResource;
import com.phloc.schematron.SchematronHelper;
import com.phloc.schematron.xslt.SchematronResourceSCH;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;

public class SchematronBaseValidator
implements IValidatorModule {
    private Map<Class<? extends IBaseResource>, ISchematronResource> myClassToSchematron = new HashMap<Class<? extends IBaseResource>, ISchematronResource>();
    private FhirContext myCtx;

    public SchematronBaseValidator(FhirContext theContext) {
        this.myCtx = theContext;
    }

    @Override
    public void validateResource(IValidationContext<IBaseResource> theCtx) {
        String resourceAsString;
        StreamSource source;
        ISchematronResource sch;
        SchematronOutputType results;
        if (theCtx.getResource() instanceof IBaseBundle) {
            IBaseBundle bundle = (IBaseBundle)theCtx.getResource();
            List<IBaseResource> subResources = BundleUtil.toListOfResources(this.myCtx, bundle);
            for (IBaseResource nextSubResource : subResources) {
                this.validateResource(ValidationContext.subContext(theCtx, nextSubResource));
            }
        }
        if ((results = SchematronHelper.applySchematron((ISchematronResource)(sch = this.getSchematron(theCtx)), (Source)(source = new StreamSource(new StringReader(resourceAsString = theCtx.getResourceAsStringEncoding() == EncodingEnum.XML ? theCtx.getResourceAsString() : theCtx.getFhirContext().newXmlParser().encodeResourceToString(theCtx.getResource())))))) == null) {
            return;
        }
        IResourceErrorGroup errors = SchematronHelper.convertToResourceErrorGroup((SchematronOutputType)results, (String)theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName());
        if (errors.getAllErrors().containsOnlySuccess()) {
            return;
        }
        block6: for (IResourceError next : errors.getAllErrors().getAllResourceErrors()) {
            ResultSeverityEnum severity;
            switch (next.getErrorLevel()) {
                case ERROR: {
                    severity = ResultSeverityEnum.ERROR;
                    break;
                }
                case FATAL_ERROR: {
                    severity = ResultSeverityEnum.FATAL;
                    break;
                }
                case WARN: {
                    severity = ResultSeverityEnum.WARNING;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            String details = next.getAsString(Locale.getDefault());
            SingleValidationMessage message = new SingleValidationMessage();
            message.setMessage(details);
            message.setLocationLine(next.getLocation().getLineNumber());
            message.setLocationCol(next.getLocation().getColumnNumber());
            message.setLocationString(next.getLocation().getAsString());
            message.setSeverity(severity);
            theCtx.addValidationMessage(message);
        }
    }

    private ISchematronResource getSchematron(IValidationContext<IBaseResource> theCtx) {
        Class<?> resource = theCtx.getResource().getClass();
        Class baseResourceClass = theCtx.getFhirContext().getResourceDefinition(resource).getBaseDefinition().getImplementingClass();
        return this.getSchematronAndCache(theCtx, baseResourceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchematronResource getSchematronAndCache(IValidationContext<IBaseResource> theCtx, Class<? extends IBaseResource> theClass) {
        Map<Class<? extends IBaseResource>, ISchematronResource> map = this.myClassToSchematron;
        synchronized (map) {
            ISchematronResource retVal = this.myClassToSchematron.get(theClass);
            if (retVal != null) {
                return retVal;
            }
            String pathToBase = this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName().toLowerCase() + ".sch";
            InputStream baseIs = FhirValidator.class.getResourceAsStream(pathToBase);
            try {
                if (baseIs == null) {
                    throw new InternalErrorException("Failed to load schematron for resource '" + theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName() + "'. " + "Note that as of HAPI FHIR 1.2, DSTU2 validation files are kept in a separate JAR (hapi-fhir-validation-resources-XXX.jar) which must be added to your classpath. See the HAPI FHIR download page for more information.");
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)baseIs);
            }
            retVal = SchematronResourceSCH.fromClassPath((String)pathToBase);
            this.myClassToSchematron.put(theClass, retVal);
            return retVal;
        }
    }
}

