/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;

public class RuntimeResourceDefinition
extends BaseRuntimeElementCompositeDefinition<IBaseResource> {
    private Class<? extends IBaseResource> myBaseType;
    private Map<String, List<RuntimeSearchParam>> myCompartmentNameToSearchParams;
    private FhirContext myContext;
    private String myId;
    private Map<String, RuntimeSearchParam> myNameToSearchParam = new LinkedHashMap<String, RuntimeSearchParam>();
    private IBaseResource myProfileDef;
    private String myResourceProfile;
    private List<RuntimeSearchParam> mySearchParams;
    private final FhirVersionEnum myStructureVersion;
    private volatile RuntimeResourceDefinition myBaseDefinition;

    public RuntimeResourceDefinition(FhirContext theContext, String theResourceName, Class<? extends IBaseResource> theClass, ResourceDef theResourceAnnotation, boolean theStandardType, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super(theResourceName, theClass, theStandardType, theContext, theClassToElementDefinitions);
        IBaseResource instance;
        this.myContext = theContext;
        this.myResourceProfile = theResourceAnnotation.profile();
        this.myId = theResourceAnnotation.id();
        try {
            instance = theClass.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException(this.myContext.getLocalizer().getMessage(this.getClass(), "nonInstantiableType", theClass.getName(), e.toString()), e);
        }
        this.myStructureVersion = instance.getStructureFhirVersionEnum();
        if (this.myStructureVersion != theContext.getVersion().getVersion()) {
            throw new ConfigurationException(this.myContext.getLocalizer().getMessage(this.getClass(), "typeWrongVersion", new Object[]{theContext.getVersion().getVersion(), theClass.getName(), this.myStructureVersion}));
        }
    }

    public void addSearchParam(RuntimeSearchParam theParam) {
        this.myNameToSearchParam.put(theParam.getName(), theParam);
    }

    public RuntimeResourceDefinition getBaseDefinition() {
        this.validateSealed();
        if (this.myBaseDefinition == null) {
            this.myBaseDefinition = this.myContext.getResourceDefinition(this.myBaseType);
        }
        return this.myBaseDefinition;
    }

    @Override
    public BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
        return BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE;
    }

    public String getId() {
        return this.myId;
    }

    public <T> Class<T> getImplementingClass(Class<T> theClass) {
        if (!theClass.isAssignableFrom(this.getImplementingClass())) {
            throw new ConfigurationException("Unable to convert " + this.getImplementingClass() + " to " + theClass);
        }
        return this.getImplementingClass();
    }

    @Deprecated
    public String getResourceProfile() {
        return this.myResourceProfile;
    }

    public String getResourceProfile(String theServerBase) {
        String profile;
        this.validateSealed();
        if (!this.myResourceProfile.isEmpty()) {
            profile = this.myResourceProfile;
        } else if (!this.myId.isEmpty()) {
            profile = this.myId;
        } else {
            return "";
        }
        if (!UrlUtil.isValid(profile)) {
            String resourceName = "/StructureDefinition/";
            String profileWithUrl = theServerBase + resourceName + profile;
            if (UrlUtil.isValid(profileWithUrl)) {
                return profileWithUrl;
            }
        }
        return profile;
    }

    public RuntimeSearchParam getSearchParam(String theName) {
        this.validateSealed();
        return this.myNameToSearchParam.get(theName);
    }

    public List<RuntimeSearchParam> getSearchParams() {
        this.validateSealed();
        return this.mySearchParams;
    }

    public List<RuntimeSearchParam> getSearchParamsForCompartmentName(String theCompartmentName) {
        this.validateSealed();
        List<RuntimeSearchParam> retVal = this.myCompartmentNameToSearchParams.get(theCompartmentName);
        if (retVal == null) {
            return Collections.emptyList();
        }
        return retVal;
    }

    public FhirVersionEnum getStructureVersion() {
        return this.myStructureVersion;
    }

    public boolean isBundle() {
        return "Bundle".equals(this.getName());
    }

    @Override
    public void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super.sealAndInitialize(theContext, theClassToElementDefinitions);
        this.myNameToSearchParam = Collections.unmodifiableMap(this.myNameToSearchParam);
        ArrayList<RuntimeSearchParam> searchParams = new ArrayList<RuntimeSearchParam>(this.myNameToSearchParam.values());
        Collections.sort(searchParams, new Comparator<RuntimeSearchParam>(){

            @Override
            public int compare(RuntimeSearchParam theArg0, RuntimeSearchParam theArg1) {
                return theArg0.getName().compareTo(theArg1.getName());
            }
        });
        this.mySearchParams = Collections.unmodifiableList(searchParams);
        HashMap compartmentNameToSearchParams = new HashMap();
        for (RuntimeSearchParam next : searchParams) {
            if (next.getProvidesMembershipInCompartments() == null) continue;
            for (String nextCompartment : next.getProvidesMembershipInCompartments()) {
                if (!compartmentNameToSearchParams.containsKey(nextCompartment)) {
                    compartmentNameToSearchParams.put(nextCompartment, new ArrayList());
                }
                ((List)compartmentNameToSearchParams.get(nextCompartment)).add(next);
            }
        }
        this.myCompartmentNameToSearchParams = Collections.unmodifiableMap(compartmentNameToSearchParams);
        Class target = this.getImplementingClass();
        this.myBaseType = target;
        do {
            if (!IBaseResource.class.isAssignableFrom(target = target.getSuperclass()) || target.getAnnotation(ResourceDef.class) == null) continue;
            this.myBaseType = target;
        } while (!target.equals(Object.class));
        if (this.hasExtensions() && IAnyResource.class.isAssignableFrom(this.getImplementingClass()) && !IDomainResource.class.isAssignableFrom(this.getImplementingClass())) {
            throw new ConfigurationException("Class \"" + this.getImplementingClass() + "\" is invalid. This resource type is not a DomainResource, it must not have extensions");
        }
    }

    @Deprecated
    public synchronized IBaseResource toProfile() {
        IBaseResource retVal;
        this.validateSealed();
        if (this.myProfileDef != null) {
            return this.myProfileDef;
        }
        this.myProfileDef = retVal = this.myContext.getVersion().generateProfile(this, null);
        return retVal;
    }

    public synchronized IBaseResource toProfile(String theServerBase) {
        IBaseResource retVal;
        this.validateSealed();
        if (this.myProfileDef != null) {
            return this.myProfileDef;
        }
        this.myProfileDef = retVal = this.myContext.getVersion().generateProfile(this, theServerBase);
        return retVal;
    }
}

