/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.FhirContext;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface IContextValidationSupport<EVS_IN, EVS_OUT, SDT, CST, CDCT, IST> {
    public EVS_OUT expandValueSet(FhirContext var1, EVS_IN var2);

    public List<IBaseResource> fetchAllConformanceResources(FhirContext var1);

    public List<SDT> fetchAllStructureDefinitions(FhirContext var1);

    public CST fetchCodeSystem(FhirContext var1, String var2);

    public <T extends IBaseResource> T fetchResource(FhirContext var1, Class<T> var2, String var3);

    public SDT fetchStructureDefinition(FhirContext var1, String var2);

    public boolean isCodeSystemSupported(FhirContext var1, String var2);

    public CodeValidationResult<CDCT, IST> validateCode(FhirContext var1, String var2, String var3, String var4);

    public static class CodeValidationResult<CDCT, IST> {
        private CDCT myDefinition;
        private String myMessage;
        private IST mySeverity;
        private String myCodeSystemName;
        private String myCodeSystemVersion;
        private List<BaseConceptProperty> myProperties;

        public CodeValidationResult(CDCT theNext) {
            this.myDefinition = theNext;
        }

        public CodeValidationResult(IST severity, String message) {
            this.mySeverity = severity;
            this.myMessage = message;
        }

        public CodeValidationResult(IST severity, String message, CDCT definition) {
            this.mySeverity = severity;
            this.myMessage = message;
            this.myDefinition = definition;
        }

        public CDCT asConceptDefinition() {
            return this.myDefinition;
        }

        public String getCodeSystemName() {
            return this.myCodeSystemName;
        }

        public void setCodeSystemName(String theCodeSystemName) {
            this.myCodeSystemName = theCodeSystemName;
        }

        public String getCodeSystemVersion() {
            return this.myCodeSystemVersion;
        }

        public void setCodeSystemVersion(String theCodeSystemVersion) {
            this.myCodeSystemVersion = theCodeSystemVersion;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public List<BaseConceptProperty> getProperties() {
            return this.myProperties;
        }

        public void setProperties(List<BaseConceptProperty> theProperties) {
            this.myProperties = theProperties;
        }

        public IST getSeverity() {
            return this.mySeverity;
        }

        public boolean isOk() {
            return this.myDefinition != null;
        }
    }

    public static class CodingConceptProperty
    extends BaseConceptProperty {
        private final String myCode;
        private final String myCodeSystem;
        private final String myDisplay;

        public CodingConceptProperty(String theName, String theCodeSystem, String theCode, String theDisplay) {
            super(theName);
            this.myCodeSystem = theCodeSystem;
            this.myCode = theCode;
            this.myDisplay = theDisplay;
        }

        public String getCode() {
            return this.myCode;
        }

        public String getCodeSystem() {
            return this.myCodeSystem;
        }

        public String getDisplay() {
            return this.myDisplay;
        }
    }

    public static class StringConceptProperty
    extends BaseConceptProperty {
        private final String myValue;

        public StringConceptProperty(String theName, String theValue) {
            super(theName);
            this.myValue = theValue;
        }

        public String getValue() {
            return this.myValue;
        }
    }

    public static abstract class BaseConceptProperty {
        private final String myPropertyName;

        protected BaseConceptProperty(String thePropertyName) {
            this.myPropertyName = thePropertyName;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }
    }
}

