/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BundleUtil {
    public static String getLinkUrlOfType(FhirContext theContext, IBaseBundle theBundle, String theLinkRelation) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("link");
        List<IBase> links = entryChild.getAccessor().getValues(theBundle);
        for (IBase nextLink : links) {
            boolean isRightRel = false;
            BaseRuntimeElementCompositeDefinition relDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(nextLink.getClass());
            BaseRuntimeChildDefinition relChild = relDef.getChildByName("relation");
            List<IBase> relValues = relChild.getAccessor().getValues(nextLink);
            for (IBase next : relValues) {
                IPrimitiveType nextValue = (IPrimitiveType)next;
                if (!theLinkRelation.equals(nextValue.getValueAsString())) continue;
                isRightRel = true;
            }
            if (!isRightRel) continue;
            BaseRuntimeElementCompositeDefinition linkDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(nextLink.getClass());
            BaseRuntimeChildDefinition urlChild = linkDef.getChildByName("url");
            List<IBase> values = urlChild.getAccessor().getValues(nextLink);
            for (IBase nextUrl : values) {
                IPrimitiveType nextValue = (IPrimitiveType)nextUrl;
                if (!StringUtils.isNotBlank((CharSequence)nextValue.getValueAsString())) continue;
                return nextValue.getValueAsString();
            }
        }
        return null;
    }

    public static List<Pair<String, IBaseResource>> getBundleEntryUrlsAndResources(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        BaseRuntimeChildDefinition requestChild = entryChildElem.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestDef = (BaseRuntimeElementCompositeDefinition)requestChild.getChildByName("request");
        BaseRuntimeChildDefinition urlChild = requestDef.getChildByName("url");
        ArrayList<Pair<String, IBaseResource>> retVal = new ArrayList<Pair<String, IBaseResource>>(entries.size());
        for (IBase nextEntry : entries) {
            String url = null;
            IBaseResource resource = null;
            for (IBase nextEntryValue : requestChild.getAccessor().getValues(nextEntry)) {
                for (IBase nextUrlValue : urlChild.getAccessor().getValues(nextEntryValue)) {
                    url = (String)((IPrimitiveType)nextUrlValue).getValue();
                }
            }
            for (IBase nextValue : resourceChild.getAccessor().getValues(nextEntry)) {
                resource = (IBaseResource)nextValue;
            }
            retVal.add((Pair<String, IBaseResource>)Pair.of(url, resource));
        }
        return retVal;
    }

    public static String getBundleType(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("type");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        if (entries.size() > 0) {
            IPrimitiveType typeElement = (IPrimitiveType)entries.get(0);
            return typeElement.getValueAsString();
        }
        return null;
    }

    public static Integer getTotal(FhirContext theContext, IBaseBundle theBundle) {
        IPrimitiveType typeElement;
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("total");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        if (entries.size() > 0 && (typeElement = (IPrimitiveType)entries.get(0)) != null && typeElement.getValue() != null) {
            return ((Number)typeElement.getValue()).intValue();
        }
        return null;
    }

    public static List<BundleEntryParts> toListOfEntries(FhirContext theContext, IBaseBundle theBundle) {
        ArrayList<BundleEntryParts> retVal = new ArrayList<BundleEntryParts>();
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        BaseRuntimeChildDefinition requestChild = entryChildElem.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestElem = (BaseRuntimeElementCompositeDefinition)requestChild.getChildByName("request");
        BaseRuntimeChildDefinition urlChild = requestElem.getChildByName("url");
        BaseRuntimeChildDefinition methodChild = requestElem.getChildByName("method");
        IBaseResource resource = null;
        String url = null;
        RequestTypeEnum requestType = null;
        for (IBase nextEntry : entries) {
            for (IBase next : resourceChild.getAccessor().getValues(nextEntry)) {
                resource = (IBaseResource)next;
            }
            for (IBase nextRequest : requestChild.getAccessor().getValues(nextEntry)) {
                for (IBase nextUrl : urlChild.getAccessor().getValues(nextRequest)) {
                    url = ((IPrimitiveType)nextUrl).getValueAsString();
                }
                for (IBase nextUrl : methodChild.getAccessor().getValues(nextRequest)) {
                    String methodString = ((IPrimitiveType)nextUrl).getValueAsString();
                    if (!StringUtils.isNotBlank((CharSequence)methodString)) continue;
                    requestType = RequestTypeEnum.valueOf(methodString);
                }
            }
            retVal.add(new BundleEntryParts(requestType, url, resource));
        }
        return retVal;
    }

    public static List<IBaseResource> toListOfResources(FhirContext theContext, IBaseBundle theBundle) {
        return BundleUtil.toListOfResourcesOfType(theContext, theBundle, null);
    }

    public static <T extends IBaseResource> List<T> toListOfResourcesOfType(FhirContext theContext, IBaseBundle theBundle, Class<T> theTypeToInclude) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        for (IBase nextEntry : entries) {
            for (IBase next : resourceChild.getAccessor().getValues(nextEntry)) {
                if (theTypeToInclude != null && !theTypeToInclude.isAssignableFrom(next.getClass())) continue;
                retVal.add((IBaseResource)next);
            }
        }
        return retVal;
    }

    public static class BundleEntryParts {
        private final RequestTypeEnum myRequestType;
        private final IBaseResource myResource;
        private final String myUrl;

        BundleEntryParts(RequestTypeEnum theRequestType, String theUrl, IBaseResource theResource) {
            this.myRequestType = theRequestType;
            this.myUrl = theUrl;
            this.myResource = theResource;
        }

        public RequestTypeEnum getRequestType() {
            return this.myRequestType;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }

        public String getUrl() {
            return this.myUrl;
        }
    }
}

