/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.XmlDetectionUtil;
import ca.uhn.fhir.util.XmlUtil;
import org.apache.commons.lang3.StringUtils;

@DatatypeDef(name="xhtml")
public class XhtmlDt
extends BasePrimitive<String> {
    private static final String DECL_XMLNS = " xmlns=\"http://www.w3.org/1999/xhtml\"";
    public static final String DIV_OPEN_FIRST = "<div xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final long serialVersionUID = 1L;

    public XhtmlDt() {
    }

    @SimpleSetter
    public XhtmlDt(@SimpleSetter.Parameter(name="theTextDiv") String theTextDiv) {
        this.setValueAsString(theTextDiv);
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    public boolean hasContent() {
        return StringUtils.isNotBlank((CharSequence)this.getValue());
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && (this.getValue() == null || this.getValue().isEmpty());
    }

    @Override
    protected String parse(String theValue) {
        if (XmlDetectionUtil.isStaxPresent()) {
            XmlUtil.parse(theValue);
        }
        return theValue;
    }

    @Override
    public String getValue() {
        return (String)super.getValue();
    }

    @Override
    public BasePrimitive<String> setValue(String theValue) throws DataFormatException {
        return super.setValue(theValue);
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        if (theValue == null || theValue.isEmpty()) {
            super.setValueAsString(null);
        } else {
            String value = theValue.trim();
            value = XhtmlDt.preprocessXhtmlNamespaceDeclaration(value);
            super.setValueAsString(value);
        }
    }

    public static String preprocessXhtmlNamespaceDeclaration(String value) {
        boolean hasProcessingInstruction;
        int firstTagIndex;
        if (value.charAt(0) != '<') {
            value = DIV_OPEN_FIRST + value + "</div>";
        }
        if ((firstTagIndex = value.indexOf("<", (hasProcessingInstruction = value.startsWith("<?")) ? 1 : 0)) != -1) {
            String firstTag;
            int firstTagEnd = value.indexOf(">", firstTagIndex);
            int firstSlash = value.indexOf("/", firstTagIndex);
            if (firstTagEnd != -1 && firstSlash > firstTagEnd && !(firstTag = value.substring(firstTagIndex, firstTagEnd)).contains(" xmlns")) {
                value = value.substring(0, firstTagEnd) + DECL_XMLNS + value.substring(firstTagEnd);
            }
        }
        return value;
    }
}

