/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.parser.json.JsonLikeValue;

public class StrictErrorHandler
implements IParserErrorHandler {
    @Override
    public void containedResourceWithNoId(IParserErrorHandler.IParseLocation theLocation) {
        throw new DataFormatException("Resource has contained child resource with no ID");
    }

    @Override
    public void incorrectJsonType(IParserErrorHandler.IParseLocation theLocation, String theElementName, JsonLikeValue.ValueType theExpected, JsonLikeValue.ScalarType theExpectedScalarType, JsonLikeValue.ValueType theFound, JsonLikeValue.ScalarType theFoundScalarType) {
        String message = LenientErrorHandler.createIncorrectJsonTypeMessage(theElementName, theExpected, theExpectedScalarType, theFound, theFoundScalarType);
        throw new DataFormatException(message);
    }

    @Override
    public void invalidValue(IParserErrorHandler.IParseLocation theLocation, String theValue, String theError) {
        throw new DataFormatException("Invalid attribute value \"" + theValue + "\": " + theError);
    }

    @Override
    public void missingRequiredElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        StringBuilder b = new StringBuilder();
        b.append("Resource is missing required element '");
        b.append(theElementName);
        b.append("'");
        if (theLocation != null) {
            b.append(" in parent element '");
            b.append(theLocation.getParentElementName());
            b.append("'");
        }
        throw new DataFormatException(b.toString());
    }

    @Override
    public void unexpectedRepeatingElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        throw new DataFormatException("Multiple repetitions of non-repeatable element '" + theElementName + "' found during parse");
    }

    @Override
    public void unknownAttribute(IParserErrorHandler.IParseLocation theLocation, String theAttributeName) {
        throw new DataFormatException("Unknown attribute '" + theAttributeName + "' found during parse");
    }

    @Override
    public void unknownElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        throw new DataFormatException("Unknown element '" + theElementName + "' found during parse");
    }

    @Override
    public void unknownReference(IParserErrorHandler.IParseLocation theLocation, String theReference) {
        throw new DataFormatException("Resource has invalid reference: " + theReference);
    }

    @Override
    public void extensionContainsValueAndNestedExtensions(IParserErrorHandler.IParseLocation theLocation) {
        throw new DataFormatException("Extension contains both a value and nested extensions: " + theLocation);
    }
}

