/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.StringCriterion;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;

public class NumberClientParam
extends BaseClientParam
implements IParam {
    private String myParamName;

    public NumberClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    public IMatches<ICriterion<NumberClientParam>> exactly() {
        return new IMatches<ICriterion<NumberClientParam>>(){

            @Override
            public ICriterion<NumberClientParam> number(long theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), Long.toString(theNumber));
            }

            @Override
            public ICriterion<NumberClientParam> number(String theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), theNumber);
            }
        };
    }

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public IMatches<ICriterion<NumberClientParam>> greaterThan() {
        return new IMatches<ICriterion<NumberClientParam>>(){

            @Override
            public ICriterion<NumberClientParam> number(long theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.GREATERTHAN, Long.toString(theNumber));
            }

            @Override
            public ICriterion<NumberClientParam> number(String theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.GREATERTHAN, theNumber);
            }
        };
    }

    public IMatches<ICriterion<NumberClientParam>> greaterThanOrEqual() {
        return new IMatches<ICriterion<NumberClientParam>>(){

            @Override
            public ICriterion<NumberClientParam> number(long theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.GREATERTHAN_OR_EQUALS, Long.toString(theNumber));
            }

            @Override
            public ICriterion<NumberClientParam> number(String theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theNumber);
            }
        };
    }

    public IMatches<ICriterion<NumberClientParam>> lessThan() {
        return new IMatches<ICriterion<NumberClientParam>>(){

            @Override
            public ICriterion<NumberClientParam> number(long theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.LESSTHAN, Long.toString(theNumber));
            }

            @Override
            public ICriterion<NumberClientParam> number(String theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.LESSTHAN, theNumber);
            }
        };
    }

    public IMatches<ICriterion<NumberClientParam>> lessThanOrEqual() {
        return new IMatches<ICriterion<NumberClientParam>>(){

            @Override
            public ICriterion<NumberClientParam> number(long theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.LESSTHAN_OR_EQUALS, Long.toString(theNumber));
            }

            @Override
            public ICriterion<NumberClientParam> number(String theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), ParamPrefixEnum.LESSTHAN_OR_EQUALS, theNumber);
            }
        };
    }

    public IMatches<ICriterion<NumberClientParam>> withPrefix(final ParamPrefixEnum thePrefix) {
        return new IMatches<ICriterion<NumberClientParam>>(){

            @Override
            public ICriterion<NumberClientParam> number(long theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), thePrefix, Long.toString(theNumber));
            }

            @Override
            public ICriterion<NumberClientParam> number(String theNumber) {
                return new StringCriterion<NumberClientParam>(NumberClientParam.this.getParamName(), thePrefix, theNumber);
            }
        };
    }

    public static interface IMatches<T> {
        public T number(long var1);

        public T number(String var1);
    }
}

