/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;

class TokenCriterion
implements ICriterion<TokenClientParam>,
ICriterionInternal {
    private String myValue;
    private String myName;

    public TokenCriterion(String theName, String theSystem, String theCode) {
        this.myName = theName;
        this.myValue = this.toValue(theSystem, theCode);
    }

    private String toValue(String theSystem, String theCode) {
        String system = ParameterUtil.escape(theSystem);
        String code = ParameterUtil.escape(theCode);
        String value = StringUtils.isNotBlank((CharSequence)system) ? system + "|" + StringUtils.defaultString((String)code) : (system == null ? StringUtils.defaultString((String)code) : "|" + StringUtils.defaultString((String)code));
        return value;
    }

    public TokenCriterion(String theParamName, List<BaseIdentifierDt> theValue) {
        this.myName = theParamName;
        StringBuilder b = new StringBuilder();
        for (BaseIdentifierDt next : theValue) {
            if (next.getSystemElement().isEmpty() && next.getValueElement().isEmpty()) continue;
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(this.toValue(next.getSystemElement().getValueAsString(), (String)next.getValueElement().getValue()));
        }
        this.myValue = b.toString();
    }

    public TokenCriterion(String theParamName, String theSystem, Collection<String> theValues) {
        this.myName = theParamName;
        StringBuilder b = new StringBuilder();
        for (String next : theValues) {
            if (!StringUtils.isNotBlank((CharSequence)next)) continue;
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(this.toValue(theSystem, next));
        }
        this.myValue = b.toString();
    }

    public TokenCriterion(String theParamName, Collection<String> theCodes) {
        this(theParamName, null, theCodes);
    }

    public TokenCriterion(String theParamName, IBaseCoding ... theCodings) {
        this.myName = theParamName;
        StringBuilder b = new StringBuilder();
        if (theCodings != null) {
            for (IBaseCoding next : theCodings) {
                if (StringUtils.isBlank((CharSequence)next.getSystem()) && StringUtils.isBlank((CharSequence)next.getCode())) continue;
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(this.toValue(next.getSystem(), next.getCode()));
            }
        }
        this.myValue = b.toString();
    }

    @Override
    public String getParameterValue(FhirContext theContext) {
        return this.myValue;
    }

    @Override
    public String getParameterName() {
        return this.myName;
    }
}

