/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@CoverageIgnore
public class InternalCodingDt
extends BaseCodingDt
implements ICompositeDatatype {
    private static final long serialVersionUID = 993056016725918652L;
    @Child(name="system", type={UriDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Identity of the terminology system", formalDefinition="The identification of the code system that defines the meaning of the symbol in the code.")
    private UriDt mySystem;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Version of the system - if relevant", formalDefinition="The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured. and When the meaning is not guaranteed to be consistent, the version SHOULD be exchanged")
    private StringDt myVersion;
    @Child(name="code", type={CodeDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="Symbol in syntax defined by the system", formalDefinition="A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination)")
    private CodeDt myCode;
    @Child(name="display", type={StringDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Representation defined by the system", formalDefinition="A representation of the meaning of the code in the system, following the rules of the system.")
    private StringDt myDisplay;
    @Child(name="primary", type={BooleanDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="If this code was chosen directly by the user", formalDefinition="Indicates that this code was chosen by a user directly - i.e. off a pick list of available items (codes or displays)")
    private BooleanDt myPrimary;

    public InternalCodingDt() {
    }

    public InternalCodingDt(String theSystem, String theCode) {
        this.setSystem(theSystem);
        this.setCode(theCode);
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty(this.mySystem, this.myVersion, this.myCode, this.myDisplay, this.myPrimary);
    }

    @Override
    @Deprecated
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, this.mySystem, this.myVersion, this.myCode, this.myDisplay, this.myPrimary);
    }

    @Override
    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public InternalCodingDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    @Override
    public InternalCodingDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public InternalCodingDt setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public InternalCodingDt setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    @Override
    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public InternalCodingDt setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    @Override
    public InternalCodingDt setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }

    public StringDt getDisplay() {
        if (this.myDisplay == null) {
            this.myDisplay = new StringDt();
        }
        return this.myDisplay;
    }

    public InternalCodingDt setDisplay(StringDt theValue) {
        this.myDisplay = theValue;
        return this;
    }

    @Override
    public InternalCodingDt setDisplay(String theString) {
        this.myDisplay = new StringDt(theString);
        return this;
    }

    public BooleanDt getPrimary() {
        if (this.myPrimary == null) {
            this.myPrimary = new BooleanDt();
        }
        return this.myPrimary;
    }

    public InternalCodingDt setPrimary(BooleanDt theValue) {
        this.myPrimary = theValue;
        return this;
    }

    public InternalCodingDt setPrimary(boolean theBoolean) {
        this.myPrimary = new BooleanDt(theBoolean);
        return this;
    }

    public BaseResourceReferenceDt getValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringDt getDisplayElement() {
        return this.getDisplay();
    }

    @Override
    @Deprecated
    public Boolean getMissing() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IQueryParameterType setMissing(Boolean theMissing) {
        throw new UnsupportedOperationException();
    }
}

