/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.bundle.BundleEntryMutator;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import ca.uhn.fhir.util.bundle.EntryListAccumulator;
import ca.uhn.fhir.util.bundle.ModifiableBundleEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BundleUtil {
    public static String getLinkUrlOfType(FhirContext theContext, IBaseBundle theBundle, String theLinkRelation) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("link");
        List<IBase> links = entryChild.getAccessor().getValues(theBundle);
        for (IBase nextLink : links) {
            boolean isRightRel = false;
            BaseRuntimeElementCompositeDefinition relDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(nextLink.getClass());
            BaseRuntimeChildDefinition relChild = relDef.getChildByName("relation");
            List<IBase> relValues = relChild.getAccessor().getValues(nextLink);
            for (IBase next : relValues) {
                IPrimitiveType nextValue = (IPrimitiveType)next;
                if (!theLinkRelation.equals(nextValue.getValueAsString())) continue;
                isRightRel = true;
            }
            if (!isRightRel) continue;
            BaseRuntimeElementCompositeDefinition linkDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(nextLink.getClass());
            BaseRuntimeChildDefinition urlChild = linkDef.getChildByName("url");
            List<IBase> values = urlChild.getAccessor().getValues(nextLink);
            for (IBase nextUrl : values) {
                IPrimitiveType nextValue = (IPrimitiveType)nextUrl;
                if (!StringUtils.isNotBlank((CharSequence)nextValue.getValueAsString())) continue;
                return nextValue.getValueAsString();
            }
        }
        return null;
    }

    public static List<Pair<String, IBaseResource>> getBundleEntryUrlsAndResources(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        BaseRuntimeChildDefinition requestChild = entryChildElem.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestDef = (BaseRuntimeElementCompositeDefinition)requestChild.getChildByName("request");
        BaseRuntimeChildDefinition urlChild = requestDef.getChildByName("url");
        ArrayList<Pair<String, IBaseResource>> retVal = new ArrayList<Pair<String, IBaseResource>>(entries.size());
        for (IBase nextEntry : entries) {
            String url = null;
            IBaseResource resource = null;
            for (IBase nextEntryValue : requestChild.getAccessor().getValues(nextEntry)) {
                for (IBase nextUrlValue : urlChild.getAccessor().getValues(nextEntryValue)) {
                    url = (String)((IPrimitiveType)nextUrlValue).getValue();
                }
            }
            for (IBase nextValue : resourceChild.getAccessor().getValues(nextEntry)) {
                resource = (IBaseResource)nextValue;
            }
            retVal.add((Pair<String, IBaseResource>)Pair.of(url, resource));
        }
        return retVal;
    }

    public static String getBundleType(FhirContext theContext, IBaseBundle theBundle) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("type");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        if (entries.size() > 0) {
            IPrimitiveType typeElement = (IPrimitiveType)entries.get(0);
            return typeElement.getValueAsString();
        }
        return null;
    }

    public static Integer getTotal(FhirContext theContext, IBaseBundle theBundle) {
        IPrimitiveType typeElement;
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("total");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        if (entries.size() > 0 && (typeElement = (IPrimitiveType)entries.get(0)) != null && typeElement.getValue() != null) {
            return ((Number)typeElement.getValue()).intValue();
        }
        return null;
    }

    public static void setTotal(FhirContext theContext, IBaseBundle theBundle, Integer theTotal) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("total");
        IPrimitiveType value = (IPrimitiveType)entryChild.getChildByName("total").newInstance();
        value.setValue(theTotal);
        entryChild.getMutator().setValue(theBundle, value);
    }

    public static List<BundleEntryParts> toListOfEntries(FhirContext theContext, IBaseBundle theBundle) {
        EntryListAccumulator entryListAccumulator = new EntryListAccumulator();
        BundleUtil.processEntries(theContext, theBundle, entryListAccumulator);
        return entryListAccumulator.getList();
    }

    public static void processEntries(FhirContext theContext, IBaseBundle theBundle, Consumer<ModifiableBundleEntry> theProcessor) {
        RuntimeResourceDefinition bundleDef = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChildDef = bundleDef.getChildByName("entry");
        List<IBase> entries = entryChildDef.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildContentsDef = (BaseRuntimeElementCompositeDefinition)entryChildDef.getChildByName("entry");
        BaseRuntimeChildDefinition fullUrlChildDef = entryChildContentsDef.getChildByName("fullUrl");
        BaseRuntimeChildDefinition resourceChildDef = entryChildContentsDef.getChildByName("resource");
        BaseRuntimeChildDefinition requestChildDef = entryChildContentsDef.getChildByName("request");
        BaseRuntimeElementCompositeDefinition requestChildContentsDef = (BaseRuntimeElementCompositeDefinition)requestChildDef.getChildByName("request");
        BaseRuntimeChildDefinition requestUrlChildDef = requestChildContentsDef.getChildByName("url");
        BaseRuntimeChildDefinition requestIfNoneExistChildDef = requestChildContentsDef.getChildByName("ifNoneExist");
        BaseRuntimeChildDefinition methodChildDef = requestChildContentsDef.getChildByName("method");
        for (IBase nextEntry : entries) {
            IBaseResource resource = null;
            String url = null;
            Enum requestType = null;
            String conditionalUrl = null;
            String fullUrl = fullUrlChildDef.getAccessor().getFirstValueOrNull(nextEntry).map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
            for (IBase nextResource : resourceChildDef.getAccessor().getValues(nextEntry)) {
                resource = (IBaseResource)nextResource;
            }
            for (IBase nextRequest : requestChildDef.getAccessor().getValues(nextEntry)) {
                for (IBase nextUrl : requestUrlChildDef.getAccessor().getValues(nextRequest)) {
                    url = ((IPrimitiveType)nextUrl).getValueAsString();
                }
                for (IBase nextMethod : methodChildDef.getAccessor().getValues(nextRequest)) {
                    String methodString = ((IPrimitiveType)nextMethod).getValueAsString();
                    if (!StringUtils.isNotBlank((CharSequence)methodString)) continue;
                    requestType = RequestTypeEnum.valueOf(methodString);
                }
                if (requestType == null) continue;
                switch (1.$SwitchMap$ca$uhn$fhir$rest$api$RequestTypeEnum[requestType.ordinal()]) {
                    case 1: {
                        conditionalUrl = url != null && url.contains("?") ? url : null;
                        break;
                    }
                    case 2: {
                        List<IBase> ifNoneExistReps = requestIfNoneExistChildDef.getAccessor().getValues(nextRequest);
                        if (ifNoneExistReps.size() <= 0) break;
                        IPrimitiveType ifNoneExist = (IPrimitiveType)ifNoneExistReps.get(0);
                        conditionalUrl = ifNoneExist.getValueAsString();
                    }
                }
            }
            BundleEntryMutator mutator = new BundleEntryMutator(nextEntry, requestChildDef, requestChildContentsDef);
            ModifiableBundleEntry entry = new ModifiableBundleEntry(new BundleEntryParts(fullUrl, (RequestTypeEnum)requestType, url, resource, conditionalUrl), mutator);
            theProcessor.accept(entry);
        }
    }

    public static List<IBaseResource> toListOfResources(FhirContext theContext, IBaseBundle theBundle) {
        return BundleUtil.toListOfResourcesOfType(theContext, theBundle, IBaseResource.class);
    }

    public static <T extends IBaseResource> List<T> toListOfResourcesOfType(FhirContext theContext, IBaseBundle theBundle, Class<T> theTypeToInclude) {
        Objects.requireNonNull(theTypeToInclude, "ResourceType must not be null");
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theBundle);
        BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
        List<IBase> entries = entryChild.getAccessor().getValues(theBundle);
        BaseRuntimeElementCompositeDefinition entryChildElem = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
        BaseRuntimeChildDefinition resourceChild = entryChildElem.getChildByName("resource");
        for (IBase nextEntry : entries) {
            for (IBase next : resourceChild.getAccessor().getValues(nextEntry)) {
                if (!theTypeToInclude.isAssignableFrom(next.getClass())) continue;
                retVal.add((IBaseResource)next);
            }
        }
        return retVal;
    }

    public static boolean isDstu3TransactionPatch(FhirContext theContext, IBaseResource thePayloadResource) {
        boolean isPatch = false;
        if (thePayloadResource instanceof IBaseBinary) {
            String contentType = ((IBaseBinary)thePayloadResource).getContentType();
            try {
                PatchTypeEnum.forContentTypeOrThrowInvalidRequestException(theContext, contentType);
                isPatch = true;
            }
            catch (InvalidRequestException invalidRequestException) {
                // empty catch block
            }
        }
        return isPatch;
    }
}

