/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionUtil.class);
    private static String ourVersion;
    private static String ourBuildNumber;
    private static String ourBuildTime;

    public static String getBuildNumber() {
        return ourBuildNumber;
    }

    public static String getBuildTime() {
        return ourBuildTime;
    }

    public static String getVersion() {
        return ourVersion;
    }

    private static void initialize() {
        try (InputStream is = VersionUtil.class.getResourceAsStream("/ca/uhn/fhir/hapi-fhir-base-build.properties");){
            Properties p = new Properties();
            if (is != null) {
                p.load(is);
            }
            ourVersion = p.getProperty("hapifhir.version");
            ourVersion = (String)StringUtils.defaultIfBlank((CharSequence)ourVersion, (CharSequence)"(unknown)");
            ourBuildNumber = p.getProperty("hapifhir.buildnumber");
            ourBuildTime = p.getProperty("hapifhir.timestamp");
            if (System.getProperty("suppress_hapi_fhir_version_log") == null) {
                ourLog.info("HAPI FHIR version {} - Rev {}", (Object)ourVersion, (Object)StringUtils.right((String)ourBuildNumber, (int)10));
            }
        }
        catch (Exception e) {
            ourLog.warn("Unable to determine HAPI version information", (Throwable)e);
        }
    }

    static {
        VersionUtil.initialize();
    }
}

