/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;

public enum FhirVersionEnum {
    DSTU2("ca.uhn.fhir.model.dstu2.FhirDstu2", null, false, new Version("1.0.2")),
    DSTU2_HL7ORG("org.hl7.fhir.dstu2.hapi.ctx.FhirDstu2Hl7Org", DSTU2, true, new Version("1.0.2")),
    DSTU2_1("org.hl7.fhir.dstu2016may.hapi.ctx.FhirDstu2_1", null, true, new Version("1.4.0")),
    DSTU3("org.hl7.fhir.dstu3.hapi.ctx.FhirDstu3", null, true, new Dstu3Version()),
    R4("org.hl7.fhir.r4.hapi.ctx.FhirR4", null, true, new R4Version()),
    R5("org.hl7.fhir.r5.hapi.ctx.FhirR5", null, true, new R5Version());

    private final FhirVersionEnum myEquivalent;
    private final boolean myIsRi;
    private final String myVersionClass;
    private volatile Boolean myPresentOnClasspath;
    private volatile IFhirVersion myVersionImplementation;
    private String myFhirVersionString;

    private FhirVersionEnum(String theVersionClass, FhirVersionEnum theEquivalent, boolean theIsRi, IVersionProvider theVersionExtractor) {
        this.myVersionClass = theVersionClass;
        this.myEquivalent = theEquivalent;
        this.myFhirVersionString = theVersionExtractor.provideVersion();
        this.myIsRi = theIsRi;
    }

    public String getFhirVersionString() {
        return this.myFhirVersionString;
    }

    public IFhirVersion getVersionImplementation() {
        if (!this.isPresentOnClasspath()) {
            throw new IllegalStateException("Version " + this.name() + " is not present on classpath");
        }
        if (this.myVersionImplementation == null) {
            try {
                this.myVersionImplementation = (IFhirVersion)Class.forName(this.myVersionClass).newInstance();
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to instantiate FHIR version " + this.name(), (Throwable)e);
            }
        }
        return this.myVersionImplementation;
    }

    public boolean isEqualOrNewerThan(FhirVersionEnum theVersion) {
        return this.ordinal() >= theVersion.ordinal();
    }

    public boolean isEquivalentTo(FhirVersionEnum theVersion) {
        if (this.equals((Object)theVersion)) {
            return true;
        }
        if (this.myEquivalent != null) {
            return this.myEquivalent.equals((Object)theVersion);
        }
        return false;
    }

    public boolean isNewerThan(FhirVersionEnum theVersion) {
        return !this.isEquivalentTo(theVersion) && this.ordinal() > theVersion.ordinal();
    }

    public boolean isOlderThan(FhirVersionEnum theVersion) {
        return !this.isEquivalentTo(theVersion) && this.ordinal() < theVersion.ordinal();
    }

    public boolean isPresentOnClasspath() {
        Boolean retVal = this.myPresentOnClasspath;
        if (retVal == null) {
            try {
                Class.forName(this.myVersionClass);
                retVal = true;
            }
            catch (Exception e) {
                retVal = false;
            }
            this.myPresentOnClasspath = retVal;
        }
        return retVal;
    }

    public boolean isRi() {
        return this.myIsRi;
    }

    public FhirContext newContext() {
        switch (this) {
            case DSTU2: {
                return FhirContext.forDstu2();
            }
            case DSTU2_HL7ORG: {
                return FhirContext.forDstu2Hl7Org();
            }
            case DSTU2_1: {
                return FhirContext.forDstu2_1();
            }
            case DSTU3: {
                return FhirContext.forDstu3();
            }
            case R4: {
                return FhirContext.forR4();
            }
            case R5: {
                return FhirContext.forR5();
            }
        }
        throw new IllegalStateException("Unknown version: " + (Object)((Object)this));
    }

    public static FhirVersionEnum forVersionString(String theVersionString) {
        int secondDot;
        String versionString = theVersionString;
        int firstDot = versionString.indexOf(46);
        if (firstDot > 0 && (secondDot = versionString.indexOf(46, firstDot + 1)) > 0) {
            versionString = versionString.substring(0, secondDot);
        }
        for (FhirVersionEnum next : FhirVersionEnum.values()) {
            if (!next.getFhirVersionString().startsWith(versionString)) continue;
            return next;
        }
        switch (theVersionString) {
            case "DSTU2": {
                return DSTU2;
            }
            case "DSTU3": 
            case "STU3": {
                return DSTU3;
            }
            case "R4": {
                return R4;
            }
            case "R5": {
                return R5;
            }
        }
        return null;
    }

    private static class R5Version
    implements IVersionProvider {
        private String myVersion;

        R5Version() {
            try {
                Class<?> c = Class.forName("org.hl7.fhir.r5.model.Constants");
                this.myVersion = (String)c.getDeclaredField("VERSION").get(null);
            }
            catch (Exception e) {
                this.myVersion = "5.0.0";
            }
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }

    private static class R4Version
    implements IVersionProvider {
        private String myVersion;

        R4Version() {
            try {
                Class<?> c = Class.forName("org.hl7.fhir.r4.model.Constants");
                this.myVersion = (String)c.getDeclaredField("VERSION").get(null);
            }
            catch (Exception e) {
                this.myVersion = "4.0.2";
            }
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }

    private static class Dstu3Version
    implements IVersionProvider {
        private String myVersion;

        Dstu3Version() {
            try {
                Class<?> c = Class.forName("org.hl7.fhir.dstu3.model.Constants");
                this.myVersion = (String)c.getDeclaredField("VERSION").get(null);
            }
            catch (Exception e) {
                this.myVersion = "3.0.2";
            }
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }

    private static class Version
    implements IVersionProvider {
        private String myVersion;

        public Version(String theVersion) {
            this.myVersion = theVersion;
        }

        @Override
        public String provideVersion() {
            return this.myVersion;
        }
    }

    private static interface IVersionProvider {
        public String provideVersion();
    }
}

