/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeExtensionDtDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.IModelVisitor;
import ca.uhn.fhir.util.IModelVisitor2;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class FhirTerser {
    private static final Pattern COMPARTMENT_MATCHER_PATH = Pattern.compile("([a-zA-Z.]+)\\.where\\(resolve\\(\\) is ([a-zA-Z]+)\\)");
    private FhirContext myContext;

    public FhirTerser(FhirContext theContext) {
        this.myContext = theContext;
    }

    private List<String> addNameToList(List<String> theCurrentList, BaseRuntimeChildDefinition theChildDefinition) {
        if (theChildDefinition == null) {
            return null;
        }
        if (theCurrentList == null || theCurrentList.isEmpty()) {
            return new ArrayList<String>(Collections.singletonList(theChildDefinition.getElementName()));
        }
        ArrayList<String> newList = new ArrayList<String>(theCurrentList);
        newList.add(theChildDefinition.getElementName());
        return newList;
    }

    private ExtensionDt createEmptyExtensionDt(IBaseExtension theBaseExtension, String theUrl) {
        return this.createEmptyExtensionDt(theBaseExtension, false, theUrl);
    }

    private ExtensionDt createEmptyExtensionDt(IBaseExtension theBaseExtension, boolean theIsModifier, String theUrl) {
        ExtensionDt retVal = new ExtensionDt(theIsModifier, theUrl);
        theBaseExtension.getExtension().add(retVal);
        return retVal;
    }

    private ExtensionDt createEmptyExtensionDt(ISupportsUndeclaredExtensions theSupportsUndeclaredExtensions, String theUrl) {
        return this.createEmptyExtensionDt(theSupportsUndeclaredExtensions, false, theUrl);
    }

    private ExtensionDt createEmptyExtensionDt(ISupportsUndeclaredExtensions theSupportsUndeclaredExtensions, boolean theIsModifier, String theUrl) {
        return theSupportsUndeclaredExtensions.addUndeclaredExtension(theIsModifier, theUrl);
    }

    private IBaseExtension createEmptyExtension(IBaseHasExtensions theBaseHasExtensions, String theUrl) {
        return (IBaseExtension)theBaseHasExtensions.addExtension().setUrl(theUrl);
    }

    private IBaseExtension createEmptyModifierExtension(IBaseHasModifierExtensions theBaseHasModifierExtensions, String theUrl) {
        return (IBaseExtension)theBaseHasModifierExtensions.addModifierExtension().setUrl(theUrl);
    }

    private ExtensionDt createEmptyModifierExtensionDt(ISupportsUndeclaredExtensions theSupportsUndeclaredExtensions, String theUrl) {
        return this.createEmptyExtensionDt(theSupportsUndeclaredExtensions, true, theUrl);
    }

    public IBase cloneInto(IBase theSource, IBase theTarget, boolean theIgnoreMissingFields) {
        Object target;
        Object source;
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        if (theSource instanceof IBaseElement) {
            source = (IBaseElement)((Object)theSource);
            target = (IBaseElement)((Object)theTarget);
            target.setId(source.getId());
        }
        if (theSource instanceof IIdentifiableElement) {
            source = (IIdentifiableElement)theSource;
            target = (IIdentifiableElement)theTarget;
            target.setElementSpecificId(source.getElementSpecificId());
        }
        if (theSource instanceof IResource) {
            source = (IResource)theSource;
            target = (IResource)theTarget;
            target.setId(source.getId());
            target.getResourceMetadata().putAll(source.getResourceMetadata());
        }
        if (theSource instanceof IPrimitiveType) {
            if (theTarget instanceof IPrimitiveType) {
                String valueAsString = ((IPrimitiveType)theSource).getValueAsString();
                if (StringUtils.isNotBlank((CharSequence)valueAsString)) {
                    ((IPrimitiveType)theTarget).setValueAsString(valueAsString);
                }
                if (theSource instanceof IBaseHasExtensions && theTarget instanceof IBaseHasExtensions) {
                    List<IBaseExtension<?, ?>> extensions = ((IBaseHasExtensions)theSource).getExtension();
                    for (IBaseExtension<?, ?> nextSource : extensions) {
                        IBaseExtension<?, ?> nextTarget = ((IBaseHasExtensions)theTarget).addExtension();
                        this.cloneInto(nextSource, nextTarget, theIgnoreMissingFields);
                    }
                }
                return theSource;
            }
            if (theIgnoreMissingFields) {
                return theSource;
            }
            throw new DataFormatException("Can not copy value from primitive of type " + theSource.getClass().getName() + " into type " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition sourceDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theSource.getClass());
        BaseRuntimeElementCompositeDefinition targetDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theTarget.getClass());
        List<BaseRuntimeChildDefinition> children = sourceDef.getChildren();
        if (sourceDef instanceof RuntimeExtensionDtDefinition) {
            children = ((RuntimeExtensionDtDefinition)sourceDef).getChildrenIncludingUrl();
        }
        for (BaseRuntimeChildDefinition nextChild : children) {
            for (IBase nextValue : nextChild.getAccessor().getValues(theSource)) {
                String elementName = nextChild.getChildNameByDatatype(nextValue.getClass());
                BaseRuntimeChildDefinition targetChild = targetDef.getChildByName(elementName);
                if (targetChild == null) {
                    if (theIgnoreMissingFields) continue;
                    throw new DataFormatException("Type " + theTarget.getClass().getName() + " does not have a child with name " + elementName);
                }
                BaseRuntimeElementDefinition<?> element = this.myContext.getElementDefinition(nextValue.getClass());
                Object instanceConstructorArg = targetChild.getInstanceConstructorArguments();
                Object target2 = instanceConstructorArg != null ? element.newInstance(instanceConstructorArg) : element.newInstance();
                targetChild.getMutator().addValue(theTarget, (IBase)target2);
                this.cloneInto(nextValue, (IBase)target2, theIgnoreMissingFields);
            }
        }
        return theTarget;
    }

    public <T extends IBase> List<T> getAllPopulatedChildElementsOfType(IBaseResource theResource, final Class<T> theType) {
        final ArrayList retVal = new ArrayList();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(this.newMap(), theResource, theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBaseResource theOuterResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (theType.isAssignableFrom(theElement.getClass())) {
                    retVal.add(theElement);
                }
            }
        });
        return retVal;
    }

    public List<ResourceReferenceInfo> getAllResourceReferences(IBaseResource theResource) {
        final ArrayList<ResourceReferenceInfo> retVal = new ArrayList<ResourceReferenceInfo>();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(this.newMap(), theResource, theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBaseResource theOuterResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (IBaseReference.class.isAssignableFrom(theElement.getClass())) {
                    retVal.add(new ResourceReferenceInfo(FhirTerser.this.myContext, theOuterResource, thePathToElement, (IBaseReference)theElement));
                }
            }
        });
        return retVal;
    }

    private BaseRuntimeChildDefinition getDefinition(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, List<String> theSubList) {
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(theSubList.get(0));
        if (theSubList.size() == 1) {
            return nextDef;
        }
        BaseRuntimeElementCompositeDefinition cmp = (BaseRuntimeElementCompositeDefinition)nextDef.getChildByName(theSubList.get(0));
        return this.getDefinition(cmp, theSubList.subList(1, theSubList.size()));
    }

    public BaseRuntimeChildDefinition getDefinition(Class<? extends IBaseResource> theResourceType, String thePath) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResourceType);
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return this.getDefinition(def, subList);
    }

    public Object getSingleValueOrNull(IBase theTarget, String thePath) {
        Class<IBase> wantedType = IBase.class;
        return this.getSingleValueOrNull(theTarget, thePath, wantedType);
    }

    public <T extends IBase> T getSingleValueOrNull(IBase theTarget, String thePath, Class<T> theWantedType) {
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePath, (String)"thePath must not be empty", (Object[])new Object[0]);
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theTarget.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException("Target is not a composite type: " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        List<String> parts = this.parsePath(currentDef, thePath);
        List<T> retVal = this.getValues(currentDef, theTarget, parts, theWantedType);
        if (retVal.isEmpty()) {
            return null;
        }
        return (T)((IBase)retVal.get(0));
    }

    public <T extends IBase> Optional<T> getSingleValue(IBase theTarget, String thePath, Class<T> theWantedType) {
        return Optional.ofNullable(this.getSingleValueOrNull(theTarget, thePath, theWantedType));
    }

    private <T extends IBase> List<T> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, IBase theCurrentObj, List<String> theSubList, Class<T> theWantedClass) {
        return this.getValues(theCurrentDef, theCurrentObj, theSubList, theWantedClass, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends IBase> List<T> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, IBase theCurrentObj, List<String> theSubList, Class<T> theWantedClass, boolean theCreate, boolean theAddExtension) {
        String name = theSubList.get(0);
        ArrayList<IBase> retVal = new ArrayList<IBase>();
        if (name.startsWith("extension('")) {
            String extensionUrl = name.substring("extension('".length());
            int endIndex = extensionUrl.indexOf(39);
            if (endIndex != -1) {
                extensionUrl = extensionUrl.substring(0, endIndex);
            }
            if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                String extensionDtUrlForLambda = extensionUrl;
                List extensionDts = Collections.emptyList();
                if (theCurrentObj instanceof ISupportsUndeclaredExtensions) {
                    extensionDts = ((ISupportsUndeclaredExtensions)theCurrentObj).getUndeclaredExtensions().stream().filter(t -> t.getUrl().equals(extensionDtUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensionDts.isEmpty() && theSubList.size() == 1)) {
                        extensionDts.add(this.createEmptyExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                } else if (theCurrentObj instanceof IBaseExtension) {
                    extensionDts = ((IBaseExtension)theCurrentObj).getExtension();
                    if (theAddExtension && extensionDts.isEmpty() && theSubList.size() == 1) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                }
                for (IBaseExtension next : extensionDts) {
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                String extensionUrlForLambda = extensionUrl;
                Object extensions = Collections.emptyList();
                if (theCurrentObj instanceof IBaseHasExtensions) {
                    extensions = ((IBaseHasExtensions)theCurrentObj).getExtension().stream().filter(t -> t.getUrl().equals(extensionUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensions.isEmpty() && theSubList.size() == 1)) {
                        extensions.add(this.createEmptyExtension((IBaseHasExtensions)theCurrentObj, extensionUrl));
                    }
                    if (extensions.isEmpty() && theCreate) {
                        extensions.add(this.createEmptyExtension((IBaseHasExtensions)theCurrentObj, extensionUrl));
                    }
                }
                Iterator iterator = extensions.iterator();
                while (iterator.hasNext()) {
                    IBaseExtension next;
                    next = (IBaseExtension)iterator.next();
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
            if (theSubList.size() > 1) {
                ArrayList<IBase> values = retVal;
                retVal = new ArrayList();
                for (IBase iBase : values) {
                    BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(iBase.getClass());
                    List<T> foundValues = this.getValues(nextChildDef, iBase, theSubList.subList(1, theSubList.size()), theWantedClass, theCreate, theAddExtension);
                    retVal.addAll(foundValues);
                }
            }
            return retVal;
        }
        if (name.startsWith("modifierExtension('")) {
            String extensionUrl = name.substring("modifierExtension('".length());
            int endIndex = extensionUrl.indexOf(39);
            if (endIndex != -1) {
                extensionUrl = extensionUrl.substring(0, endIndex);
            }
            if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                String extensionDtUrlForLambda = extensionUrl;
                List extensionDts = Collections.emptyList();
                if (theCurrentObj instanceof ISupportsUndeclaredExtensions) {
                    extensionDts = ((ISupportsUndeclaredExtensions)theCurrentObj).getUndeclaredModifierExtensions().stream().filter(t -> t.getUrl().equals(extensionDtUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensionDts.isEmpty() && theSubList.size() == 1)) {
                        extensionDts.add(this.createEmptyModifierExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyModifierExtensionDt((ISupportsUndeclaredExtensions)theCurrentObj, extensionUrl));
                    }
                } else if (theCurrentObj instanceof IBaseExtension) {
                    extensionDts = ((IBaseExtension)theCurrentObj).getExtension();
                    if (theAddExtension && extensionDts.isEmpty() && theSubList.size() == 1) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                    if (extensionDts.isEmpty() && theCreate) {
                        extensionDts.add(this.createEmptyExtensionDt((IBaseExtension)theCurrentObj, extensionUrl));
                    }
                }
                for (IBaseExtension next : extensionDts) {
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                String extensionUrlForLambda = extensionUrl;
                Object extensions = Collections.emptyList();
                if (theCurrentObj instanceof IBaseHasModifierExtensions) {
                    extensions = ((IBaseHasModifierExtensions)((Object)theCurrentObj)).getModifierExtension().stream().filter(t -> t.getUrl().equals(extensionUrlForLambda)).collect(Collectors.toList());
                    if (theAddExtension && (!(theCurrentObj instanceof IBaseExtension) || extensions.isEmpty() && theSubList.size() == 1)) {
                        extensions.add(this.createEmptyModifierExtension((IBaseHasModifierExtensions)((Object)theCurrentObj), extensionUrl));
                    }
                    if (extensions.isEmpty() && theCreate) {
                        extensions.add(this.createEmptyModifierExtension((IBaseHasModifierExtensions)((Object)theCurrentObj), extensionUrl));
                    }
                }
                Iterator iterator = extensions.iterator();
                while (iterator.hasNext()) {
                    IBaseExtension next;
                    next = (IBaseExtension)iterator.next();
                    if (!theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
            if (theSubList.size() > 1) {
                ArrayList<IBase> values = retVal;
                retVal = new ArrayList();
                for (IBase iBase : values) {
                    BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(iBase.getClass());
                    List<T> foundValues = this.getValues(nextChildDef, iBase, theSubList.subList(1, theSubList.size()), theWantedClass, theCreate, theAddExtension);
                    retVal.addAll(foundValues);
                }
            }
            return retVal;
        }
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(name);
        List<IBase> values = nextDef.getAccessor().getValues(theCurrentObj);
        if (values.isEmpty() && theCreate) {
            void var13_33;
            BaseRuntimeElementDefinition<?> childByName = nextDef.getChildByName(name);
            Object arg = nextDef.getInstanceConstructorArguments();
            if (arg != null) {
                Object obj = childByName.newInstance(arg);
            } else {
                Object obj = childByName.newInstance();
            }
            nextDef.getMutator().addValue(theCurrentObj, (IBase)var13_33);
            ArrayList<IBase> list = new ArrayList<IBase>();
            list.add((IBase)var13_33);
            values = list;
        }
        if (theSubList.size() == 1) {
            if (nextDef instanceof RuntimeChildChoiceDefinition) {
                for (IBase next : values) {
                    if (next == null) continue;
                    if (name.endsWith("[x]")) {
                        if (theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                        retVal.add(next);
                        continue;
                    }
                    String string = nextDef.getChildNameByDatatype(next.getClass());
                    if (!theSubList.get(0).equals(string) || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            } else {
                for (IBase next : values) {
                    if (next == null || theWantedClass != null && !theWantedClass.isAssignableFrom(next.getClass())) continue;
                    retVal.add(next);
                }
            }
        } else {
            for (IBase nextElement : values) {
                BaseRuntimeElementCompositeDefinition baseRuntimeElementCompositeDefinition = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(nextElement.getClass());
                List<T> foundValues = this.getValues(baseRuntimeElementCompositeDefinition, nextElement, theSubList.subList(1, theSubList.size()), theWantedClass, theCreate, theAddExtension);
                retVal.addAll(foundValues);
            }
        }
        return retVal;
    }

    public List<IBase> getValues(IBase theElement, String thePath) {
        Class<IBase> wantedClass = IBase.class;
        return this.getValues(theElement, thePath, wantedClass);
    }

    public List<IBase> getValues(IBase theElement, String thePath, boolean theCreate) {
        Class<IBase> wantedClass = IBase.class;
        return this.getValues(theElement, thePath, wantedClass, theCreate);
    }

    public List<IBase> getValues(IBase theElement, String thePath, boolean theCreate, boolean theAddExtension) {
        Class<IBase> wantedClass = IBase.class;
        return this.getValues(theElement, thePath, wantedClass, theCreate, theAddExtension);
    }

    public <T extends IBase> List<T> getValues(IBase theElement, String thePath, Class<T> theWantedClass) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theElement.getClass());
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theElement, parts, theWantedClass);
    }

    public <T extends IBase> List<T> getValues(IBase theElement, String thePath, Class<T> theWantedClass, boolean theCreate) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theElement.getClass());
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theElement, parts, theWantedClass, theCreate, false);
    }

    public <T extends IBase> List<T> getValues(IBase theElement, String thePath, Class<T> theWantedClass, boolean theCreate, boolean theAddExtension) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theElement.getClass());
        List<String> parts = this.parsePath(def, thePath);
        return this.getValues(def, theElement, parts, theWantedClass, theCreate, theAddExtension);
    }

    private List<String> parsePath(BaseRuntimeElementCompositeDefinition<?> theElementDef, String thePath) {
        List<String> parts = new ArrayList<String>();
        int currentStart = 0;
        boolean inSingleQuote = false;
        block4: for (int i = 0; i < thePath.length(); ++i) {
            switch (thePath.charAt(i)) {
                case '\'': {
                    inSingleQuote = !inSingleQuote;
                    continue block4;
                }
                case '.': {
                    if (inSingleQuote) continue block4;
                    parts.add(thePath.substring(currentStart, i));
                    currentStart = i + 1;
                }
            }
        }
        parts.add(thePath.substring(currentStart));
        if (theElementDef instanceof RuntimeResourceDefinition && parts.size() > 0 && ((String)parts.get(0)).equals(theElementDef.getName())) {
            parts = parts.subList(1, parts.size());
        }
        if (parts.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return parts;
    }

    public boolean isSourceInCompartmentForTarget(String theCompartmentName, IBaseResource theSource, IIdType theTarget) {
        Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)theSource, (String)"theSource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)StringUtils.defaultString((String)theTarget.getResourceType()), (String)"theTarget must have a populated resource type (theTarget.getResourceType() does not return a value)", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)StringUtils.defaultString((String)theTarget.getIdPart()), (String)"theTarget must have a populated ID (theTarget.getIdPart() does not return a value)", (Object[])new Object[0]);
        String wantRef = theTarget.toUnqualifiedVersionless().getValue();
        RuntimeResourceDefinition sourceDef = this.myContext.getResourceDefinition(theSource);
        if (theSource.getIdElement().hasIdPart() && wantRef.equals(sourceDef.getName() + '/' + theSource.getIdElement().getIdPart())) {
            return true;
        }
        List<RuntimeSearchParam> params = sourceDef.getSearchParamsForCompartmentName(theCompartmentName);
        for (RuntimeSearchParam nextParam : params) {
            for (String nextPath : nextParam.getPathsSplit()) {
                String wantType = null;
                Pattern pattern = COMPARTMENT_MATCHER_PATH;
                Matcher matcher = pattern.matcher(nextPath);
                if (matcher.matches()) {
                    nextPath = matcher.group(1);
                    wantType = matcher.group(2);
                }
                List<IBaseReference> values = this.getValues((IBase)theSource, nextPath, IBaseReference.class);
                for (IBaseReference nextValue : values) {
                    String nextTargetIdResourceType;
                    IIdType nextTargetId = nextValue.getReferenceElement();
                    String nextRef = nextTargetId.toUnqualifiedVersionless().getValue();
                    if (StringUtils.isBlank((CharSequence)nextRef) && nextValue.getResource() != null) {
                        IBaseResource nextTarget = nextValue.getResource();
                        nextTargetId = nextTarget.getIdElement().toUnqualifiedVersionless();
                        if (!nextTargetId.hasResourceType()) {
                            String resourceType = this.myContext.getResourceType(nextTarget);
                            nextTargetId.setParts(null, resourceType, nextTargetId.getIdPart(), null);
                        }
                        nextRef = nextTargetId.getValue();
                    }
                    if (StringUtils.isNotBlank((CharSequence)wantType) && ((nextTargetIdResourceType = nextTargetId.getResourceType()) == null || !nextTargetIdResourceType.equals(wantType)) || !wantRef.equals(nextRef)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void visit(IBase theElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor2 theCallback, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
        if (theChildDefinition != null) {
            theChildDefinitionPath.add(theChildDefinition);
        }
        theContainingElementPath.add(theElement);
        theElementDefinitionPath.add(theDefinition);
        boolean recurse = theCallback.acceptElement(theElement, Collections.unmodifiableList(theContainingElementPath), Collections.unmodifiableList(theChildDefinitionPath), Collections.unmodifiableList(theElementDefinitionPath));
        if (recurse) {
            if (theElement instanceof ISupportsUndeclaredExtensions) {
                ISupportsUndeclaredExtensions containingElement = (ISupportsUndeclaredExtensions)theElement;
                for (ExtensionDt extensionDt : containingElement.getUndeclaredExtensions()) {
                    theContainingElementPath.add(extensionDt);
                    theCallback.acceptUndeclaredExtension(extensionDt, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                    theContainingElementPath.remove(theContainingElementPath.size() - 1);
                }
            }
            switch (theDefinition.getChildType()) {
                case ID_DATATYPE: 
                case PRIMITIVE_XHTML_HL7ORG: 
                case PRIMITIVE_XHTML: 
                case PRIMITIVE_DATATYPE: {
                    break;
                }
                case RESOURCE: 
                case RESOURCE_BLOCK: 
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)theDefinition;
                    for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                        List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                        if (values == null) continue;
                        for (IBase nextValue : values) {
                            if (nextValue == null || nextValue.isEmpty()) continue;
                            Class<?> valueType = nextValue.getClass();
                            BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(valueType);
                            while (childElementDef == null && IBase.class.isAssignableFrom(valueType)) {
                                childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(valueType);
                                valueType = valueType.getSuperclass();
                            }
                            Class<?> typeClass = nextValue.getClass();
                            while (childElementDef == null && IBase.class.isAssignableFrom(typeClass)) {
                                typeClass = typeClass.getSuperclass();
                                childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(typeClass);
                            }
                            Validate.notNull(childElementDef, (String)"Found value of type[%s] which is not valid for field[%s] in %s", (Object[])new Object[]{nextValue.getClass(), baseRuntimeChildDefinition.getElementName(), childDef.getName()});
                            this.visit(nextValue, baseRuntimeChildDefinition, childElementDef, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                        }
                    }
                    break;
                }
                case CONTAINED_RESOURCES: {
                    BaseContainedDt value = (BaseContainedDt)theElement;
                    for (IResource iResource : value.getContainedResources()) {
                        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(iResource);
                        this.visit(iResource, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                    }
                    break;
                }
                case EXTENSION_DECLARED: 
                case UNDECL_EXT: {
                    throw new IllegalStateException("state should not happen: " + (Object)((Object)theDefinition.getChildType()));
                }
                case CONTAINED_RESOURCE_LIST: {
                    if (theElement == null) break;
                    BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theElement.getClass());
                    this.visit(theElement, null, def, theCallback, theContainingElementPath, theChildDefinitionPath, theElementDefinitionPath);
                }
            }
        }
        if (theChildDefinition != null) {
            theChildDefinitionPath.remove(theChildDefinitionPath.size() - 1);
        }
        theContainingElementPath.remove(theContainingElementPath.size() - 1);
        theElementDefinitionPath.remove(theElementDefinitionPath.size() - 1);
    }

    public void visit(IBaseResource theResource, IModelVisitor theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(this.newMap(), theResource, theResource, null, null, def, theVisitor);
    }

    public Map<Object, Object> newMap() {
        return new IdentityHashMap<Object, Object>();
    }

    public void visit(IBase theElement, IModelVisitor2 theVisitor) {
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theElement.getClass());
        if (def instanceof BaseRuntimeElementCompositeDefinition) {
            BaseRuntimeElementCompositeDefinition defComposite = (BaseRuntimeElementCompositeDefinition)def;
            this.visit(theElement, null, def, theVisitor, new ArrayList<IBase>(), new ArrayList<BaseRuntimeChildDefinition>(), new ArrayList());
        } else if (theElement instanceof IBaseExtension) {
            theVisitor.acceptUndeclaredExtension((IBaseExtension)theElement, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        } else {
            theVisitor.acceptElement(theElement, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    private void visit(Map<Object, Object> theStack, IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor theCallback) {
        IBaseResource target;
        List<String> pathToElement = this.addNameToList(thePathToElement, theChildDefinition);
        if (theStack.put(theElement, theElement) != null) {
            return;
        }
        theCallback.acceptElement(theResource, theElement, pathToElement, theChildDefinition, theDefinition);
        BaseRuntimeElementDefinition def = theDefinition;
        if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) {
            def = this.myContext.getElementDefinition(theElement.getClass());
        }
        if (theElement instanceof IBaseReference && (target = ((IBaseReference)theElement).getResource()) != null && (!target.getIdElement().hasIdPart() || target.getIdElement().isLocal())) {
            RuntimeResourceDefinition targetDef = this.myContext.getResourceDefinition(target);
            this.visit(theStack, target, target, pathToElement, null, targetDef, theCallback);
        }
        switch (def.getChildType()) {
            case ID_DATATYPE: 
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)def;
                for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                    List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValueObject : values) {
                        IBase nextValue;
                        try {
                            nextValue = nextValueObject;
                        }
                        catch (ClassCastException e) {
                            String s = "Found instance of " + nextValueObject.getClass() + " - Did you set a field value to the incorrect type? Expected " + IBase.class.getName();
                            throw new ClassCastException(s);
                        }
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(nextValue.getClass());
                        if (childElementDef == null) {
                            childElementDef = this.myContext.getElementDefinition(nextValue.getClass());
                        }
                        if (baseRuntimeChildDefinition instanceof RuntimeChildDirectResource) {
                            theCallback.acceptElement(theResource, nextValue, null, baseRuntimeChildDefinition, childElementDef);
                            continue;
                        }
                        this.visit(theStack, theResource, nextValue, pathToElement, baseRuntimeChildDefinition, childElementDef, theCallback);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    def = this.myContext.getResourceDefinition(iResource);
                    this.visit(theStack, iResource, iResource, pathToElement, null, def, theCallback);
                }
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: 
            case CONTAINED_RESOURCE_LIST: {
                throw new IllegalStateException("state should not happen: " + (Object)((Object)def.getChildType()));
            }
        }
        theStack.remove(theElement);
    }

    public Collection<IBaseResource> getAllEmbeddedResources(final IBaseResource theResource, final boolean theRecurse) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        final ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        this.visit((IBase)theResource, new IModelVisitor2(){

            @Override
            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement == theResource) {
                    return true;
                }
                if (theElement instanceof IBaseResource) {
                    retVal.add((IBaseResource)theElement);
                    return theRecurse;
                }
                return true;
            }

            @Override
            public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                return true;
            }
        });
        return retVal;
    }

    public void clear(IBaseResource theInput) {
        this.visit((IBase)theInput, new IModelVisitor2(){

            @Override
            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement instanceof IPrimitiveType) {
                    ((IPrimitiveType)theElement).setValueAsString(null);
                }
                return true;
            }

            @Override
            public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                theNextExt.setUrl(null);
                theNextExt.setValue(null);
                return true;
            }
        });
    }
}

