/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.Include;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResourceReferenceInfo {
    private String myOwningResource;
    private String myName;
    private IBaseReference myResource;
    private FhirContext myContext;

    public ResourceReferenceInfo(FhirContext theContext, IBaseResource theOwningResource, List<String> thePathToElement, IBaseReference theElement) {
        this.myContext = theContext;
        this.myOwningResource = theContext.getResourceType(theOwningResource);
        this.myResource = theElement;
        if (thePathToElement != null && !thePathToElement.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            thePathToElement.iterator();
            Iterator<String> iterator = thePathToElement.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(".");
            }
            this.myName = sb.toString();
        } else {
            this.myName = null;
        }
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("name", (Object)this.myName);
        b.append("resource", (Object)this.myResource.getReferenceElement());
        return b.build();
    }

    public String getName() {
        return this.myName;
    }

    public IBaseReference getResourceReference() {
        return this.myResource;
    }

    public boolean matchesIncludeSet(Set<Include> theIncludes) {
        if (theIncludes == null) {
            return false;
        }
        for (Include include : theIncludes) {
            if (!this.matchesInclude(include)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesInclude(Include theInclude) {
        if (theInclude.getValue().equals("*")) {
            return true;
        }
        int colonIndex = theInclude.getValue().indexOf(58);
        if (colonIndex != -1) {
            RuntimeSearchParam searchParamDef;
            String resourceName = theInclude.getValue().substring(0, colonIndex);
            String paramName = theInclude.getValue().substring(colonIndex + 1);
            RuntimeResourceDefinition resourceDef = this.myContext.getResourceDefinition(resourceName);
            if (resourceDef != null && (searchParamDef = resourceDef.getSearchParam(paramName)) != null) {
                String completeName = this.myOwningResource + "." + this.myName;
                boolean matched = false;
                for (String s : searchParamDef.getPathsSplit()) {
                    if (!s.equals(completeName) && !s.startsWith(completeName + ".")) continue;
                    matched = true;
                    break;
                }
                return matched;
            }
            return false;
        }
        return theInclude.getValue().equals(this.myOwningResource + '.' + this.myName);
    }
}

