/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SearchParameterUtil {
    public static List<String> getBaseAsStrings(FhirContext theContext, IBaseResource theResource) {
        Validate.notNull((Object)theContext, (String)"theContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition base = def.getChildByName("base");
        List<IBase> baseValues = base.getAccessor().getValues(theResource);
        ArrayList<String> retVal = new ArrayList<String>();
        for (IBase next : baseValues) {
            IPrimitiveType nextPrimitive = (IPrimitiveType)next;
            retVal.add(nextPrimitive.getValueAsString());
        }
        return retVal;
    }

    @Nullable
    public static String getCode(FhirContext theContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theContext, theResource, "code");
    }

    @Nullable
    public static String getExpression(FhirContext theFhirContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theFhirContext, theResource, "expression");
    }

    private static String getStringChild(FhirContext theFhirContext, IBaseResource theResource, String theChildName) {
        Validate.notNull((Object)theFhirContext, (String)"theContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        RuntimeResourceDefinition def = theFhirContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition base = def.getChildByName(theChildName);
        return base.getAccessor().getFirstValueOrNull(theResource).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
    }
}

