/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class AttachmentUtil {
    public static IPrimitiveType<byte[]> getOrCreateData(FhirContext theContext, ICompositeType theAttachment) {
        return AttachmentUtil.getOrCreateChild(theContext, theAttachment, "data", "base64Binary");
    }

    public static IPrimitiveType<String> getOrCreateContentType(FhirContext theContext, ICompositeType theAttachment) {
        return AttachmentUtil.getOrCreateChild(theContext, theAttachment, "contentType", "string");
    }

    public static IPrimitiveType<String> getOrCreateUrl(FhirContext theContext, ICompositeType theAttachment) {
        return AttachmentUtil.getOrCreateChild(theContext, theAttachment, "url", "uri");
    }

    private static <T> IPrimitiveType<T> getOrCreateChild(FhirContext theContext, ICompositeType theAttachment, String theChildName, String theChildDatatype) {
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theContext, theAttachment, theChildName);
        List<IBase> entries = entryChild.getAccessor().getValues(theAttachment);
        return entries.stream().map(t -> (IPrimitiveType)t).findFirst().orElseGet(() -> {
            IPrimitiveType<Object> string = AttachmentUtil.newPrimitive(theContext, theChildDatatype, null);
            entryChild.getMutator().setValue(theAttachment, string);
            return string;
        });
    }

    public static void setUrl(FhirContext theContext, ICompositeType theAttachment, String theUrl) {
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theContext, theAttachment, "url");
        assert (entryChild != null) : "Version " + theContext + " has no child url";
        String typeName = "uri";
        if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            typeName = "url";
        }
        entryChild.getMutator().setValue(theAttachment, AttachmentUtil.newPrimitive(theContext, typeName, theUrl));
    }

    public static void setContentType(FhirContext theContext, ICompositeType theAttachment, String theContentType) {
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theContext, theAttachment, "contentType");
        entryChild.getMutator().setValue(theAttachment, AttachmentUtil.newPrimitive(theContext, "code", theContentType));
    }

    public static void setData(FhirContext theContext, ICompositeType theAttachment, byte[] theBytes) {
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theContext, theAttachment, "data");
        entryChild.getMutator().setValue(theAttachment, AttachmentUtil.newPrimitive(theContext, "base64Binary", theBytes));
    }

    public static void setSize(FhirContext theContext, ICompositeType theAttachment, Integer theLength) {
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theContext, theAttachment, "size");
        if (theLength == null) {
            entryChild.getMutator().setValue(theAttachment, null);
        } else if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R5)) {
            entryChild.getMutator().setValue(theAttachment, AttachmentUtil.newPrimitive(theContext, "integer64", Long.valueOf(theLength.intValue())));
        } else {
            entryChild.getMutator().setValue(theAttachment, AttachmentUtil.newPrimitive(theContext, "unsignedInt", theLength));
        }
    }

    static <T> IPrimitiveType<T> newPrimitive(FhirContext theContext, String theType, T theValue) {
        BaseRuntimeElementDefinition<?> elementDefinition = theContext.getElementDefinition(theType);
        Validate.notNull(elementDefinition, (String)"Unknown type %s for %s", (Object[])new Object[]{theType, theContext});
        IPrimitiveType primitive = (IPrimitiveType)elementDefinition.newInstance();
        primitive.setValue(theValue);
        return primitive;
    }

    static BaseRuntimeChildDefinition getChild(FhirContext theContext, IBase theElement, String theName) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(theElement.getClass());
        return def.getChildByName(theName);
    }

    public static ICompositeType newInstance(FhirContext theFhirCtx) {
        return (ICompositeType)theFhirCtx.getElementDefinition("Attachment").newInstance();
    }
}

