/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.io.CharArrayWriter;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Arrays;

public class StringUtil {
    public static String chompCharacter(String theInput, char theCharacter) {
        String retVal;
        for (retVal = theInput; retVal != null && retVal.length() > 0 && retVal.charAt(retVal.length() - 1) == theCharacter; retVal = retVal.substring(0, retVal.length() - 1)) {
        }
        return retVal;
    }

    public static String normalizeStringForSearchIndexing(String theString) {
        if (theString == null) {
            return null;
        }
        CharArrayWriter outBuffer = new CharArrayWriter(theString.length());
        String string = Normalizer.normalize(theString, Normalizer.Form.NFD);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0300' && c <= '\u036f') continue;
            outBuffer.append(c);
        }
        return new String(outBuffer.toCharArray()).toUpperCase();
    }

    public static String toUtf8String(byte[] theBytes) {
        byte[] bytes = theBytes;
        if (theBytes.length >= 3 && theBytes[0] == -17 && theBytes[1] == -69 && theBytes[2] == -65) {
            bytes = Arrays.copyOfRange(theBytes, 3, theBytes.length);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String left(String theString, int theCodePointCount) {
        if (theString == null) {
            return null;
        }
        if (theCodePointCount < 0) {
            return "";
        }
        if (theString.length() <= theCodePointCount) {
            return theString;
        }
        return theString.substring(0, theString.offsetByCodePoints(0, theCodePointCount));
    }
}

