/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.PrimitiveTypeEqualsPredicate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerserUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(TerserUtil.class);
    public static final String FIELD_NAME_IDENTIFIER = "identifier";
    private static final String EQUALS_DEEP = "equalsDeep";
    public static final Collection<String> IDS_AND_META_EXCLUDES = Collections.unmodifiableSet(Stream.of("id", "identifier", "meta").collect(Collectors.toSet()));
    public static final Predicate<String> EXCLUDE_IDS_AND_META = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return !IDS_AND_META_EXCLUDES.contains(s);
        }
    };
    public static final Predicate<Triple<BaseRuntimeChildDefinition, IBase, IBase>> EXCLUDE_IDS_META_AND_EMPTY = new Predicate<Triple<BaseRuntimeChildDefinition, IBase, IBase>>(){

        @Override
        public boolean test(Triple<BaseRuntimeChildDefinition, IBase, IBase> theTriple) {
            if (!EXCLUDE_IDS_AND_META.test(((BaseRuntimeChildDefinition)theTriple.getLeft()).getElementName())) {
                return false;
            }
            BaseRuntimeChildDefinition childDefinition = (BaseRuntimeChildDefinition)theTriple.getLeft();
            boolean isSourceFieldEmpty = childDefinition.getAccessor().getValues((IBase)theTriple.getMiddle()).isEmpty();
            return !isSourceFieldEmpty;
        }
    };
    public static final Predicate<String> INCLUDE_ALL = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return true;
        }
    };

    private TerserUtil() {
    }

    public static void cloneEidIntoResource(FhirContext theFhirContext, BaseRuntimeChildDefinition theIdentifierDefinition, IBase theEid, IBase theResourceToCloneEidInto) {
        BaseRuntimeElementCompositeDefinition childIdentifier = (BaseRuntimeElementCompositeDefinition)theIdentifierDefinition.getChildByName(FIELD_NAME_IDENTIFIER);
        Object resourceNewIdentifier = childIdentifier.newInstance();
        FhirTerser terser = theFhirContext.newTerser();
        terser.cloneInto(theEid, (IBase)resourceNewIdentifier, true);
        theIdentifierDefinition.getMutator().addValue(theResourceToCloneEidInto, (IBase)resourceNewIdentifier);
    }

    public static boolean hasValues(FhirContext theFhirContext, IBaseResource theResource, String theFieldName) {
        RuntimeResourceDefinition resourceDefinition = theFhirContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition resourceIdentifier = resourceDefinition.getChildByName(theFieldName);
        if (resourceIdentifier == null) {
            return false;
        }
        return !resourceIdentifier.getAccessor().getValues(theResource).isEmpty();
    }

    public static List<IBase> getValues(FhirContext theFhirContext, IBaseResource theResource, String theFieldName) {
        RuntimeResourceDefinition resourceDefinition = theFhirContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition resourceIdentifier = resourceDefinition.getChildByName(theFieldName);
        if (resourceIdentifier == null) {
            ourLog.info("There is no field named {} in Resource {}", (Object)theFieldName, (Object)resourceDefinition.getName());
            return null;
        }
        return resourceIdentifier.getAccessor().getValues(theResource);
    }

    public static IBase getValueFirstRep(FhirContext theFhirContext, IBaseResource theResource, String theFieldName) {
        List<IBase> values = TerserUtil.getValues(theFhirContext, theResource, theFieldName);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public static void cloneCompositeField(FhirContext theFhirContext, IBaseResource theFrom, IBaseResource theTo, String theField) {
        FhirTerser terser = theFhirContext.newTerser();
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theFrom);
        BaseRuntimeChildDefinition childDefinition = definition.getChildByName(theField);
        Validate.notNull((Object)childDefinition);
        List<IBase> theFromFieldValues = childDefinition.getAccessor().getValues(theFrom);
        List<IBase> theToFieldValues = childDefinition.getAccessor().getValues(theTo);
        for (IBase theFromFieldValue : theFromFieldValues) {
            if (TerserUtil.containsPrimitiveValue(theFromFieldValue, theToFieldValues)) continue;
            Object newFieldValue = childDefinition.getChildByName(theField).newInstance();
            terser.cloneInto(theFromFieldValue, (IBase)newFieldValue, true);
            try {
                theToFieldValues.add((IBase)newFieldValue);
            }
            catch (Exception e) {
                childDefinition.getMutator().setValue(theTo, (IBase)newFieldValue);
            }
        }
    }

    private static boolean containsPrimitiveValue(IBase theItem, List<IBase> theItems) {
        PrimitiveTypeEqualsPredicate predicate = new PrimitiveTypeEqualsPredicate();
        return theItems.stream().anyMatch(i -> predicate.test(i, theItem));
    }

    private static Method getMethod(IBase theBase, String theMethodName) {
        Method method = null;
        for (Method m : theBase.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(theMethodName)) continue;
            method = m;
            break;
        }
        return method;
    }

    public static boolean equals(IBase theItem1, IBase theItem2) {
        if (theItem1 == null) {
            return theItem2 == null;
        }
        Method method = TerserUtil.getMethod(theItem1, EQUALS_DEEP);
        Validate.notNull((Object)method);
        return TerserUtil.equals(theItem1, theItem2, method);
    }

    private static boolean equals(IBase theItem1, IBase theItem2, Method theMethod) {
        if (theMethod != null) {
            try {
                return (Boolean)theMethod.invoke((Object)theItem1, theItem2);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to compare equality via %s", EQUALS_DEEP), e);
            }
        }
        return theItem1.equals(theItem2);
    }

    private static boolean contains(IBase theItem, List<IBase> theItems) {
        Method method = TerserUtil.getMethod(theItem, EQUALS_DEEP);
        return theItems.stream().anyMatch(i -> TerserUtil.equals(i, theItem, method));
    }

    public static void mergeAllFields(FhirContext theFhirContext, IBaseResource theFrom, IBaseResource theTo) {
        TerserUtil.mergeFields(theFhirContext, theFrom, theTo, INCLUDE_ALL);
    }

    public static void replaceFields(FhirContext theFhirContext, IBaseResource theFrom, IBaseResource theTo, Predicate<String> theFieldNameInclusion) {
        Predicate<Triple<BaseRuntimeChildDefinition, IBase, IBase>> predicate = t -> theFieldNameInclusion.test(((BaseRuntimeChildDefinition)t.getLeft()).getElementName());
        TerserUtil.replaceFieldsByPredicate(theFhirContext, theFrom, theTo, predicate);
    }

    public static void replaceFieldsByPredicate(FhirContext theFhirContext, IBaseResource theFrom, IBaseResource theTo, Predicate<Triple<BaseRuntimeChildDefinition, IBase, IBase>> thePredicate) {
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theFrom);
        for (BaseRuntimeChildDefinition childDefinition : definition.getChildrenAndExtension()) {
            if (!thePredicate.test((Triple<BaseRuntimeChildDefinition, IBase, IBase>)Triple.of((Object)childDefinition, (Object)theFrom, (Object)theTo))) continue;
            TerserUtil.replaceField(theFrom, theTo, childDefinition);
        }
    }

    public static boolean fieldExists(FhirContext theFhirContext, String theFieldName, IBaseResource theInstance) {
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theInstance);
        return definition.getChildByName(theFieldName) != null;
    }

    public static void replaceField(FhirContext theFhirContext, String theFieldName, IBaseResource theFrom, IBaseResource theTo) {
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theFrom);
        Validate.notNull((Object)definition);
        TerserUtil.replaceField(theFrom, theTo, theFhirContext.getResourceDefinition(theFrom).getChildByName(theFieldName));
    }

    public static void clearField(FhirContext theFhirContext, String theFieldName, IBaseResource theResource) {
        BaseRuntimeChildDefinition childDefinition = TerserUtil.getBaseRuntimeChildDefinition(theFhirContext, theFieldName, theResource);
        childDefinition.getAccessor().getValues(theResource).clear();
    }

    public static void clearField(FhirContext theFhirContext, String theFieldName, IBase theBase) {
        BaseRuntimeElementDefinition<?> definition = theFhirContext.getElementDefinition(theBase.getClass());
        BaseRuntimeChildDefinition childDefinition = definition.getChildByName(theFieldName);
        Validate.notNull((Object)childDefinition);
        childDefinition.getAccessor().getValues(theBase).clear();
    }

    public static void setField(FhirContext theFhirContext, String theFieldName, IBaseResource theResource, IBase ... theValues) {
        TerserUtil.setField(theFhirContext, theFhirContext.newTerser(), theFieldName, theResource, theValues);
    }

    public static void setField(FhirContext theFhirContext, FhirTerser theTerser, String theFieldName, IBaseResource theResource, IBase ... theValues) {
        BaseRuntimeChildDefinition childDefinition = TerserUtil.getBaseRuntimeChildDefinition(theFhirContext, theFieldName, theResource);
        List<IBase> theFromFieldValues = childDefinition.getAccessor().getValues(theResource);
        if (theFromFieldValues.isEmpty()) {
            for (IBase value : theValues) {
                try {
                    childDefinition.getMutator().addValue(theResource, value);
                }
                catch (UnsupportedOperationException e) {
                    ourLog.warn("Resource {} does not support multiple values, but an attempt to set {} was made. Setting the first item only", (Object)theResource, (Object)theValues);
                    childDefinition.getMutator().setValue(theResource, value);
                    break;
                }
            }
            return;
        }
        List<IBase> theToFieldValues = Arrays.asList(theValues);
        TerserUtil.mergeFields(theTerser, theResource, childDefinition, theFromFieldValues, theToFieldValues);
    }

    public static void setFieldByFhirPath(FhirTerser theTerser, String theFhirPath, IBaseResource theResource, IBase theValue) {
        List<IBase> theFromFieldValues = theTerser.getValues((IBase)theResource, theFhirPath, true, false);
        for (IBase theFromFieldValue : theFromFieldValues) {
            theTerser.cloneInto(theValue, theFromFieldValue, true);
        }
    }

    public static void setFieldByFhirPath(FhirContext theFhirContext, String theFhirPath, IBaseResource theResource, IBase theValue) {
        TerserUtil.setFieldByFhirPath(theFhirContext.newTerser(), theFhirPath, theResource, theValue);
    }

    public static List<IBase> getFieldByFhirPath(FhirContext theFhirContext, String theFhirPath, IBase theResource) {
        return theFhirContext.newTerser().getValues(theResource, theFhirPath, false, false);
    }

    public static IBase getFirstFieldByFhirPath(FhirContext theFhirContext, String theFhirPath, IBase theResource) {
        List<IBase> values = TerserUtil.getFieldByFhirPath(theFhirContext, theFhirPath, theResource);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    private static void replaceField(IBaseResource theFrom, IBaseResource theTo, BaseRuntimeChildDefinition childDefinition) {
        childDefinition.getAccessor().getFirstValueOrNull(theFrom).ifPresent(v -> childDefinition.getMutator().setValue(theTo, (IBase)v));
    }

    public static void mergeFieldsExceptIdAndMeta(FhirContext theFhirContext, IBaseResource theFrom, IBaseResource theTo) {
        TerserUtil.mergeFields(theFhirContext, theFrom, theTo, EXCLUDE_IDS_AND_META);
    }

    public static void mergeFields(FhirContext theFhirContext, IBaseResource theFrom, IBaseResource theTo, Predicate<String> inclusionStrategy) {
        FhirTerser terser = theFhirContext.newTerser();
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theFrom);
        for (BaseRuntimeChildDefinition childDefinition : definition.getChildrenAndExtension()) {
            if (!inclusionStrategy.test(childDefinition.getElementName())) continue;
            List<IBase> theFromFieldValues = childDefinition.getAccessor().getValues(theFrom);
            List<IBase> theToFieldValues = childDefinition.getAccessor().getValues(theTo);
            TerserUtil.mergeFields(terser, theTo, childDefinition, theFromFieldValues, theToFieldValues);
        }
    }

    public static void mergeField(FhirContext theFhirContext, String theFieldName, IBaseResource theFrom, IBaseResource theTo) {
        TerserUtil.mergeField(theFhirContext, theFhirContext.newTerser(), theFieldName, theFrom, theTo);
    }

    public static void mergeField(FhirContext theFhirContext, FhirTerser theTerser, String theFieldName, IBaseResource theFrom, IBaseResource theTo) {
        BaseRuntimeChildDefinition childDefinition = TerserUtil.getBaseRuntimeChildDefinition(theFhirContext, theFieldName, theFrom);
        List<IBase> theFromFieldValues = childDefinition.getAccessor().getValues(theFrom);
        List<IBase> theToFieldValues = childDefinition.getAccessor().getValues(theTo);
        TerserUtil.mergeFields(theTerser, theTo, childDefinition, theFromFieldValues, theToFieldValues);
    }

    private static BaseRuntimeChildDefinition getBaseRuntimeChildDefinition(FhirContext theFhirContext, String theFieldName, IBaseResource theFrom) {
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theFrom);
        BaseRuntimeChildDefinition childDefinition = definition.getChildByName(theFieldName);
        Validate.notNull((Object)childDefinition);
        return childDefinition;
    }

    private static void mergeFields(FhirTerser theTerser, IBaseResource theTo, BaseRuntimeChildDefinition childDefinition, List<IBase> theFromFieldValues, List<IBase> theToFieldValues) {
        for (IBase theFromFieldValue : theFromFieldValues) {
            if (TerserUtil.contains(theFromFieldValue, theToFieldValues)) continue;
            Object newFieldValue = childDefinition.getChildByName(childDefinition.getElementName()).newInstance();
            theTerser.cloneInto(theFromFieldValue, (IBase)newFieldValue, true);
            try {
                theToFieldValues.add((IBase)newFieldValue);
            }
            catch (UnsupportedOperationException e) {
                childDefinition.getMutator().setValue(theTo, (IBase)newFieldValue);
                break;
            }
        }
    }

    public static <T extends IBaseResource> T clone(FhirContext theFhirContext, T theInstance) {
        RuntimeResourceDefinition definition = theFhirContext.getResourceDefinition(theInstance.getClass());
        IBaseResource retVal = (IBaseResource)definition.newInstance();
        FhirTerser terser = theFhirContext.newTerser();
        terser.cloneInto(theInstance, retVal, true);
        return (T)retVal;
    }

    public static <T extends IBase> T newElement(FhirContext theFhirContext, String theElementType) {
        BaseRuntimeElementDefinition<?> def = theFhirContext.getElementDefinition(theElementType);
        return (T)def.newInstance();
    }

    public static <T extends IBase> T newElement(FhirContext theFhirContext, String theElementType, Object theConstructorParam) {
        BaseRuntimeElementDefinition<?> def = theFhirContext.getElementDefinition(theElementType);
        Validate.notNull(def);
        return (T)def.newInstance(theConstructorParam);
    }

    public static <T extends IBase> T newResource(FhirContext theFhirContext, String theResourceName) {
        RuntimeResourceDefinition def = theFhirContext.getResourceDefinition(theResourceName);
        return def.newInstance();
    }

    public static <T extends IBase> T newResource(FhirContext theFhirContext, String theResourceName, Object theConstructorParam) {
        RuntimeResourceDefinition def = theFhirContext.getResourceDefinition(theResourceName);
        return def.newInstance(theConstructorParam);
    }
}

