/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.SchemaBaseValidator;
import ca.uhn.fhir.validation.ValidationContext;
import ca.uhn.fhir.validation.ValidationOptions;
import ca.uhn.fhir.validation.ValidationResult;
import ca.uhn.fhir.validation.schematron.SchematronProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirValidator {
    private static final String I18N_KEY_NO_PH_ERROR = FhirValidator.class.getName() + ".noPhError";
    private static volatile Boolean ourPhPresentOnClasspath;
    private final FhirContext myContext;
    private List<IValidatorModule> myValidators = new ArrayList<IValidatorModule>();
    private IInterceptorBroadcaster myInterceptorBraodcaster;

    public FhirValidator(FhirContext theFhirContext) {
        this.myContext = theFhirContext;
        if (ourPhPresentOnClasspath == null) {
            ourPhPresentOnClasspath = SchematronProvider.isSchematronAvailable(theFhirContext);
        }
    }

    private void addOrRemoveValidator(boolean theValidateAgainstStandardSchema, Class<? extends IValidatorModule> type, IValidatorModule theInstance) {
        if (theValidateAgainstStandardSchema) {
            boolean found = this.haveValidatorOfType(type);
            if (!found) {
                this.registerValidatorModule(theInstance);
            }
        } else {
            for (IValidatorModule next : this.myValidators) {
                if (!next.getClass().equals(type)) continue;
                this.unregisterValidatorModule(next);
            }
        }
    }

    private boolean haveValidatorOfType(Class<? extends IValidatorModule> type) {
        boolean found = false;
        for (IValidatorModule next : this.myValidators) {
            if (!next.getClass().equals(type)) continue;
            found = true;
        }
        return found;
    }

    public synchronized boolean isValidateAgainstStandardSchema() {
        return this.haveValidatorOfType(SchemaBaseValidator.class);
    }

    public synchronized FhirValidator setValidateAgainstStandardSchema(boolean theValidateAgainstStandardSchema) {
        this.addOrRemoveValidator(theValidateAgainstStandardSchema, SchemaBaseValidator.class, new SchemaBaseValidator(this.myContext));
        return this;
    }

    public synchronized boolean isValidateAgainstStandardSchematron() {
        if (!ourPhPresentOnClasspath.booleanValue()) {
            return false;
        }
        Class<? extends IValidatorModule> cls = SchematronProvider.getSchematronValidatorClass();
        return this.haveValidatorOfType(cls);
    }

    public synchronized FhirValidator setValidateAgainstStandardSchematron(boolean theValidateAgainstStandardSchematron) {
        if (theValidateAgainstStandardSchematron && !ourPhPresentOnClasspath.booleanValue()) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_KEY_NO_PH_ERROR, new Object[0]));
        }
        if (!theValidateAgainstStandardSchematron && !ourPhPresentOnClasspath.booleanValue()) {
            return this;
        }
        Class<? extends IValidatorModule> cls = SchematronProvider.getSchematronValidatorClass();
        IValidatorModule instance = SchematronProvider.getSchematronValidatorInstance(this.myContext);
        this.addOrRemoveValidator(theValidateAgainstStandardSchematron, cls, instance);
        return this;
    }

    public synchronized FhirValidator registerValidatorModule(IValidatorModule theValidator) {
        Validate.notNull((Object)theValidator, (String)"theValidator must not be null", (Object[])new Object[0]);
        ArrayList<IValidatorModule> newValidators = new ArrayList<IValidatorModule>(this.myValidators.size() + 1);
        newValidators.addAll(this.myValidators);
        newValidators.add(theValidator);
        this.myValidators = newValidators;
        return this;
    }

    public synchronized void unregisterValidatorModule(IValidatorModule theValidator) {
        Validate.notNull((Object)theValidator, (String)"theValidator must not be null", (Object[])new Object[0]);
        ArrayList<IValidatorModule> newValidators = new ArrayList<IValidatorModule>(this.myValidators.size() + 1);
        newValidators.addAll(this.myValidators);
        newValidators.remove(theValidator);
        this.myValidators = newValidators;
    }

    private void applyDefaultValidators() {
        if (this.myValidators.isEmpty()) {
            this.setValidateAgainstStandardSchema(true);
            if (ourPhPresentOnClasspath.booleanValue()) {
                this.setValidateAgainstStandardSchematron(true);
            }
        }
    }

    public ValidationResult validateWithResult(IBaseResource theResource) {
        return this.validateWithResult(theResource, null);
    }

    public ValidationResult validateWithResult(String theResource) {
        return this.validateWithResult(theResource, null);
    }

    public ValidationResult validateWithResult(IBaseResource theResource, ValidationOptions theOptions) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        this.applyDefaultValidators();
        IValidationContext<IBaseResource> ctx = ValidationContext.forResource(this.myContext, theResource, theOptions);
        for (IValidatorModule next : this.myValidators) {
            next.validateResource(ctx);
        }
        ValidationResult result = ctx.toResult();
        result = this.invokeValidationCompletedHooks(theResource, null, result);
        return result;
    }

    private ValidationResult invokeValidationCompletedHooks(IBaseResource theResourceParsed, String theResourceRaw, ValidationResult theValidationResult) {
        HookParams params;
        Object newResult;
        if (this.myInterceptorBraodcaster != null && this.myInterceptorBraodcaster.hasHooks(Pointcut.VALIDATION_COMPLETED) && (newResult = this.myInterceptorBraodcaster.callHooksAndReturnObject(Pointcut.VALIDATION_COMPLETED, params = new HookParams().add(IBaseResource.class, theResourceParsed).add(String.class, theResourceRaw).add(ValidationResult.class, theValidationResult))) != null) {
            theValidationResult = (ValidationResult)newResult;
        }
        return theValidationResult;
    }

    public ValidationResult validateWithResult(String theResource, ValidationOptions theOptions) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        this.applyDefaultValidators();
        IValidationContext<IBaseResource> ctx = ValidationContext.forText(this.myContext, theResource, theOptions);
        for (IValidatorModule next : this.myValidators) {
            next.validateResource(ctx);
        }
        ValidationResult result = ctx.toResult();
        result = this.invokeValidationCompletedHooks(null, theResource, result);
        return result;
    }

    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBraodcaster) {
        this.myInterceptorBraodcaster = theInterceptorBraodcaster;
    }
}

