package ca.uhn.fhir.model.api.annotation;

/*
 * #%L
 * HAPI FHIR - Core Library
 * %%
 * Copyright (C) 2014 - 2021 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marker annotation for a primitive setter method that can be used to
 * indicate a "simple setter" method on a resource or composite type.  
 * 
 * This annotation is used by HAPI's code generator and can be ignored by
 * client code
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(value= {ElementType.CONSTRUCTOR})
public @interface SimpleSetter {
	
	String suffix() default "";
	
	
	@Retention(RetentionPolicy.RUNTIME)
	@Target(value= {ElementType.PARAMETER})
	public @interface Parameter {
		String name();
	}	
	
}
