/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class ResourceMetadataKeyEnum<T>
implements Serializable {
    public static final ResourceMetadataKeySupportingAnyResource<InstantDt, IPrimitiveType<Date>> DELETED_AT = new ResourceMetadataKeySupportingAnyResource<InstantDt, IPrimitiveType<Date>>("DELETED_AT"){
        private static final long serialVersionUID = 1L;

        @Override
        public InstantDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getInstantFromMetadataOrNullIfNone(theResource.getResourceMetadata(), (ResourceMetadataKeyEnum)1.DELETED_AT);
        }

        @Override
        public IPrimitiveType<Date> get(IAnyResource theResource) {
            return (IPrimitiveType)theResource.getUserData(DELETED_AT.name());
        }

        @Override
        public void put(IResource theResource, InstantDt theObject) {
            theResource.getResourceMetadata().put(DELETED_AT, theObject);
        }

        @Override
        public void put(IAnyResource theResource, IPrimitiveType<Date> theObject) {
            theResource.setUserData(DELETED_AT.name(), theObject);
        }
    };
    public static final ResourceMetadataKeySupportingAnyResource<BundleEntrySearchModeEnum, String> ENTRY_SEARCH_MODE = new ResourceMetadataKeySupportingAnyResource<BundleEntrySearchModeEnum, String>("ENTRY_SEARCH_MODE"){
        private static final long serialVersionUID = 1L;

        @Override
        public BundleEntrySearchModeEnum get(IResource theResource) {
            return (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.getEnumFromMetadataOrNullIfNone(theResource.getResourceMetadata(), (ResourceMetadataKeyEnum)2.ENTRY_SEARCH_MODE, BundleEntrySearchModeEnum.class, BundleEntrySearchModeEnum.VALUESET_BINDER);
        }

        @Override
        public String get(IAnyResource theResource) {
            return (String)theResource.getUserData(ENTRY_SEARCH_MODE.name());
        }

        @Override
        public void put(IResource theResource, BundleEntrySearchModeEnum theObject) {
            theResource.getResourceMetadata().put(ENTRY_SEARCH_MODE, theObject);
        }

        @Override
        public void put(IAnyResource theResource, String theObject) {
            theResource.setUserData(ENTRY_SEARCH_MODE.name(), theObject);
        }
    };
    public static final ResourceMetadataKeySupportingAnyResource<BundleEntryTransactionMethodEnum, String> ENTRY_TRANSACTION_METHOD = new ResourceMetadataKeySupportingAnyResource<BundleEntryTransactionMethodEnum, String>("ENTRY_TRANSACTION_OPERATION"){
        private static final long serialVersionUID = 1L;

        @Override
        public BundleEntryTransactionMethodEnum get(IResource theResource) {
            return (BundleEntryTransactionMethodEnum)ResourceMetadataKeyEnum.getEnumFromMetadataOrNullIfNone(theResource.getResourceMetadata(), (ResourceMetadataKeyEnum)3.ENTRY_TRANSACTION_METHOD, BundleEntryTransactionMethodEnum.class, BundleEntryTransactionMethodEnum.VALUESET_BINDER);
        }

        @Override
        public String get(IAnyResource theResource) {
            return (String)theResource.getUserData(ENTRY_TRANSACTION_METHOD.name());
        }

        @Override
        public void put(IResource theResource, BundleEntryTransactionMethodEnum theObject) {
            theResource.getResourceMetadata().put(ENTRY_TRANSACTION_METHOD, theObject);
        }

        @Override
        public void put(IAnyResource theResource, String theObject) {
            theResource.setUserData(ENTRY_TRANSACTION_METHOD.name(), theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<List<IdDt>> PROFILES = new ResourceMetadataKeyEnum<List<IdDt>>("PROFILES"){
        private static final long serialVersionUID = 1L;

        @Override
        public List<IdDt> get(IResource theResource) {
            return ResourceMetadataKeyEnum.getIdListFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 4.PROFILES);
        }

        @Override
        public void put(IResource theResource, List<IdDt> theObject) {
            theResource.getResourceMetadata().put(PROFILES, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<InstantDt> PUBLISHED = new ResourceMetadataKeyEnum<InstantDt>("PUBLISHED"){
        private static final long serialVersionUID = 1L;

        @Override
        public InstantDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getInstantFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 5.PUBLISHED);
        }

        @Override
        public void put(IResource theResource, InstantDt theObject) {
            theResource.getResourceMetadata().put(PUBLISHED, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<List<BaseCodingDt>> SECURITY_LABELS = new ResourceMetadataKeyEnum<List<BaseCodingDt>>("SECURITY_LABELS"){
        private static final long serialVersionUID = 1L;

        @Override
        public List<BaseCodingDt> get(IResource resource) {
            Object obj = resource.getResourceMetadata().get(SECURITY_LABELS);
            if (obj == null) {
                return null;
            }
            return (List)obj;
        }

        @Override
        public void put(IResource iResource, List<BaseCodingDt> labels) {
            iResource.getResourceMetadata().put(SECURITY_LABELS, labels);
        }
    };
    public static final ResourceMetadataKeyEnum<TagList> TAG_LIST = new ResourceMetadataKeyEnum<TagList>("TAG_LIST"){
        private static final long serialVersionUID = 1L;

        @Override
        public TagList get(IResource theResource) {
            Object retValObj = theResource.getResourceMetadata().get(TAG_LIST);
            if (retValObj == null) {
                return null;
            }
            return (TagList)retValObj;
        }

        @Override
        public void put(IResource theResource, TagList theObject) {
            theResource.getResourceMetadata().put(TAG_LIST, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<InstantDt> UPDATED = new ResourceMetadataKeyEnum<InstantDt>("UPDATED"){
        private static final long serialVersionUID = 1L;

        @Override
        public InstantDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getInstantFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 8.UPDATED);
        }

        @Override
        public void put(IResource theResource, InstantDt theObject) {
            theResource.getResourceMetadata().put(UPDATED, theObject);
        }
    };
    @Deprecated
    public static final ResourceMetadataKeyEnum<String> VERSION = new ResourceMetadataKeyEnum<String>("VERSION"){
        private static final long serialVersionUID = 1L;

        @Override
        public String get(IResource theResource) {
            return ResourceMetadataKeyEnum.getStringFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 9.VERSION);
        }

        @Override
        public void put(IResource theResource, String theObject) {
            theResource.getResourceMetadata().put(VERSION, theObject);
        }
    };
    @Deprecated
    public static final ResourceMetadataKeyEnum<IdDt> VERSION_ID = new ResourceMetadataKeyEnum<IdDt>("VERSION_ID"){
        private static final long serialVersionUID = 1L;

        @Override
        public IdDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getIdFromMetadataOrNullIfNone(theResource.getResourceMetadata());
        }

        @Override
        public void put(IResource theResource, IdDt theObject) {
            theResource.getResourceMetadata().put(VERSION_ID, theObject);
        }
    };
    private static final long serialVersionUID = 1L;
    private final String myValue;

    public ResourceMetadataKeyEnum(String theValue) {
        this.myValue = theValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetadataKeyEnum other = (ResourceMetadataKeyEnum)obj;
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public abstract T get(IResource var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public String name() {
        return this.myValue;
    }

    public abstract void put(IResource var1, T var2);

    private static <T extends Enum<?>> T getEnumFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<T> theKey, Class<T> theEnumType, IValueSetEnumBinder<T> theBinder) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (theEnumType.equals(retValObj.getClass())) {
            return (T)((Enum)retValObj);
        }
        if (retValObj instanceof String) {
            return theBinder.fromCodeString((String)retValObj);
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + theKey.name() + " - Expected " + InstantDt.class.getCanonicalName());
    }

    private static IdDt getIdFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata) {
        return ResourceMetadataKeyEnum.toId(VERSION_ID, theResourceMetadata.get(VERSION_ID));
    }

    private static List<IdDt> getIdListFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<?> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof List) {
            List retValList = (List)retValObj;
            for (Object next : retValList) {
                if (next instanceof IdDt) continue;
                ArrayList<IdDt> retVal = new ArrayList<IdDt>();
                for (Object nextVal : retValList) {
                    retVal.add(ResourceMetadataKeyEnum.toId(theKey, nextVal));
                }
                return Collections.unmodifiableList(retVal);
            }
            List retVal = retValList;
            return Collections.unmodifiableList(retVal);
        }
        return Collections.singletonList(ResourceMetadataKeyEnum.toId(theKey, retValObj));
    }

    private static InstantDt getInstantFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<InstantDt> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof Date) {
            return new InstantDt((Date)retValObj);
        }
        if (retValObj instanceof InstantDt) {
            if (((InstantDt)retValObj).isEmpty()) {
                return null;
            }
            return (InstantDt)retValObj;
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + theKey.name() + " - Expected " + InstantDt.class.getCanonicalName());
    }

    private static String getStringFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<String> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)retValObj))) {
                return null;
            }
            return (String)retValObj;
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + theKey.name() + " - Expected " + String.class.getCanonicalName());
    }

    private static IdDt toId(ResourceMetadataKeyEnum<?> theKey, Object retValObj) {
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)((String)retValObj))) {
                return new IdDt((String)retValObj);
            }
            return null;
        }
        if (retValObj instanceof IdDt) {
            if (((IdDt)retValObj).isEmpty()) {
                return null;
            }
            return (IdDt)retValObj;
        }
        if (retValObj instanceof Number) {
            return new IdDt(retValObj.toString());
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + theKey.name() + " - Expected " + IdDt.class.getCanonicalName());
    }

    public static abstract class ResourceMetadataKeySupportingAnyResource<T, T2>
    extends ResourceMetadataKeyEnum<T> {
        private static final long serialVersionUID = 1L;

        public ResourceMetadataKeySupportingAnyResource(String theValue) {
            super(theValue);
        }

        public abstract T2 get(IAnyResource var1);

        public abstract void put(IAnyResource var1, T2 var2);
    }

    public static final class ExtensionResourceMetadataKey
    extends ResourceMetadataKeyEnum<ExtensionDt> {
        public ExtensionResourceMetadataKey(String theUrl) {
            super(theUrl);
        }

        @Override
        public ExtensionDt get(IResource theResource) {
            Object retValObj = theResource.getResourceMetadata().get(this);
            if (retValObj == null) {
                return null;
            }
            if (retValObj instanceof ExtensionDt) {
                return (ExtensionDt)retValObj;
            }
            throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + this.name() + " - Expected " + ExtensionDt.class.getCanonicalName());
        }

        @Override
        public void put(IResource theResource, ExtensionDt theObject) {
            theResource.getResourceMetadata().put(this, theObject);
        }
    }
}

