/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.base.composite;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseCodingDt
extends BaseIdentifiableElement
implements ICompositeDatatype,
IQueryParameterType {
    private static final long serialVersionUID = 4425182816398730643L;

    public abstract CodeDt getCodeElement();

    @Override
    public String getQueryParameterQualifier() {
        return null;
    }

    public abstract UriDt getSystemElement();

    public abstract StringDt getDisplayElement();

    public abstract BaseCodingDt setDisplay(String var1);

    @Override
    public String getValueAsQueryToken(FhirContext theContext) {
        if (this.getSystemElement().getValueAsString() != null) {
            return ParameterUtil.escape(StringUtils.defaultString((String)this.getSystemElement().getValueAsString())) + '|' + ParameterUtil.escape(this.getCodeElement().getValueAsString());
        }
        return ParameterUtil.escape(this.getCodeElement().getValueAsString());
    }

    @Override
    public void setValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theParameter) {
        int barIndex = ParameterUtil.nonEscapedIndexOf(theParameter, '|');
        if (barIndex != -1) {
            this.setSystem(theParameter.substring(0, barIndex));
            this.setCode(ParameterUtil.unescape(theParameter.substring(barIndex + 1)));
        } else {
            this.setCode(ParameterUtil.unescape(theParameter));
        }
    }

    public boolean matchesSystemAndCode(BaseCodingDt theCoding) {
        if (theCoding == null) {
            return false;
        }
        return this.getCodeElement().equals(theCoding.getCodeElement()) && this.getSystemElement().equals(theCoding.getSystemElement());
    }

    public boolean matchesToken(BaseCodingDt theSearchParam) {
        if (theSearchParam.isSystemPresent()) {
            if (theSearchParam.isSystemBlank()) {
                if (this.isSystemPresent() && !this.isSystemBlank()) {
                    return false;
                }
            } else {
                if (!this.isSystemPresent()) {
                    return false;
                }
                if (!this.getSystemElement().equals(theSearchParam.getSystemElement())) {
                    return false;
                }
            }
        }
        return this.getCodeElement().equals(theSearchParam.getCodeElement());
    }

    private boolean isSystemPresent() {
        return !this.getSystemElement().isEmpty();
    }

    private boolean isSystemBlank() {
        return this.isSystemPresent() && this.getSystemElement().getValueAsString().equals("");
    }

    public abstract BaseCodingDt setCode(String var1);

    public abstract BaseCodingDt setSystem(String var1);

    @Override
    @Deprecated
    public Boolean getMissing() {
        return null;
    }

    @Override
    @Deprecated
    public IQueryParameterType setMissing(Boolean theMissing) {
        throw new UnsupportedOperationException(Msg.code(1903) + "get/setMissing is not supported in StringDt. Use {@link StringParam} instead if you need this functionality");
    }
}

