/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeNarrativeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParseLocation;
import ca.uhn.fhir.parser.json.JsonLikeValue;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParserState<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(ParserState.class);
    private final FhirContext myContext;
    private final IParserErrorHandler myErrorHandler;
    private final boolean myJsonMode;
    private final IParser myParser;
    private List<String> myComments = new ArrayList<String>(2);
    private T myObject;
    private IBase myPreviousElement;
    private BaseState myState;
    private List<IBaseResource> myGlobalResources = new ArrayList<IBaseResource>();
    private List<IBaseReference> myGlobalReferences = new ArrayList<IBaseReference>();

    private ParserState(IParser theParser, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) {
        this.myParser = theParser;
        this.myContext = theContext;
        this.myJsonMode = theJsonMode;
        this.myErrorHandler = theErrorHandler;
    }

    public void attributeValue(String theName, String theValue) throws DataFormatException {
        this.myState.attributeValue(theName, theValue);
    }

    public void commentPost(String theCommentText) {
        if (this.myPreviousElement != null) {
            this.myPreviousElement.getFormatCommentsPost().add(theCommentText);
        }
    }

    public void commentPre(String theCommentText) {
        if (this.myState.getCurrentElement() != null) {
            IBase element = this.myState.getCurrentElement();
            element.getFormatCommentsPre().add(theCommentText);
        }
    }

    boolean elementIsRepeating(String theChildName) {
        return this.myState.elementIsRepeating(theChildName);
    }

    void endingElement() throws DataFormatException {
        this.myState.endingElement();
    }

    void enteringNewElement(String theNamespaceUri, String theName) throws DataFormatException {
        this.myState.enteringNewElement(theNamespaceUri, theName);
    }

    void enteringNewElementExtension(StartElement theElem, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
        this.myState.enteringNewElementExtension(theElem, theUrlAttr, theIsModifier, baseServerUrl);
    }

    public T getObject() {
        return this.myObject;
    }

    boolean isPreResource() {
        return this.myState.isPreResource();
    }

    private Object newContainedDt(IResource theTarget) {
        return ReflectionUtil.newInstance(theTarget.getStructureFhirVersionEnum().getVersionImplementation().getContainedType());
    }

    private void pop() {
        this.myPreviousElement = this.myState.getCurrentElement();
        if (this.myState.myStack != null) {
            this.myState = this.myState.myStack;
            this.myState.wereBack();
        } else {
            this.myObject = this.myState.getCurrentElement();
            this.myState = null;
        }
    }

    private void push(BaseState theState) {
        theState.setStack(this.myState);
        this.myState = theState;
        if (!this.myComments.isEmpty() && this.myState.getCurrentElement() != null) {
            this.myState.getCurrentElement().getFormatCommentsPre().addAll(this.myComments);
            this.myComments.clear();
        }
    }

    public void string(String theData) {
        this.myState.string(theData);
    }

    void xmlEvent(XMLEvent theNextEvent) {
        if (this.myState != null) {
            this.myState.xmlEvent(theNextEvent);
        }
    }

    public IBase newInstance(RuntimeChildDeclaredExtensionDefinition theDefinition) {
        return theDefinition.newInstance();
    }

    public ICompositeType newCompositeInstance(PreResourceState thePreResourceState, BaseRuntimeChildDefinition theChild, BaseRuntimeElementCompositeDefinition<?> theCompositeTarget) {
        ICompositeType retVal = (ICompositeType)theCompositeTarget.newInstance(theChild.getInstanceConstructorArguments());
        if (retVal instanceof IBaseReference) {
            IBaseReference ref = (IBaseReference)retVal;
            this.myGlobalReferences.add(ref);
            thePreResourceState.getLocalReferences().add(ref);
        }
        return retVal;
    }

    public ICompositeType newCompositeTypeInstance(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theCompositeTarget) {
        ICompositeType retVal = (ICompositeType)theCompositeTarget.newInstance();
        if (retVal instanceof IBaseReference) {
            IBaseReference ref = (IBaseReference)retVal;
            this.myGlobalReferences.add(ref);
            thePreResourceState.getLocalReferences().add(ref);
        }
        return retVal;
    }

    public IPrimitiveType<?> newPrimitiveInstance(RuntimeChildDeclaredExtensionDefinition theDefinition, RuntimePrimitiveDatatypeDefinition thePrimitiveTarget) {
        return (IPrimitiveType)thePrimitiveTarget.newInstance(theDefinition.getInstanceConstructorArguments());
    }

    public IPrimitiveType<?> getPrimitiveInstance(BaseRuntimeChildDefinition theChild, RuntimePrimitiveDatatypeDefinition thePrimitiveTarget, String theChildName) {
        return (IPrimitiveType)thePrimitiveTarget.newInstance(theChild.getInstanceConstructorArguments());
    }

    public IBaseXhtml newInstance(RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition theXhtmlTarget) {
        return (IBaseXhtml)theXhtmlTarget.newInstance();
    }

    public XhtmlDt newInstance(RuntimePrimitiveDatatypeNarrativeDefinition theXhtmlTarget) {
        return (XhtmlDt)theXhtmlTarget.newInstance();
    }

    public IPrimitiveType<?> newInstance(RuntimePrimitiveDatatypeDefinition thePrimitiveTarget) {
        return (IPrimitiveType)thePrimitiveTarget.newInstance();
    }

    public IBaseResource newInstance(RuntimeResourceDefinition theDef) {
        IBaseResource retVal = (IBaseResource)theDef.newInstance();
        this.myGlobalResources.add(retVal);
        return retVal;
    }

    public IBase newInstance(RuntimeResourceBlockDefinition theBlockTarget) {
        return theBlockTarget.newInstance();
    }

    static <T extends IBaseResource> ParserState<T> getPreResourceInstance(IParser theParser, Class<T> theResourceType, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) throws DataFormatException {
        ParserState<T> retVal = new ParserState<T>(theParser, theContext, theJsonMode, theErrorHandler);
        if (theResourceType == null) {
            if (theContext.getVersion().getVersion().isRi()) {
                ParserState<T> parserState = retVal;
                Objects.requireNonNull(parserState);
                retVal.push(parserState.new PreResourceStateHl7Org(theResourceType));
            } else {
                ParserState<T> parserState = retVal;
                Objects.requireNonNull(parserState);
                retVal.push(parserState.new PreResourceStateHapi(theResourceType));
            }
        } else if (IResource.class.isAssignableFrom(theResourceType)) {
            ParserState<T> parserState = retVal;
            Objects.requireNonNull(parserState);
            retVal.push(parserState.new PreResourceStateHapi(theResourceType));
        } else {
            ParserState<T> parserState = retVal;
            Objects.requireNonNull(parserState);
            retVal.push(parserState.new PreResourceStateHl7Org(theResourceType));
        }
        return retVal;
    }

    static ParserState<TagList> getPreTagListInstance(IParser theParser, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) {
        ParserState<TagList> retVal = new ParserState<TagList>(theParser, theContext, theJsonMode, theErrorHandler);
        retVal.push(retVal.new PreTagListState());
        return retVal;
    }

    private abstract class BaseState {
        private PreResourceState myPreResourceState;
        private BaseState myStack;

        BaseState(PreResourceState thePreResourceState) {
            this.myPreResourceState = thePreResourceState;
        }

        public void attributeValue(String theName, String theValue) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownAttribute(null, theName);
        }

        public boolean elementIsRepeating(String theChildName) {
            return false;
        }

        public void endingElement() throws DataFormatException {
        }

        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
        }

        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            if (this.myPreResourceState != null && this.getCurrentElement() instanceof ISupportsUndeclaredExtensions) {
                ExtensionDt newExtension = new ExtensionDt(theIsModifier);
                newExtension.setUrl(theUrlAttr);
                ISupportsUndeclaredExtensions elem = (ISupportsUndeclaredExtensions)this.getCurrentElement();
                elem.addUndeclaredExtension(newExtension);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, newExtension);
                ParserState.this.push(newState);
            } else if (!theIsModifier) {
                if (this.getCurrentElement() instanceof IBaseHasExtensions) {
                    IBaseExtension<?, ?> ext = ((IBaseHasExtensions)this.getCurrentElement()).addExtension();
                    ext.setUrl(theUrlAttr);
                    ExtensionState newState = new ExtensionState(this.myPreResourceState, ext);
                    ParserState.this.push(newState);
                } else {
                    this.logAndSwallowUnexpectedElement("extension");
                }
            } else if (this.getCurrentElement() instanceof IBaseHasModifierExtensions) {
                IBaseExtension<?, ?> ext = ((IBaseHasModifierExtensions)((Object)this.getCurrentElement())).addModifierExtension();
                ext.setUrl(theUrlAttr);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, ext);
                ParserState.this.push(newState);
            } else {
                this.logAndSwallowUnexpectedElement("modifierExtension");
            }
        }

        protected IBase getCurrentElement() {
            return null;
        }

        PreResourceState getPreResourceState() {
            return this.myPreResourceState;
        }

        public boolean isPreResource() {
            return false;
        }

        void logAndSwallowUnexpectedElement(String theLocalPart) {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        public void setStack(BaseState theState) {
            this.myStack = theState;
        }

        public void string(String theData) {
        }

        public void wereBack() {
        }

        public void xmlEvent(XMLEvent theNextEvent) {
        }
    }

    private abstract class PreResourceState
    extends BaseState {
        private Map<String, IBaseResource> myContainedResources;
        private List<IBaseReference> myLocalReferences;
        private IBaseResource myInstance;
        private FhirVersionEnum myParentVersion;
        private Class<? extends IBaseResource> myResourceType;

        PreResourceState(Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myLocalReferences = new ArrayList<IBaseReference>();
            this.myResourceType = theResourceType;
            this.myContainedResources = new HashMap<String, IBaseResource>();
            this.myParentVersion = theResourceType != null ? ParserState.this.myContext.getResourceDefinition(theResourceType).getStructureVersion() : ParserState.this.myContext.getVersion().getVersion();
        }

        PreResourceState(PreResourceState thePreResourcesState, FhirVersionEnum theParentVersion) {
            super(thePreResourcesState);
            this.myLocalReferences = new ArrayList<IBaseReference>();
            Validate.notNull((Object)((Object)theParentVersion));
            this.myParentVersion = theParentVersion;
            this.myContainedResources = thePreResourcesState.getContainedResources();
        }

        public List<IBaseReference> getLocalReferences() {
            return this.myLocalReferences;
        }

        @Override
        public void endingElement() throws DataFormatException {
            this.stitchBundleCrossReferences();
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            RuntimeResourceDefinition definition;
            if (this.myResourceType == null) {
                definition = null;
                if (ParserState.this.myParser.getPreferTypes() != null) {
                    for (Class<? extends IBaseResource> next : ParserState.this.myParser.getPreferTypes()) {
                        RuntimeResourceDefinition nextDef = ParserState.this.myContext.getResourceDefinition(next);
                        if (!nextDef.getName().equals(theLocalPart)) continue;
                        definition = nextDef;
                    }
                }
                if (definition == null) {
                    definition = ParserState.this.myContext.getResourceDefinition(this.myParentVersion, theLocalPart);
                }
                if (definition == null) {
                    throw new DataFormatException(Msg.code(1813) + "Element '" + theLocalPart + "' is not a known resource type, expected a resource at this position");
                }
            } else {
                definition = ParserState.this.myContext.getResourceDefinition(this.myResourceType);
                if (!StringUtils.equals((CharSequence)theLocalPart, (CharSequence)definition.getName())) {
                    throw new DataFormatException(Msg.code(1814) + ParserState.this.myContext.getLocalizer().getMessage(ParserState.class, "wrongResourceTypeFound", definition.getName(), theLocalPart));
                }
            }
            RuntimeResourceDefinition def = definition;
            if (!definition.getName().equals(theLocalPart) && definition.getName().equalsIgnoreCase(theLocalPart)) {
                throw new DataFormatException(Msg.code(1815) + "Unknown resource type '" + theLocalPart + "': Resource names are case sensitive, found similar name: '" + definition.getName() + "'");
            }
            this.myInstance = ParserState.this.newInstance(def);
            if (this.myInstance instanceof IResource) {
                ParserState.this.push(new ResourceStateHapi(this.getRootPreResourceState(), def, (IResource)this.myInstance, this.myContainedResources));
            } else {
                ParserState.this.push(new ResourceStateHl7Org(this.getRootPreResourceState(), def, this.myInstance));
            }
        }

        public Map<String, IBaseResource> getContainedResources() {
            return this.myContainedResources;
        }

        @Override
        protected IBaseResource getCurrentElement() {
            return this.myInstance;
        }

        private PreResourceState getRootPreResourceState() {
            if (this.getPreResourceState() != null) {
                return this.getPreResourceState();
            }
            return this;
        }

        @Override
        public boolean isPreResource() {
            return true;
        }

        protected abstract void populateTarget();

        private void postProcess() {
            if (ParserState.this.myContext.hasDefaultTypeForProfile()) {
                IBaseMetaType meta = this.myInstance.getMeta();
                Class<? extends IBaseResource> wantedProfileType = null;
                String usedProfile = null;
                for (IPrimitiveType<String> iPrimitiveType : meta.getProfile()) {
                    if (!StringUtils.isNotBlank((CharSequence)iPrimitiveType.getValue()) || (wantedProfileType = ParserState.this.myContext.getDefaultTypeForProfile(iPrimitiveType.getValue())) == null) continue;
                    usedProfile = iPrimitiveType.getValue();
                    break;
                }
                if (wantedProfileType != null && !wantedProfileType.equals(this.myInstance.getClass()) && (this.myResourceType == null || this.myResourceType.isAssignableFrom(wantedProfileType))) {
                    ourLog.debug("Converting resource of type {} to type defined for profile \"{}\": {}", new Object[]{this.myInstance.getClass().getName(), usedProfile, wantedProfileType});
                    FhirTerser t = ParserState.this.myContext.newTerser();
                    ParserState.this.myGlobalResources.remove(this.myInstance);
                    ParserState.this.myGlobalReferences.removeAll(t.getAllPopulatedChildElementsOfType(this.myInstance, IBaseReference.class));
                    IParser iParser = ParserState.this.myContext.newJsonParser();
                    String asString = iParser.encodeResourceToString(this.myInstance);
                    this.myInstance = iParser.parseResource(wantedProfileType, asString);
                    ParserState.this.myGlobalResources.add(this.myInstance);
                    ParserState.this.myGlobalReferences.addAll(t.getAllPopulatedChildElementsOfType(this.myInstance, IBaseReference.class));
                }
            }
            this.myInstance.setUserData(BaseParser.RESOURCE_CREATED_BY_PARSER, Boolean.TRUE);
            this.populateTarget();
        }

        private void stitchBundleCrossReferences() {
            boolean bundle = "Bundle".equals(ParserState.this.myContext.getResourceType(this.myInstance));
            if (bundle) {
                FhirTerser t = ParserState.this.myContext.newTerser();
                HashMap<String, IBaseResource> idToResource = new HashMap<String, IBaseResource>();
                List<IBase> entries = t.getValues((IBase)this.myInstance, "Bundle.entry", IBase.class);
                for (IBase nextEntry : entries) {
                    IBaseResource resource;
                    IPrimitiveType fullUrl = t.getSingleValueOrNull(nextEntry, "fullUrl", IPrimitiveType.class);
                    if (fullUrl == null || !StringUtils.isNotBlank((CharSequence)fullUrl.getValueAsString()) || (resource = t.getSingleValueOrNull(nextEntry, "resource", IBaseResource.class)) == null) continue;
                    idToResource.put(fullUrl.getValueAsString(), resource);
                }
                for (IBaseResource next : ParserState.this.myGlobalResources) {
                    IIdType id = next.getIdElement();
                    if (id == null || id.isEmpty()) continue;
                    String resName = ParserState.this.myContext.getResourceType(next);
                    IIdType idType = id.withResourceType(resName).toUnqualifiedVersionless();
                    idToResource.put(idType.getValueAsString(), next);
                }
                for (IBaseReference nextRef : ParserState.this.myGlobalReferences) {
                    IIdType unqualifiedVersionless;
                    IBaseResource target;
                    if (nextRef.isEmpty() || nextRef.getReferenceElement() == null || (target = (IBaseResource)idToResource.get((unqualifiedVersionless = nextRef.getReferenceElement().toUnqualifiedVersionless()).getValueAsString())) == null || nextRef.getResource() != null) continue;
                    nextRef.setResource(target);
                }
                List<Pair<String, IBaseResource>> urlsAndResources = BundleUtil.getBundleEntryUrlsAndResources(ParserState.this.myContext, (IBaseBundle)this.myInstance);
                for (Pair<String, IBaseResource> pair : urlsAndResources) {
                    if (pair.getRight() == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)pair.getLeft())) || !((IBaseResource)pair.getRight()).getIdElement().isEmpty() || !((String)pair.getLeft()).startsWith("urn:")) continue;
                    ((IBaseResource)pair.getRight()).setId((String)pair.getLeft());
                }
            }
        }

        void weaveContainedResources() {
            for (IBaseReference nextRef : this.myLocalReferences) {
                String ref = nextRef.getReferenceElement().getValue();
                if (!StringUtils.isNotBlank((CharSequence)ref) || !ref.startsWith("#") || ref.length() <= 1) continue;
                IBaseResource target = this.myContainedResources.get(ref);
                if (target != null) {
                    ourLog.debug("Resource contains local ref {}", (Object)ref);
                    nextRef.setResource(target);
                    continue;
                }
                ParserState.this.myErrorHandler.unknownReference(null, ref);
            }
        }

        @Override
        public void wereBack() {
            this.postProcess();
        }
    }

    private class PreResourceStateHl7Org
    extends PreResourceState {
        private BaseRuntimeChildDefinition.IMutator myMutator;
        private IBase myTarget;

        PreResourceStateHl7Org(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
        }

        PreResourceStateHl7Org(IBase theTarget, BaseRuntimeChildDefinition.IMutator theMutator, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myMutator = theMutator;
            this.myTarget = theTarget;
        }

        @Override
        protected void populateTarget() {
            this.weaveContainedResources();
            if (this.myMutator != null) {
                this.myMutator.setValue(this.myTarget, this.getCurrentElement());
            }
        }

        @Override
        public void wereBack() {
            super.wereBack();
            if (this.getCurrentElement() instanceof IBaseResource) {
                IBaseResource elem = this.getCurrentElement();
                String resourceName = ParserState.this.myContext.getResourceType(elem);
                String versionId = elem.getMeta().getVersionId();
                if (!StringUtils.isBlank((CharSequence)elem.getIdElement().getIdPart()) && !elem.getIdElement().getIdPart().startsWith("urn:")) {
                    if (StringUtils.isNotBlank((CharSequence)versionId)) {
                        elem.getIdElement().setValue(resourceName + "/" + elem.getIdElement().getIdPart() + "/_history/" + versionId);
                    } else {
                        elem.getIdElement().setValue(resourceName + "/" + elem.getIdElement().getIdPart());
                    }
                }
            }
        }
    }

    private class PreResourceStateHapi
    extends PreResourceState {
        private BaseRuntimeChildDefinition.IMutator myMutator;
        private IBase myTarget;

        PreResourceStateHapi(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            assert (theResourceType == null || IResource.class.isAssignableFrom(theResourceType));
        }

        PreResourceStateHapi(IBase theTarget, BaseRuntimeChildDefinition.IMutator theMutator, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myTarget = theTarget;
            this.myMutator = theMutator;
            assert (theResourceType == null || IResource.class.isAssignableFrom(theResourceType));
        }

        @Override
        protected void populateTarget() {
            this.weaveContainedResources();
            if (this.myMutator != null) {
                this.myMutator.setValue(this.myTarget, this.getCurrentElement());
            }
        }

        @Override
        public void wereBack() {
            super.wereBack();
            IResource nextResource = (IResource)this.getCurrentElement();
            String version = ResourceMetadataKeyEnum.VERSION.get(nextResource);
            String resourceName = ParserState.this.myContext.getResourceType(nextResource);
            String bundleIdPart = nextResource.getId().getIdPart();
            if (StringUtils.isNotBlank((CharSequence)bundleIdPart)) {
                IdDt previousId = nextResource.getId();
                nextResource.setId(new IdDt(null, resourceName, bundleIdPart, version));
                if (!previousId.getAllUndeclaredExtensions().isEmpty()) {
                    for (ExtensionDt ext : previousId.getAllUndeclaredExtensions()) {
                        nextResource.getId().addUndeclaredExtension(ext);
                    }
                }
            }
        }
    }

    private class PreTagListState
    extends BaseState {
        private TagList myTagList;

        PreTagListState() {
            super(null);
            this.myTagList = new TagList();
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!TagList.ELEMENT_NAME_LC.equals(theLocalPart.toLowerCase())) {
                throw new DataFormatException(Msg.code(1816) + "resourceType does not appear to be 'TagList', found: " + theLocalPart);
            }
            ParserState.this.push(new TagListState(this.myTagList));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myTagList;
        }

        @Override
        public boolean isPreResource() {
            return true;
        }
    }

    private class XhtmlStateHl7Org
    extends XhtmlState {
        private IBaseXhtml myHl7OrgDatatype;

        private XhtmlStateHl7Org(PreResourceState thePreResourceState, IBaseXhtml theHl7OrgDatatype) {
            super(thePreResourceState, new XhtmlDt(), true);
            this.myHl7OrgDatatype = theHl7OrgDatatype;
        }

        @Override
        public void doPop() {
            String value = this.getDt().getValueAsString();
            this.myHl7OrgDatatype.setValueAsString(value);
            super.doPop();
        }
    }

    private class XhtmlState
    extends BaseState {
        private int myDepth;
        private XhtmlDt myDt;
        private List<XMLEvent> myEvents;
        private boolean myIncludeOuterEvent;

        private XhtmlState(PreResourceState thePreResourceState, XhtmlDt theXhtmlDt, boolean theIncludeOuterEvent) throws DataFormatException {
            super(thePreResourceState);
            this.myEvents = new ArrayList<XMLEvent>();
            this.myDepth = 0;
            this.myDt = theXhtmlDt;
            this.myIncludeOuterEvent = theIncludeOuterEvent;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.myDt.setValueAsString(theValue);
            }
        }

        protected void doPop() {
            ParserState.this.pop();
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.doPop();
                return;
            }
            super.endingElement();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myDt;
        }

        public XhtmlDt getDt() {
            return this.myDt;
        }

        @Override
        public void xmlEvent(XMLEvent theEvent) {
            if (theEvent.isEndElement()) {
                --this.myDepth;
            }
            if (this.myIncludeOuterEvent || this.myDepth > 0) {
                this.myEvents.add(theEvent);
            }
            if (theEvent.isStartElement()) {
                ++this.myDepth;
            }
            if (theEvent.isEndElement() && this.myDepth == 0) {
                String eventsAsString = XmlUtil.encode(this.myEvents);
                this.myDt.setValue(eventsAsString);
                this.doPop();
            }
        }
    }

    private class TagState
    extends BaseState {
        private static final int LABEL = 2;
        private static final int NONE = 0;
        private static final int SCHEME = 3;
        private static final int TERM = 1;
        private String myLabel;
        private String myScheme;
        private int mySubState;
        private TagList myTagList;
        private String myTerm;

        public TagState(TagList theTagList) {
            super(null);
            this.mySubState = 0;
            this.myTagList = theTagList;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            String value = (String)StringUtils.defaultIfBlank((CharSequence)theValue, null);
            switch (this.mySubState) {
                case 1: {
                    this.myTerm = value;
                    break;
                }
                case 2: {
                    this.myLabel = value;
                    break;
                }
                case 3: {
                    this.myScheme = value;
                    break;
                }
                case 0: {
                    this.enteringNewElement(null, theName);
                    this.attributeValue(null, value);
                    this.endingElement();
                }
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.mySubState != 0) {
                this.mySubState = 0;
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.myScheme) || StringUtils.isNotBlank((CharSequence)this.myTerm) || StringUtils.isNotBlank((CharSequence)this.myLabel)) {
                    this.myTagList.addTag(this.myScheme, this.myTerm, this.myLabel);
                }
                ParserState.this.pop();
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("term".equals(theLocalPart) || "code".equals(theLocalPart)) {
                this.mySubState = 1;
            } else if ("scheme".equals(theLocalPart) || "system".equals(theLocalPart)) {
                this.mySubState = 3;
            } else if ("label".equals(theLocalPart) || "display".equals(theLocalPart)) {
                this.mySubState = 2;
            } else {
                throw new DataFormatException(Msg.code(1818) + "Unexpected element: " + theLocalPart);
            }
        }
    }

    private class TagListState
    extends BaseState {
        private TagList myTagList;

        public TagListState(TagList theTagList) {
            super(null);
            this.myTagList = theTagList;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!"category".equals(theLocalPart)) {
                throw new DataFormatException(Msg.code(1817) + "Unexpected element: " + theLocalPart);
            }
            ParserState.this.push(new TagState(this.myTagList));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myTagList;
        }
    }

    private class SwallowChildrenWholeState
    extends BaseState {
        private int myDepth;

        SwallowChildrenWholeState(PreResourceState thePreResourceState) {
            super(thePreResourceState);
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
        }

        @Override
        public void endingElement() throws DataFormatException {
            --this.myDepth;
            if (this.myDepth < 0) {
                ParserState.this.pop();
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ++this.myDepth;
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            ++this.myDepth;
        }
    }

    private class SecurityLabelElementStateHapi
    extends ElementCompositeState {
        SecurityLabelElementStateHapi(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IBase codingDt) {
            super(thePreResourceState, theDef.getName(), theDef, codingDt);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }
    }

    private class ResourceStateHl7Org
    extends ElementCompositeState {
        ResourceStateHl7Org(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IBaseResource theInstance) {
            super(thePreResourceState, theDef.getName(), theDef, theInstance);
        }
    }

    private class ResourceStateHapi
    extends ElementCompositeState {
        private IResource myInstance;

        public ResourceStateHapi(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IResource theInstance, Map<String, IBaseResource> theContainedResources) {
            super(thePreResourceState, theDef.getName(), theDef, theInstance);
            this.myInstance = theInstance;
        }

        @Override
        public void enteringNewElement(String theNamespace, String theChildName) throws DataFormatException {
            if ("id".equals(theChildName)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myInstance.getId(), theChildName, "id"));
            } else if ("meta".equals(theChildName)) {
                ParserState.this.push(new MetaElementState(this.getPreResourceState(), this.myInstance.getResourceMetadata()));
            } else {
                super.enteringNewElement(theNamespace, theChildName);
            }
        }
    }

    private class PrimitiveState
    extends BaseState {
        private final String myChildName;
        private final String myTypeName;
        private IPrimitiveType<?> myInstance;

        PrimitiveState(PreResourceState thePreResourceState, IPrimitiveType<?> theInstance, String theChildName, String theTypeName) {
            super(thePreResourceState);
            this.myInstance = theInstance;
            this.myChildName = theChildName;
            this.myTypeName = theTypeName;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            Object value = theValue;
            if ("value".equals(theName)) {
                if ("".equals(value)) {
                    ParseLocation location = ParseLocation.fromElementName(this.myChildName);
                    ParserState.this.myErrorHandler.invalidValue(location, (String)value, "Attribute value must not be empty (\"\")");
                } else {
                    if ("decimal".equals(this.myTypeName) && value != null) {
                        if (((String)value).startsWith(".") && NumberUtils.isDigits((String)((String)value).substring(1))) {
                            value = "0" + (String)value;
                        } else {
                            while (((String)value).startsWith("00")) {
                                value = ((String)value).substring(1);
                            }
                        }
                    }
                    try {
                        this.myInstance.setValueAsString((String)value);
                    }
                    catch (DataFormatException | IllegalArgumentException e) {
                        ParseLocation location = ParseLocation.fromElementName(this.myChildName);
                        ParserState.this.myErrorHandler.invalidValue(location, (String)value, e.getMessage());
                    }
                }
            } else if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)((Object)this.myInstance)).setElementSpecificId((String)value);
                } else if (this.myInstance instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.myInstance)).setId((String)value);
                } else if (this.myInstance instanceof IBaseResource) {
                    new IdDt((String)value).applyTo((IBaseResource)((Object)this.myInstance));
                } else {
                    ParseLocation location = ParseLocation.fromElementName(this.myChildName);
                    ParserState.this.myErrorHandler.unknownAttribute(location, theName);
                }
            } else {
                super.attributeValue(theName, (String)value);
            }
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            super.enteringNewElement(theNamespaceUri, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myInstance;
        }
    }

    private class MetaVersionElementState
    extends BaseState {
        private final ResourceMetadataMap myMap;

        MetaVersionElementState(PreResourceState thePreResourceState, ResourceMetadataMap theMap) {
            super(thePreResourceState);
            this.myMap = theMap;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myMap.put(ResourceMetadataKeyEnum.VERSION, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }
    }

    private class MetaElementState
    extends BaseState {
        private final ResourceMetadataMap myMap;

        public MetaElementState(PreResourceState thePreResourceState, ResourceMetadataMap theMap) {
            super(thePreResourceState);
            this.myMap = theMap;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            switch (theLocalPart) {
                case "versionId": {
                    ParserState.this.push(new MetaVersionElementState(this.getPreResourceState(), this.myMap));
                    break;
                }
                case "lastUpdated": {
                    InstantDt updated = new InstantDt();
                    ParserState.this.push(new PrimitiveState(this.getPreResourceState(), updated, theLocalPart, "instant"));
                    this.myMap.put(ResourceMetadataKeyEnum.UPDATED, updated);
                    break;
                }
                case "security": {
                    ArrayList<IBase> securityLabels = (ArrayList<IBase>)this.myMap.get(ResourceMetadataKeyEnum.SECURITY_LABELS);
                    if (securityLabels == null) {
                        securityLabels = new ArrayList<IBase>();
                        this.myMap.put(ResourceMetadataKeyEnum.SECURITY_LABELS, securityLabels);
                    }
                    IBase securityLabel = ParserState.this.myContext.getVersion().newCodingDt();
                    BaseRuntimeElementCompositeDefinition codinfDef = (BaseRuntimeElementCompositeDefinition)ParserState.this.myContext.getElementDefinition(securityLabel.getClass());
                    ParserState.this.push(new SecurityLabelElementStateHapi(this.getPreResourceState(), codinfDef, securityLabel));
                    securityLabels.add(securityLabel);
                    break;
                }
                case "profile": {
                    ArrayList<IdDt> newProfiles;
                    List profiles = (List)this.myMap.get(ResourceMetadataKeyEnum.PROFILES);
                    if (profiles != null) {
                        newProfiles = new ArrayList(profiles.size() + 1);
                        newProfiles.addAll(profiles);
                    } else {
                        newProfiles = new ArrayList<IdDt>(1);
                    }
                    IdDt profile = new IdDt();
                    ParserState.this.push(new PrimitiveState(this.getPreResourceState(), profile, theLocalPart, "id"));
                    newProfiles.add(profile);
                    this.myMap.put(ResourceMetadataKeyEnum.PROFILES, Collections.unmodifiableList(newProfiles));
                    break;
                }
                case "tag": {
                    TagList tagList = (TagList)this.myMap.get(ResourceMetadataKeyEnum.TAG_LIST);
                    if (tagList == null) {
                        tagList = new TagList();
                        this.myMap.put(ResourceMetadataKeyEnum.TAG_LIST, tagList);
                    }
                    ParserState.this.push(new TagState(tagList));
                    break;
                }
                default: {
                    ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                    ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                }
            }
        }

        @Override
        public void enteringNewElementExtension(StartElement theElem, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            ExtensionDt newExtension;
            ResourceMetadataKeyEnum.ExtensionResourceMetadataKey resourceMetadataKeyEnum = new ResourceMetadataKeyEnum.ExtensionResourceMetadataKey(theUrlAttr);
            Object metadataValue = this.myMap.get(resourceMetadataKeyEnum);
            if (metadataValue == null) {
                newExtension = new ExtensionDt(theIsModifier);
            } else if (metadataValue instanceof ExtensionDt) {
                newExtension = (ExtensionDt)metadataValue;
            } else {
                throw new IllegalStateException(Msg.code(1812) + "Expected ExtensionDt as custom resource metadata type, got: " + metadataValue.getClass().getSimpleName());
            }
            newExtension.setUrl(theUrlAttr);
            this.myMap.put(resourceMetadataKeyEnum, newExtension);
            ExtensionState newState = new ExtensionState(this.getPreResourceState(), newExtension);
            ParserState.this.push(newState);
        }
    }

    public class IdentifiableElementIdState
    extends BaseState {
        private final IIdentifiableElement myElement;

        public IdentifiableElementIdState(PreResourceState thePreResourceState, IIdentifiableElement theElement) {
            super(thePreResourceState);
            this.myElement = theElement;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myElement.setElementSpecificId(theValue);
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }
    }

    private class ExtensionState
    extends BaseState {
        private final IBaseExtension<?, ?> myExtension;

        ExtensionState(PreResourceState thePreResourceState, IBaseExtension<?, ?> theExtension) {
            super(thePreResourceState);
            this.myExtension = theExtension;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("url".equals(theName)) {
                return;
            }
            if ("id".equals(theName)) {
                if (this.getCurrentElement() instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.getCurrentElement())).setId(theValue);
                    return;
                }
                if (this.getCurrentElement() instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)this.getCurrentElement()).setElementSpecificId(theValue);
                    return;
                }
            }
            super.attributeValue(theName, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.myExtension.getValue() != null && this.myExtension.getExtension().size() > 0) {
                throw new DataFormatException(Msg.code(1811) + "Extension (URL='" + this.myExtension.getUrl() + "') must not have both a value and other contained extensions");
            }
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            BaseRuntimeElementDefinition<?> target;
            if (theLocalPart.equals("id")) {
                if (this.getCurrentElement() instanceof IBaseElement) {
                    ParserState.this.push(new ElementIdState(this.getPreResourceState(), (IBaseElement)((Object)this.getCurrentElement())));
                    return;
                }
                if (this.getCurrentElement() instanceof IIdentifiableElement) {
                    ParserState.this.push(new IdentifiableElementIdState(this.getPreResourceState(), (IIdentifiableElement)this.getCurrentElement()));
                    return;
                }
            }
            if ((target = ParserState.this.myContext.getRuntimeChildUndeclaredExtensionDefinition().getChildByName(theLocalPart)) != null) {
                switch (target.getChildType()) {
                    case COMPOSITE_DATATYPE: {
                        BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                        ICompositeType newChildInstance = ParserState.this.newCompositeTypeInstance(this.getPreResourceState(), compositeTarget);
                        this.myExtension.setValue(newChildInstance);
                        ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), theLocalPart, compositeTarget, newChildInstance);
                        ParserState.this.push(newState);
                        return;
                    }
                    case ID_DATATYPE: 
                    case PRIMITIVE_DATATYPE: {
                        RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                        IPrimitiveType<?> newChildInstance = ParserState.this.newInstance(primitiveTarget);
                        this.myExtension.setValue(newChildInstance);
                        PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance, theLocalPart, primitiveTarget.getName());
                        ParserState.this.push(newState);
                        return;
                    }
                }
            }
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        @Override
        protected IBaseExtension<?, ?> getCurrentElement() {
            return this.myExtension;
        }
    }

    public class ElementIdState
    extends BaseState {
        private final IBaseElement myElement;

        ElementIdState(PreResourceState thePreResourceState, IBaseElement theElement) {
            super(thePreResourceState);
            this.myElement = theElement;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myElement.setId(theValue);
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }
    }

    private class ElementCompositeState
    extends BaseState {
        private final BaseRuntimeElementCompositeDefinition<?> myDefinition;
        private final IBase myInstance;
        private final Set<String> myParsedNonRepeatableNames;
        private final String myElementName;

        ElementCompositeState(PreResourceState thePreResourceState, String theElementName, BaseRuntimeElementCompositeDefinition<?> theDef, IBase theInstance) {
            super(thePreResourceState);
            this.myParsedNonRepeatableNames = new HashSet<String>();
            this.myDefinition = theDef;
            this.myInstance = theInstance;
            this.myElementName = theElementName;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)this.myInstance).setElementSpecificId(theValue);
                } else if (this.myInstance instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.myInstance)).setId(theValue);
                }
            } else if (ParserState.this.myJsonMode) {
                ParserState.this.myErrorHandler.incorrectJsonType(null, this.myElementName, JsonLikeValue.ValueType.OBJECT, null, JsonLikeValue.ValueType.SCALAR, JsonLikeValue.ScalarType.STRING);
            } else {
                ParserState.this.myErrorHandler.unknownAttribute(null, theName);
            }
        }

        @Override
        public boolean elementIsRepeating(String theChildName) {
            BaseRuntimeChildDefinition child = this.myDefinition.getChildByName(theChildName);
            if (child == null) {
                return false;
            }
            return child.getMax() > 1 || child.getMax() == -1;
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespace, String theChildName) throws DataFormatException {
            BaseRuntimeChildDefinition child = this.myDefinition.getChildByName(theChildName);
            if (child == null) {
                if (theChildName.equals("id") && this.getCurrentElement() instanceof IIdentifiableElement) {
                    ParserState.this.push(new IdentifiableElementIdState(this.getPreResourceState(), (IIdentifiableElement)this.getCurrentElement()));
                    return;
                }
                ParserState.this.myErrorHandler.unknownElement(null, theChildName);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            if (!(child.getMax() != 0 && child.getMax() != 1 || this.myParsedNonRepeatableNames.add(theChildName))) {
                ParserState.this.myErrorHandler.unexpectedRepeatingElement(null, theChildName);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            BaseRuntimeElementDefinition<?> target = child.getChildByName(theChildName);
            if (target == null) {
                throw new DataFormatException(Msg.code(1809) + "Found unexpected element '" + theChildName + "' in parent element '" + this.myDefinition.getName() + "'. Valid names are: " + child.getValidChildNames());
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = ParserState.this.newCompositeInstance(this.getPreResourceState(), child, compositeTarget);
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), theChildName, compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case ID_DATATYPE: 
                case PRIMITIVE_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType<?> newChildInstance = ParserState.this.getPrimitiveInstance(child, primitiveTarget, theChildName);
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance, theChildName, primitiveTarget.getName());
                    ParserState.this.push(newState);
                    return;
                }
                case RESOURCE_BLOCK: {
                    RuntimeResourceBlockDefinition blockTarget = (RuntimeResourceBlockDefinition)target;
                    IBase newBlockInstance = ParserState.this.newInstance(blockTarget);
                    child.getMutator().addValue(this.myInstance, newBlockInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), theChildName, blockTarget, newBlockInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case PRIMITIVE_XHTML: {
                    RuntimePrimitiveDatatypeNarrativeDefinition xhtmlTarget = (RuntimePrimitiveDatatypeNarrativeDefinition)target;
                    XhtmlDt newDt = ParserState.this.newInstance(xhtmlTarget);
                    child.getMutator().addValue(this.myInstance, newDt);
                    XhtmlState state = new XhtmlState(this.getPreResourceState(), newDt, true);
                    ParserState.this.push(state);
                    return;
                }
                case PRIMITIVE_XHTML_HL7ORG: {
                    RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition xhtmlTarget = (RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition)target;
                    IBaseXhtml newDt = ParserState.this.newInstance(xhtmlTarget);
                    child.getMutator().addValue(this.myInstance, newDt);
                    XhtmlStateHl7Org state = new XhtmlStateHl7Org(this.getPreResourceState(), newDt);
                    ParserState.this.push(state);
                    return;
                }
                case CONTAINED_RESOURCES: {
                    List<IBase> values = child.getAccessor().getValues(this.myInstance);
                    if (values == null || values.isEmpty() || values.get(0) == null) {
                        Object newDt = ParserState.this.newContainedDt((IResource)this.getPreResourceState().myInstance);
                        child.getMutator().addValue(this.myInstance, (IBase)newDt);
                    }
                    ContainedResourcesStateHapi state = new ContainedResourcesStateHapi(this.getPreResourceState());
                    ParserState.this.push(state);
                    return;
                }
                case CONTAINED_RESOURCE_LIST: {
                    ContainedResourcesStateHl7Org state = new ContainedResourcesStateHl7Org(this.getPreResourceState());
                    ParserState.this.push(state);
                    return;
                }
                case RESOURCE: {
                    if (this.myInstance instanceof IAnyResource || this.myInstance instanceof IBaseBackboneElement || this.myInstance instanceof IBaseElement) {
                        PreResourceStateHl7Org state = new PreResourceStateHl7Org(this.myInstance, child.getMutator(), null);
                        ParserState.this.push(state);
                    } else {
                        PreResourceStateHapi state = new PreResourceStateHapi(this.myInstance, child.getMutator(), null);
                        ParserState.this.push(state);
                    }
                    return;
                }
            }
            throw new DataFormatException(Msg.code(1810) + "Illegal resource position: " + target.getChildType());
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            RuntimeChildDeclaredExtensionDefinition declaredExtension = this.myDefinition.getDeclaredExtension(theUrlAttr, baseServerUrl);
            if (declaredExtension != null) {
                DeclaredExtensionState newState = new DeclaredExtensionState(this.getPreResourceState(), declaredExtension, this.myInstance);
                ParserState.this.push(newState);
            } else {
                super.enteringNewElementExtension(theElement, theUrlAttr, theIsModifier, baseServerUrl);
            }
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myInstance;
        }
    }

    private class DeclaredExtensionState
    extends BaseState {
        private IBase myChildInstance;
        private RuntimeChildDeclaredExtensionDefinition myDefinition;
        private IBase myParentInstance;
        private PreResourceState myPreResourceState;

        public DeclaredExtensionState(PreResourceState thePreResourceState, RuntimeChildDeclaredExtensionDefinition theDefinition, IBase theParentInstance) {
            super(thePreResourceState);
            this.myPreResourceState = thePreResourceState;
            this.myDefinition = theDefinition;
            this.myParentInstance = theParentInstance;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (theName.equals("url")) {
                return;
            }
            super.attributeValue(theName, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            BaseRuntimeElementDefinition<?> target = this.myDefinition.getChildByName(theLocalPart);
            if (target == null) {
                ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = ParserState.this.newCompositeInstance(this.getPreResourceState(), this.myDefinition, compositeTarget);
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.myPreResourceState, theLocalPart, compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case ID_DATATYPE: 
                case PRIMITIVE_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType<?> newChildInstance = ParserState.this.newPrimitiveInstance(this.myDefinition, primitiveTarget);
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance, theLocalPart, primitiveTarget.getName());
                    ParserState.this.push(newState);
                    return;
                }
            }
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier, String baseServerUrl) {
            RuntimeChildDeclaredExtensionDefinition declaredExtension = this.myDefinition.getChildExtensionForUrl(theUrlAttr);
            if (declaredExtension != null) {
                if (this.myChildInstance == null) {
                    this.myChildInstance = ParserState.this.newInstance(this.myDefinition);
                    this.myDefinition.getMutator().addValue(this.myParentInstance, this.myChildInstance);
                }
                DeclaredExtensionState newState = new DeclaredExtensionState(this.getPreResourceState(), declaredExtension, this.myChildInstance);
                ParserState.this.push(newState);
            } else {
                super.enteringNewElementExtension(theElement, theUrlAttr, theIsModifier, baseServerUrl);
            }
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myParentInstance;
        }
    }

    private class ContainedResourcesStateHl7Org
    extends PreResourceState {
        public ContainedResourcesStateHl7Org(PreResourceState thePreResourcesState) {
            super(thePreResourcesState, thePreResourcesState.myParentVersion);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        protected void populateTarget() {
        }

        @Override
        public void wereBack() {
            super.wereBack();
            IBaseResource res = this.getCurrentElement();
            assert (res != null);
            if (res.getIdElement() == null || res.getIdElement().isEmpty()) {
                ParserState.this.myErrorHandler.containedResourceWithNoId(null);
            } else {
                res.getIdElement().setValue("#" + res.getIdElement().getIdPart());
                this.getPreResourceState().getContainedResources().put(res.getIdElement().getValue(), res);
            }
            IBaseResource preResCurrentElement = this.getPreResourceState().getCurrentElement();
            RuntimeResourceDefinition def = ParserState.this.myContext.getResourceDefinition(preResCurrentElement);
            def.getChildByName("contained").getMutator().addValue(preResCurrentElement, res);
        }
    }

    private class ContainedResourcesStateHapi
    extends PreResourceState {
        public ContainedResourcesStateHapi(PreResourceState thePreResourcesState) {
            super(thePreResourcesState, thePreResourcesState.myInstance.getStructureFhirVersionEnum());
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        protected void populateTarget() {
        }

        @Override
        public void wereBack() {
            super.wereBack();
            IResource res = (IResource)this.getCurrentElement();
            assert (res != null);
            if (res.getId() == null || res.getId().isEmpty()) {
                ParserState.this.myErrorHandler.containedResourceWithNoId(null);
            } else {
                if (!res.getId().isLocal()) {
                    res.setId(new IdDt("#" + res.getId().getIdPart()));
                }
                this.getPreResourceState().getContainedResources().put(res.getId().getValueAsString(), res);
            }
            IResource preResCurrentElement = (IResource)this.getPreResourceState().getCurrentElement();
            List<? extends IResource> containedResources = preResCurrentElement.getContained().getContainedResources();
            containedResources.add(res);
        }
    }
}

