/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.tls;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.tls.KeyStoreType;
import ca.uhn.fhir.tls.PathType;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class StoreInfo {
    private final String myFilePath;
    private final PathType myPathType;
    private final char[] myStorePass;
    private final String myAlias;
    private final KeyStoreType myType;

    public StoreInfo(String theFilePath, String theStorePass, String theAlias) {
        if (theFilePath.startsWith(PathType.RESOURCE.getPrefix())) {
            this.myFilePath = theFilePath.substring(PathType.RESOURCE.getPrefix().length());
            this.myPathType = PathType.RESOURCE;
        } else if (theFilePath.startsWith(PathType.FILE.getPrefix())) {
            this.myFilePath = theFilePath.substring(PathType.FILE.getPrefix().length());
            this.myPathType = PathType.FILE;
        } else {
            throw new StoreInfoException(Msg.code(2117) + "Invalid path prefix");
        }
        this.myStorePass = this.toCharArray(theStorePass);
        this.myAlias = theAlias;
        String extension = FilenameUtils.getExtension((String)theFilePath);
        this.myType = KeyStoreType.fromFileExtension(extension);
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public char[] getStorePass() {
        return this.myStorePass;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public KeyStoreType getType() {
        return this.myType;
    }

    public PathType getPathType() {
        return this.myPathType;
    }

    protected char[] toCharArray(String theString) {
        return StringUtils.isBlank((CharSequence)theString) ? "".toCharArray() : theString.toCharArray();
    }

    public static class StoreInfoException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StoreInfoException(String theMessage) {
            super(theMessage);
        }
    }
}

