/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.parser.ParseErrorHandler;
import ca.uhn.fhir.parser.json.BaseJsonLikeValue;
import ca.uhn.fhir.util.UrlUtil;

public class StrictErrorHandler
extends ParseErrorHandler
implements IParserErrorHandler {
    @Override
    public void containedResourceWithNoId(IParserErrorHandler.IParseLocation theLocation) {
        throw new DataFormatException(Msg.code(1819) + "Resource has contained child resource with no ID");
    }

    @Override
    public void incorrectJsonType(IParserErrorHandler.IParseLocation theLocation, String theElementName, BaseJsonLikeValue.ValueType theExpected, BaseJsonLikeValue.ScalarType theExpectedScalarType, BaseJsonLikeValue.ValueType theFound, BaseJsonLikeValue.ScalarType theFoundScalarType) {
        String message = LenientErrorHandler.createIncorrectJsonTypeMessage(theElementName, theExpected, theExpectedScalarType, theFound, theFoundScalarType);
        throw new DataFormatException(Msg.code(1820) + message);
    }

    @Override
    public void invalidValue(IParserErrorHandler.IParseLocation theLocation, String theValue, String theError) {
        throw new DataFormatException(Msg.code(1821) + this.describeLocation(theLocation) + "Invalid attribute value \"" + UrlUtil.sanitizeUrlPart(theValue) + "\": " + theError);
    }

    @Override
    public void missingRequiredElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        StringBuilder b = new StringBuilder();
        b.append("Resource is missing required element '");
        b.append(theElementName);
        b.append("'");
        if (theLocation != null) {
            b.append(" in parent element '");
            b.append(theLocation.getParentElementName());
            b.append("'");
        }
        throw new DataFormatException(Msg.code(1822) + b.toString());
    }

    @Override
    public void unexpectedRepeatingElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        throw new DataFormatException(Msg.code(1823) + this.describeLocation(theLocation) + "Multiple repetitions of non-repeatable element '" + theElementName + "' found during parse");
    }

    @Override
    public void unknownAttribute(IParserErrorHandler.IParseLocation theLocation, String theAttributeName) {
        throw new DataFormatException(Msg.code(1824) + this.describeLocation(theLocation) + "Unknown attribute '" + theAttributeName + "' found during parse");
    }

    @Override
    public void unknownElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        throw new DataFormatException(Msg.code(1825) + this.describeLocation(theLocation) + "Unknown element '" + theElementName + "' found during parse");
    }

    @Override
    public void unknownReference(IParserErrorHandler.IParseLocation theLocation, String theReference) {
        throw new DataFormatException(Msg.code(1826) + this.describeLocation(theLocation) + "Resource has invalid reference: " + theReference);
    }

    @Override
    public void extensionContainsValueAndNestedExtensions(IParserErrorHandler.IParseLocation theLocation) {
        throw new DataFormatException(Msg.code(1827) + this.describeLocation(theLocation) + "Extension contains both a value and nested extensions");
    }
}

