/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.model;

import ca.uhn.fhir.interceptor.model.PartitionIdRequestDetails;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ReadPartitionIdRequestDetails
extends PartitionIdRequestDetails {
    private final String myResourceType;
    private final RestOperationTypeEnum myRestOperationType;
    private final IIdType myReadResourceId;
    private final Object mySearchParams;
    private final IBaseResource myConditionalTargetOrNull;

    public ReadPartitionIdRequestDetails(String theResourceType, RestOperationTypeEnum theRestOperationType, IIdType theReadResourceId, Object theSearchParams, @Nullable IBaseResource theConditionalTargetOrNull) {
        this.myResourceType = theResourceType;
        this.myRestOperationType = theRestOperationType;
        this.myReadResourceId = theReadResourceId;
        this.mySearchParams = theSearchParams;
        this.myConditionalTargetOrNull = theConditionalTargetOrNull;
    }

    public static ReadPartitionIdRequestDetails forRead(String theResourceType, IIdType theId, boolean theIsVread) {
        RestOperationTypeEnum op = theIsVread ? RestOperationTypeEnum.VREAD : RestOperationTypeEnum.READ;
        return new ReadPartitionIdRequestDetails(theResourceType, op, theId.withResourceType(theResourceType), null, null);
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public RestOperationTypeEnum getRestOperationType() {
        return this.myRestOperationType;
    }

    public IIdType getReadResourceId() {
        return this.myReadResourceId;
    }

    public Object getSearchParams() {
        return this.mySearchParams;
    }

    public IBaseResource getConditionalTargetOrNull() {
        return this.myConditionalTargetOrNull;
    }

    public static ReadPartitionIdRequestDetails forSearchType(String theResourceType, Object theParams, IBaseResource theConditionalOperationTargetOrNull) {
        return new ReadPartitionIdRequestDetails(theResourceType, RestOperationTypeEnum.SEARCH_TYPE, null, theParams, theConditionalOperationTargetOrNull);
    }

    public static ReadPartitionIdRequestDetails forHistory(String theResourceType, IIdType theIdType) {
        RestOperationTypeEnum restOperationTypeEnum = theIdType != null ? RestOperationTypeEnum.HISTORY_INSTANCE : (theResourceType != null ? RestOperationTypeEnum.HISTORY_TYPE : RestOperationTypeEnum.HISTORY_SYSTEM);
        return new ReadPartitionIdRequestDetails(theResourceType, restOperationTypeEnum, theIdType, null, null);
    }
}

