/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.base.composite;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseIdentifierDt
extends BaseIdentifiableElement
implements ICompositeDatatype,
IQueryParameterType {
    private static final long serialVersionUID = 4400972469749953077L;

    @Override
    public String getQueryParameterQualifier() {
        return null;
    }

    public abstract UriDt getSystemElement();

    public abstract StringDt getValueElement();

    @Override
    public String getValueAsQueryToken(FhirContext theContext) {
        UriDt system = this.getSystemElement();
        StringDt value = this.getValueElement();
        if (system.getValueAsString() != null) {
            return ParameterUtil.escape(StringUtils.defaultString((String)system.getValueAsString())) + "|" + ParameterUtil.escape(value.getValueAsString());
        }
        return ParameterUtil.escape(value.getValueAsString());
    }

    public boolean matchesSystemAndValue(BaseIdentifierDt theIdentifier) {
        if (theIdentifier == null) {
            return false;
        }
        return this.getValueElement().equals(theIdentifier.getValueElement()) && this.getSystemElement().equals(theIdentifier.getSystemElement());
    }

    public abstract BaseIdentifierDt setSystem(String var1);

    public abstract BaseIdentifierDt setValue(String var1);

    @Override
    public void setValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theParameter) {
        int barIndex = ParameterUtil.nonEscapedIndexOf(theParameter, '|');
        if (barIndex != -1) {
            this.setSystem(theParameter.substring(0, barIndex));
            this.setValue(ParameterUtil.unescape(theParameter.substring(barIndex + 1)));
        } else {
            this.setValue(ParameterUtil.unescape(theParameter));
        }
    }

    @Override
    @Deprecated
    public Boolean getMissing() {
        return null;
    }

    @Override
    @Deprecated
    public IQueryParameterType setMissing(Boolean theMissing) {
        throw new UnsupportedOperationException(Msg.code(1907) + "get/setMissing is not supported in StringDt. Use {@link StringParam} instead if you need this functionality");
    }
}

