/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.parser.path.EncodeContextPath;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ParserUtil {
    private ParserUtil() {
    }

    @Nullable
    public static Set<String> determineApplicableResourceTypesForTerserPaths(@Nullable List<EncodeContextPath> encodeElements) {
        HashSet<String> encodeElementsAppliesToResourceTypes = null;
        if (encodeElements != null) {
            encodeElementsAppliesToResourceTypes = new HashSet<String>();
            for (String next : encodeElements.stream().map(t -> t.getPath().get(0).getName()).collect(Collectors.toList())) {
                if (next.startsWith("*")) {
                    encodeElementsAppliesToResourceTypes = null;
                    break;
                }
                int dotIdx = next.indexOf(46);
                if (dotIdx == -1) {
                    encodeElementsAppliesToResourceTypes.add(next);
                    continue;
                }
                encodeElementsAppliesToResourceTypes.add(next.substring(0, dotIdx));
            }
        }
        return encodeElementsAppliesToResourceTypes;
    }
}

