/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.demo;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.demo.ContextHolder;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dialect.HapiFhirH2Dialect;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.h2.Driver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommonConfig {
    @Bean
    public DaoConfig daoConfig() {
        DaoConfig retVal = new DaoConfig();
        retVal.setAllowMultipleDelete(true);
        return retVal;
    }

    @Bean
    public ModelConfig modelConfig() {
        return this.daoConfig().getModelConfig();
    }

    @Bean(destroyMethod="close")
    public DataSource dataSource() {
        String url = "jdbc:h2:file:./target/jpaserver_h2_files";
        if (StringUtils.isNotBlank((CharSequence)ContextHolder.getDatabaseUrl())) {
            url = ContextHolder.getDatabaseUrl();
        }
        BasicDataSource retVal = new BasicDataSource();
        retVal.setDriver((java.sql.Driver)new Driver());
        retVal.setUrl(url);
        retVal.setUsername("");
        retVal.setPassword("");
        return retVal;
    }

    @Bean
    public Properties jpaProperties() {
        Properties extraProperties = new Properties();
        extraProperties.put("hibernate.dialect", HapiFhirH2Dialect.class.getName());
        extraProperties.put("hibernate.format_sql", "true");
        extraProperties.put("hibernate.show_sql", "false");
        extraProperties.put("hibernate.hbm2ddl.auto", "update");
        extraProperties.put("hibernate.jdbc.batch_size", "20");
        extraProperties.put("hibernate.cache.use_query_cache", "false");
        extraProperties.put("hibernate.cache.use_second_level_cache", "false");
        extraProperties.put("hibernate.cache.use_structured_entries", "false");
        extraProperties.put("hibernate.cache.use_minimal_puts", "false");
        extraProperties.put("hibernate.search.backend.type", "lucene");
        extraProperties.put("hibernate.search.enabled", "false");
        return extraProperties;
    }

    @Bean
    public PartitionSettings partitionSettings() {
        return new PartitionSettings();
    }
}

