/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.demo;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.demo.ContextHolder;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.Validate;

public class ContextHolder {
    private static boolean ourAllowExternalRefs;
    private static FhirContext ourCtx;
    private static boolean ourDisableReferentialIntegrity;
    private static String ourPath;
    private static Long ourReuseSearchResultsMillis;
    private static String ourDatabaseUrl;

    public static FhirContext getCtx() {
        Validate.notNull((Object)ourPath, (String)"Context not set", (Object[])new Object[0]);
        return ourCtx;
    }

    public static void setCtx(FhirContext theCtx) throws ParseException {
        switch (1.$SwitchMap$ca$uhn$fhir$context$FhirVersionEnum[theCtx.getVersion().getVersion().ordinal()]) {
            case 1: {
                ourPath = "/baseDstu2/";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ourPath = "/baseDstu3/";
                break;
            }
            case 4: {
                ourPath = "/baseR4/";
                break;
            }
            default: {
                throw new ParseException(Msg.code((int)1531) + "FHIR version not supported by this command: " + theCtx.getVersion().getVersion());
            }
        }
        ourCtx = theCtx;
    }

    public static String getPath() {
        Validate.notNull((Object)ourPath, (String)"Context not set", (Object[])new Object[0]);
        return ourPath;
    }

    public static Long getReuseCachedSearchResultsForMillis() {
        return ourReuseSearchResultsMillis;
    }

    public static void setReuseCachedSearchResultsForMillis(Long reuseSearchResultsMillis) {
        ourReuseSearchResultsMillis = reuseSearchResultsMillis;
    }

    public static boolean isAllowExternalRefs() {
        return ourAllowExternalRefs;
    }

    public static void setAllowExternalRefs(boolean theAllowExternalRefs) {
        ourAllowExternalRefs = theAllowExternalRefs;
    }

    public static boolean isDisableReferentialIntegrity() {
        return ourDisableReferentialIntegrity;
    }

    public static void setDisableReferentialIntegrity(boolean theDisableReferentialIntegrity) {
        ourDisableReferentialIntegrity = theDisableReferentialIntegrity;
    }

    public static String getDatabaseUrl() {
        return ourDatabaseUrl;
    }

    public static void setDatabaseUrl(String theDatabaseUrl) {
        ourDatabaseUrl = theDatabaseUrl;
    }

    static {
        ourReuseSearchResultsMillis = DaoConfig.DEFAULT_REUSE_CACHED_SEARCH_RESULTS_FOR_MILLIS;
    }
}

