/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.demo;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.binary.provider.BinaryAccessProvider;
import ca.uhn.fhir.jpa.delete.ThreadSafeResourceDeleterSvc;
import ca.uhn.fhir.jpa.demo.ContextHolder;
import ca.uhn.fhir.jpa.demo.JpaServerDemo;
import ca.uhn.fhir.jpa.interceptor.CascadingDeleteInterceptor;
import ca.uhn.fhir.jpa.provider.JpaCapabilityStatementProvider;
import ca.uhn.fhir.jpa.provider.JpaConformanceProviderDstu2;
import ca.uhn.fhir.jpa.provider.JpaSystemProvider;
import ca.uhn.fhir.jpa.provider.TerminologyUploaderProvider;
import ca.uhn.fhir.jpa.provider.dstu3.JpaConformanceProviderDstu3;
import ca.uhn.fhir.narrative.DefaultThymeleafNarrativeGenerator;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.FifoMemoryPagingProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.interceptor.CorsInterceptor;
import ca.uhn.fhir.rest.server.interceptor.ResponseHighlighterInterceptor;
import ca.uhn.fhir.rest.server.provider.ResourceProviderFactory;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class JpaServerDemo
extends RestfulServer {
    private static final long serialVersionUID = 1L;
    private WebApplicationContext myAppCtx;

    protected void initialize() throws ServletException {
        JpaConformanceProviderDstu2 confProvider;
        IFhirSystemDao systemDao;
        String resourceProviderBeanName;
        super.initialize();
        this.setFhirContext(ContextHolder.getCtx());
        this.myAppCtx = ContextLoaderListener.getCurrentWebApplicationContext();
        FhirVersionEnum fhirVersion = ContextHolder.getCtx().getVersion().getVersion();
        switch (1.$SwitchMap$ca$uhn$fhir$context$FhirVersionEnum[fhirVersion.ordinal()]) {
            case 1: {
                resourceProviderBeanName = "myResourceProvidersDstu2";
                break;
            }
            case 2: {
                resourceProviderBeanName = "myResourceProvidersDstu3";
                break;
            }
            case 3: {
                resourceProviderBeanName = "myResourceProvidersR4";
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)1532));
            }
        }
        ResourceProviderFactory beans = (ResourceProviderFactory)this.myAppCtx.getBean(resourceProviderBeanName, ResourceProviderFactory.class);
        this.registerProviders((Collection)beans.createProviders());
        ArrayList<Object> systemProvider = new ArrayList<Object>();
        if (fhirVersion != FhirVersionEnum.DSTU2) {
            if (fhirVersion == FhirVersionEnum.DSTU3) {
                systemProvider.add(this.myAppCtx.getBean(TerminologyUploaderProvider.class));
            } else if (fhirVersion == FhirVersionEnum.R4) {
                systemProvider.add(this.myAppCtx.getBean(TerminologyUploaderProvider.class));
                systemProvider.add(this.myAppCtx.getBean("myGraphQLProvider"));
            } else {
                throw new IllegalStateException(Msg.code((int)1533));
            }
        }
        systemProvider.add(this.myAppCtx.getBean(JpaSystemProvider.class));
        this.registerProviders(systemProvider);
        if (fhirVersion == FhirVersionEnum.DSTU2) {
            systemDao = (IFhirSystemDao)this.myAppCtx.getBean("mySystemDaoDstu2", IFhirSystemDao.class);
            confProvider = new JpaConformanceProviderDstu2((RestfulServer)this, systemDao, (DaoConfig)this.myAppCtx.getBean(DaoConfig.class));
            confProvider.setImplementationDescription("Example Server");
            this.setServerConformanceProvider((Object)confProvider);
        } else if (fhirVersion == FhirVersionEnum.DSTU3) {
            systemDao = (IFhirSystemDao)this.myAppCtx.getBean("mySystemDaoDstu3", IFhirSystemDao.class);
            confProvider = new JpaConformanceProviderDstu3((RestfulServer)this, systemDao, (DaoConfig)this.myAppCtx.getBean(DaoConfig.class), (ISearchParamRegistry)this.myAppCtx.getBean(ISearchParamRegistry.class));
            confProvider.setImplementationDescription("Example Server");
            this.setServerConformanceProvider((Object)confProvider);
        } else if (fhirVersion == FhirVersionEnum.R4) {
            systemDao = (IFhirSystemDao)this.myAppCtx.getBean("mySystemDaoR4", IFhirSystemDao.class);
            IValidationSupport validationSupport = (IValidationSupport)this.myAppCtx.getBean(IValidationSupport.class);
            JpaCapabilityStatementProvider confProvider2 = new JpaCapabilityStatementProvider((RestfulServer)this, systemDao, (DaoConfig)this.myAppCtx.getBean(DaoConfig.class), (ISearchParamRegistry)this.myAppCtx.getBean(ISearchParamRegistry.class), validationSupport);
            confProvider2.setImplementationDescription("Example Server");
            this.setServerConformanceProvider((Object)confProvider2);
        } else {
            throw new IllegalStateException(Msg.code((int)1534));
        }
        this.setETagSupport(ETagSupportEnum.ENABLED);
        FhirContext ctx = this.getFhirContext();
        ctx.setNarrativeGenerator((INarrativeGenerator)new DefaultThymeleafNarrativeGenerator());
        this.setDefaultPrettyPrint(true);
        this.setDefaultResponseEncoding(EncodingEnum.JSON);
        this.setPagingProvider((IPagingProvider)new FifoMemoryPagingProvider(10));
        CorsInterceptor corsInterceptor = new CorsInterceptor();
        this.registerInterceptor((Object)corsInterceptor);
        DaoConfig daoConfig = (DaoConfig)this.myAppCtx.getBean(DaoConfig.class);
        daoConfig.setAllowExternalReferences(ContextHolder.isAllowExternalRefs());
        daoConfig.setEnforceReferentialIntegrityOnDelete(!ContextHolder.isDisableReferentialIntegrity());
        daoConfig.setEnforceReferentialIntegrityOnWrite(!ContextHolder.isDisableReferentialIntegrity());
        daoConfig.setReuseCachedSearchResultsForMillis(ContextHolder.getReuseCachedSearchResultsForMillis());
        DaoRegistry daoRegistry = (DaoRegistry)this.myAppCtx.getBean(DaoRegistry.class);
        IInterceptorBroadcaster interceptorBroadcaster = (IInterceptorBroadcaster)this.myAppCtx.getBean(IInterceptorBroadcaster.class);
        ThreadSafeResourceDeleterSvc threadSafeResourceDeleterSvc = (ThreadSafeResourceDeleterSvc)this.myAppCtx.getBean(ThreadSafeResourceDeleterSvc.class);
        CascadingDeleteInterceptor cascadingDeleteInterceptor = new CascadingDeleteInterceptor(ctx, daoRegistry, interceptorBroadcaster, threadSafeResourceDeleterSvc);
        this.getInterceptorService().registerInterceptor((Object)cascadingDeleteInterceptor);
        this.getInterceptorService().registerInterceptor((Object)new ResponseHighlighterInterceptor());
        this.registerProvider(this.myAppCtx.getBean(BinaryAccessProvider.class));
    }
}

