/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.okhttp.client;

import ca.uhn.fhir.okhttp.client.OkHttpRestfulResponse;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.BaseHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.util.StopWatch;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpRestfulRequest
extends BaseHttpRequest
implements IHttpRequest {
    private final Request.Builder myRequestBuilder;
    private Call.Factory myClient;
    private String myUrl;
    private RequestTypeEnum myRequestTypeEnum;
    private RequestBody myRequestBody;

    public OkHttpRestfulRequest(Call.Factory theClient, String theUrl, RequestTypeEnum theRequestTypeEnum, RequestBody theRequestBody) {
        this.myClient = theClient;
        this.myUrl = theUrl;
        this.myRequestTypeEnum = theRequestTypeEnum;
        this.myRequestBody = theRequestBody;
        this.myRequestBuilder = new Request.Builder().url(theUrl);
    }

    public Request.Builder getRequest() {
        return this.myRequestBuilder;
    }

    public void addHeader(String theName, String theValue) {
        this.myRequestBuilder.addHeader(theName, theValue);
    }

    public IHttpResponse execute() throws IOException {
        StopWatch responseStopWatch = new StopWatch();
        this.myRequestBuilder.method(this.getHttpVerbName(), this.myRequestBody);
        Call call = this.myClient.newCall(this.myRequestBuilder.build());
        return new OkHttpRestfulResponse(call.execute(), responseStopWatch);
    }

    public Map<String, List<String>> getAllHeaders() {
        return Collections.unmodifiableMap(this.myRequestBuilder.build().headers().toMultimap());
    }

    public String getRequestBodyFromStream() {
        return null;
    }

    public String getUri() {
        return this.myUrl;
    }

    public void setUri(String theUrl) {
        this.myUrl = theUrl;
    }

    public String getHttpVerbName() {
        return this.myRequestTypeEnum.name();
    }

    public void removeHeaders(String theHeaderName) {
        this.myRequestBuilder.removeHeader(theHeaderName);
    }

    public String toString() {
        return this.getHttpVerbName() + " " + this.getUri();
    }
}

