/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.okhttp.client;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.impl.BaseHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.StopWatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class OkHttpRestfulResponse
extends BaseHttpResponse
implements IHttpResponse {
    private boolean myEntityBuffered = false;
    private byte[] myEntityBytes;
    private Response myResponse;

    public OkHttpRestfulResponse(Response theResponse, StopWatch theResponseStopWatch) {
        super(theResponseStopWatch);
        this.myResponse = theResponse;
    }

    public void bufferEntity() throws IOException {
        block9: {
            if (this.myEntityBuffered) {
                return;
            }
            try (InputStream responseEntity = this.readEntity();){
                if (responseEntity == null) break block9;
                this.myEntityBuffered = true;
                try {
                    this.myEntityBytes = IOUtils.toByteArray((InputStream)responseEntity);
                }
                catch (IllegalStateException e) {
                    throw new InternalErrorException(Msg.code((int)465) + e);
                }
            }
        }
    }

    public void close() {
        this.myResponse.close();
    }

    public Reader createReader() throws IOException {
        if (!this.myEntityBuffered && this.myResponse.body() == null) {
            return new StringReader("");
        }
        return new InputStreamReader(this.readEntity());
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.myResponse.headers().toMultimap();
    }

    public List<String> getHeaders(String theName) {
        return this.myResponse.headers(theName);
    }

    public String getMimeType() {
        String contentType = this.myResponse.header("Content-Type");
        MediaType mediaType = null;
        if (contentType == null) {
            if (this.myResponse.body() != null) {
                mediaType = this.myResponse.body().contentType();
            }
        } else {
            mediaType = MediaType.parse((String)contentType);
        }
        if (mediaType == null) {
            return null;
        }
        return this.typeAndSubtypeOnly(mediaType).toString();
    }

    public Object getResponse() {
        return this.myResponse;
    }

    public int getStatus() {
        return this.myResponse.code();
    }

    public String getStatusInfo() {
        return this.myResponse.message();
    }

    public InputStream readEntity() throws IOException {
        if (this.myEntityBuffered) {
            return new ByteArrayInputStream(this.myEntityBytes);
        }
        if (this.myResponse.body() != null) {
            return this.myResponse.body().byteStream();
        }
        return null;
    }

    private MediaType typeAndSubtypeOnly(MediaType input) {
        return MediaType.parse((String)(input.type() + "/" + input.subtype()));
    }
}

