/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.rest.client.apache.ApacheHttpResponse;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.util.StopWatch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;

public class ApacheHttpRequest
implements IHttpRequest {
    private HttpClient myClient;
    private HttpRequestBase myRequest;

    public ApacheHttpRequest(HttpClient theClient, HttpRequestBase theApacheRequest) {
        this.myClient = theClient;
        this.myRequest = theApacheRequest;
    }

    public void addHeader(String theName, String theValue) {
        this.myRequest.addHeader(theName, theValue);
    }

    public IHttpResponse execute() throws IOException {
        StopWatch responseStopWatch = new StopWatch();
        HttpResponse httpResponse = this.myClient.execute((HttpUriRequest)this.myRequest);
        return new ApacheHttpResponse(httpResponse, responseStopWatch);
    }

    public Map<String, List<String>> getAllHeaders() {
        HashMap result = new HashMap();
        for (Header header : this.myRequest.getAllHeaders()) {
            if (!result.containsKey(header.getName())) {
                result.put(header.getName(), new LinkedList());
            }
            ((List)result.get(header.getName())).add(header.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public HttpRequestBase getApacheRequest() {
        return this.myRequest;
    }

    public String getHttpVerbName() {
        return this.myRequest.getMethod();
    }

    public void removeHeaders(String theHeaderName) {
        Validate.notBlank((CharSequence)theHeaderName, (String)"theHeaderName must not be null or blank", (Object[])new Object[0]);
        this.myRequest.removeHeaders(theHeaderName);
    }

    public String getRequestBodyFromStream() throws IOException {
        HttpEntity entity;
        if (this.myRequest instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)this.myRequest).getEntity()).isRepeatable()) {
            Header contentTypeHeader = this.myRequest.getFirstHeader("Content-Type");
            Charset charset = contentTypeHeader == null ? null : ContentType.parse((String)contentTypeHeader.getValue()).getCharset();
            return IOUtils.toString((InputStream)entity.getContent(), (Charset)charset);
        }
        return null;
    }

    public String getUri() {
        return this.myRequest.getURI().toString();
    }

    public String toString() {
        return this.myRequest.toString();
    }
}

