/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdditionalRequestHeadersInterceptor
implements IClientInterceptor {
    private final Map<String, List<String>> additionalHttpHeaders = new HashMap<String, List<String>>();

    public AdditionalRequestHeadersInterceptor() {
        this(new HashMap<String, List<String>>());
    }

    public AdditionalRequestHeadersInterceptor(Map<String, List<String>> additionalHttpHeaders) {
        if (additionalHttpHeaders != null) {
            this.additionalHttpHeaders.putAll(additionalHttpHeaders);
        }
    }

    public void addHeaderValue(String headerName, String headerValue) {
        Objects.requireNonNull(headerName, "headerName cannot be null");
        Objects.requireNonNull(headerValue, "headerValue cannot be null");
        this.getHeaderValues(headerName).add(headerValue);
    }

    public void addAllHeaderValues(String headerName, List<String> headerValues) {
        Objects.requireNonNull(headerName, "headerName cannot be null");
        Objects.requireNonNull(headerValues, "headerValues cannot be null");
        this.getHeaderValues(headerName).addAll(headerValues);
    }

    private List<String> getHeaderValues(String headerName) {
        if (this.additionalHttpHeaders.get(headerName) == null) {
            this.additionalHttpHeaders.put(headerName, new ArrayList());
        }
        return this.additionalHttpHeaders.get(headerName);
    }

    public void interceptRequest(IHttpRequest theRequest) {
        for (Map.Entry<String, List<String>> header : this.additionalHttpHeaders.entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue == null) continue;
                theRequest.addHeader(header.getKey(), headerValue);
            }
        }
    }

    public void interceptResponse(IHttpResponse theResponse) throws IOException {
    }
}

