/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SearchStyleEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.SearchParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class SearchMethodBinding
extends BaseResourceReturningMethodBinding {
    private String myCompartmentName;
    private String myDescription;
    private Integer myIdParamIndex;
    private String myQueryName;

    public SearchMethodBinding(Class<? extends IBaseResource> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        Search search = theMethod.getAnnotation(Search.class);
        this.myQueryName = (String)StringUtils.defaultIfBlank((CharSequence)search.queryName(), null);
        this.myCompartmentName = (String)StringUtils.defaultIfBlank((CharSequence)search.compartmentName(), null);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        Description desc = theMethod.getAnnotation(Description.class);
        if (desc != null) {
            this.myDescription = StringUtils.isNotBlank((CharSequence)desc.formalDefinition()) ? (String)StringUtils.defaultIfBlank((CharSequence)desc.formalDefinition(), null) : (String)StringUtils.defaultIfBlank((CharSequence)desc.shortDefinition(), null);
        }
        List<IParameter> parameters = this.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            SearchParameter sp;
            IParameter next = parameters.get(i);
            if (!(next instanceof SearchParameter) || !(sp = (SearchParameter)next).getName().startsWith("_") || !ALLOWED_PARAMS.contains(sp.getName())) continue;
            String msg = this.getContext().getLocalizer().getMessage(this.getClass().getName() + ".invalidSpecialParamName", new Object[]{theMethod.getName(), theMethod.getDeclaringClass().getSimpleName(), sp.getName()});
            throw new ConfigurationException(msg);
        }
        if (StringUtils.isBlank((CharSequence)this.myCompartmentName) && this.myIdParamIndex != null) {
            String msg = theContext.getLocalizer().getMessage(this.getClass().getName() + ".idWithoutCompartment", new Object[]{theMethod.getName(), theMethod.getDeclaringClass()});
            throw new ConfigurationException(msg);
        }
    }

    public String getDescription() {
        return this.myDescription;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.SEARCHSET;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.SEARCH_TYPE;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        assert (this.myQueryName == null || (theArgs != null ? theArgs.length : 0) == this.getParameters().size()) : "Wrong number of arguments: " + (theArgs != null ? Integer.valueOf(theArgs.length) : "null");
        LinkedHashMap<String, List<String>> queryStringArgs = new LinkedHashMap<String, List<String>>();
        if (this.myQueryName != null) {
            queryStringArgs.put("_query", Collections.singletonList(this.myQueryName));
        }
        IIdType id = (IIdType)(this.myIdParamIndex != null ? theArgs[this.myIdParamIndex] : null);
        String resourceName = this.getResourceName();
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], queryStringArgs, null);
            }
        }
        BaseHttpClientInvocation retVal = SearchMethodBinding.createSearchInvocation(this.getContext(), resourceName, queryStringArgs, id, this.myCompartmentName, null);
        return retVal;
    }

    @Override
    protected boolean isAddContentLocationHeader() {
        return false;
    }

    public String toString() {
        return this.getMethod().toString();
    }

    public static BaseHttpClientInvocation createSearchInvocation(FhirContext theContext, String theSearchUrl, Map<String, List<String>> theParams) {
        return new HttpGetClientInvocation(theContext, theParams, theSearchUrl);
    }

    public static BaseHttpClientInvocation createSearchInvocation(FhirContext theContext, String theResourceName, Map<String, List<String>> theParameters, IIdType theId, String theCompartmentName, SearchStyleEnum theSearchStyle) {
        BaseHttpClientInvocation invocation;
        SearchStyleEnum searchStyle = theSearchStyle;
        if (searchStyle == null) {
            int length = 0;
            for (Map.Entry<String, List<String>> nextEntry : theParameters.entrySet()) {
                length += nextEntry.getKey().length();
                for (String next : nextEntry.getValue()) {
                    length += next.length();
                }
            }
            searchStyle = length < 5000 ? SearchStyleEnum.GET : SearchStyleEnum.POST;
        }
        boolean compartmentSearch = false;
        if (theCompartmentName != null) {
            if (theId == null || !theId.hasIdPart()) {
                String msg = theContext.getLocalizer().getMessage(SearchMethodBinding.class.getName() + ".idNullForCompartmentSearch", new Object[0]);
                throw new InvalidRequestException(msg);
            }
            compartmentSearch = true;
        }
        switch (searchStyle) {
            default: {
                if (compartmentSearch) {
                    invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName, theId.getIdPart(), theCompartmentName);
                    break;
                }
                invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName);
                break;
            }
            case GET_WITH_SEARCH: {
                if (compartmentSearch) {
                    invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName, theId.getIdPart(), theCompartmentName, "_search");
                    break;
                }
                invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName, "_search");
                break;
            }
            case POST: {
                invocation = compartmentSearch ? new HttpPostClientInvocation(theContext, theParameters, theResourceName, theId.getIdPart(), theCompartmentName, "_search") : new HttpPostClientInvocation(theContext, theParameters, theResourceName, "_search");
            }
        }
        return invocation;
    }
}

