/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.apache.ApacheHttpRequest;
import ca.uhn.fhir.rest.client.apache.BaseHttpClient;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;

public class ApacheHttpClient
extends BaseHttpClient
implements IHttpClient {
    private final HttpClient myClient;

    public ApacheHttpClient(HttpClient theClient, StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        super(theUrl, theIfNoneExistParams, theIfNoneExistString, theRequestType, theHeaders);
        this.myClient = theClient;
    }

    private HttpRequestBase constructRequestBase(HttpEntity theEntity) {
        String url = this.myUrl.toString();
        switch (this.myRequestType) {
            case DELETE: {
                return new HttpDelete(url);
            }
            case PATCH: {
                HttpPatch httpPatch = new HttpPatch(url);
                httpPatch.setEntity(theEntity);
                return httpPatch;
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case POST: {
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity(theEntity);
                return httpPost;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(url);
                httpPut.setEntity(theEntity);
                return httpPut;
            }
        }
        return new HttpGet(url);
    }

    private UrlEncodedFormEntity createFormEntity(List<NameValuePair> parameters) {
        try {
            return new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(Msg.code((int)1479) + "Server does not support UTF-8 (should not happen)", (Throwable)e);
        }
    }

    @Override
    protected IHttpRequest createHttpRequest() {
        return this.createHttpRequest((HttpEntity)null);
    }

    @Override
    protected IHttpRequest createHttpRequest(byte[] content) {
        ByteArrayEntity entity = new ByteArrayEntity(content);
        return this.createHttpRequest((HttpEntity)entity);
    }

    private ApacheHttpRequest createHttpRequest(HttpEntity theEntity) {
        HttpRequestBase request = this.constructRequestBase(theEntity);
        return new ApacheHttpRequest(this.myClient, request);
    }

    @Override
    protected IHttpRequest createHttpRequest(Map<String, List<String>> theParams) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        for (Map.Entry<String, List<String>> nextParam : theParams.entrySet()) {
            List<String> value = nextParam.getValue();
            for (String s : value) {
                parameters.add((NameValuePair)new BasicNameValuePair(nextParam.getKey(), s));
            }
        }
        UrlEncodedFormEntity entity = this.createFormEntity(parameters);
        return this.createHttpRequest((HttpEntity)entity);
    }

    @Override
    protected IHttpRequest createHttpRequest(String theContents) {
        ByteArrayEntity entity = new ByteArrayEntity(theContents.getBytes(Constants.CHARSET_UTF8));
        return this.createHttpRequest((HttpEntity)entity);
    }
}

