/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseMethodBinding;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseOutcomeReturningMethodBinding
extends BaseMethodBinding<MethodOutcome> {
    static final Logger ourLog = LoggerFactory.getLogger(BaseOutcomeReturningMethodBinding.class);
    private boolean myReturnVoid;

    public BaseOutcomeReturningMethodBinding(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theProvider);
        if (!theMethod.getReturnType().equals(MethodOutcome.class)) {
            if (!this.allowVoidReturnType()) {
                throw new ConfigurationException(Msg.code((int)1413) + "Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " is a @" + theMethodAnnotation.getSimpleName() + " method but it does not return " + String.valueOf(MethodOutcome.class));
            }
            if (theMethod.getReturnType() == Void.TYPE) {
                this.myReturnVoid = true;
            }
        }
    }

    protected boolean allowVoidReturnType() {
        return false;
    }

    protected abstract BaseHttpClientInvocation createClientInvocation(Object[] var1, IBaseResource var2);

    protected abstract String getMatchingOperation();

    @Override
    public MethodOutcome invokeClient(String theResponseMimeType, InputStream theResponseInputStream, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
        if (theResponseStatusCode >= 200 && theResponseStatusCode < 300) {
            if (this.myReturnVoid) {
                return null;
            }
            MethodOutcome retVal = MethodUtil.process2xxResponse(this.getContext(), theResponseStatusCode, theResponseMimeType, theResponseInputStream, theHeaders);
            return retVal;
        }
        throw this.processNon2xxResponseAndReturnExceptionToThrow(theResponseStatusCode, theResponseMimeType, theResponseInputStream);
    }

    public boolean isReturnVoid() {
        return this.myReturnVoid;
    }

    protected abstract Set<RequestTypeEnum> provideAllowableRequestTypes();

    protected static void parseContentLocation(FhirContext theContext, MethodOutcome theOutcomeToPopulate, String theLocationHeader) {
        if (StringUtils.isBlank((CharSequence)theLocationHeader)) {
            return;
        }
        IIdType id = theContext.getVersion().newIdType();
        id.setValue(theLocationHeader);
        theOutcomeToPopulate.setId(id);
    }
}

