/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hapi.converters.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.converter.NullVersionConverterAdvisor10_30;
import org.hl7.fhir.converter.NullVersionConverterAdvisor10_40;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_30;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_30;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;

@Interceptor(order=300)
public class VersionedApiConverterInterceptor
extends InterceptorAdapter {
    private final FhirContext myCtxDstu2;
    private final FhirContext myCtxDstu2Hl7Org;
    private final NullVersionConverterAdvisor10_40 advisor40 = new NullVersionConverterAdvisor10_40();
    private final NullVersionConverterAdvisor10_30 advisor30 = new NullVersionConverterAdvisor10_30();

    public VersionedApiConverterInterceptor() {
        this.myCtxDstu2 = FhirContext.forDstu2();
        this.myCtxDstu2Hl7Org = FhirContext.forDstu2Hl7Org();
    }

    public boolean outgoingResponse(RequestDetails theRequestDetails, ResponseDetails theResponseDetails, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        IBaseResource responseResource = theResponseDetails.getResponseResource();
        if (responseResource == null) {
            return true;
        }
        String[] formatParams = (String[])theRequestDetails.getParameters().get("_format");
        String accept = null;
        if (formatParams != null && formatParams.length > 0) {
            accept = formatParams[0];
        }
        if (StringUtils.isBlank(accept)) {
            accept = StringUtils.defaultString((String)theServletRequest.getHeader("Accept"));
        }
        StringTokenizer tok = new StringTokenizer(accept, ";");
        String wantVersionString = null;
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken().trim();
            if (!next.startsWith("fhirVersion=")) continue;
            wantVersionString = next.substring("fhirVersion=".length()).trim();
            break;
        }
        FhirVersionEnum wantVersion = null;
        if (StringUtils.isNotBlank(wantVersionString)) {
            wantVersion = FhirVersionEnum.forVersionString(wantVersionString);
        }
        FhirVersionEnum haveVersion = responseResource.getStructureFhirVersionEnum();
        org.hl7.fhir.r4.model.Resource converted = null;
        try {
            if (wantVersion == FhirVersionEnum.R4 && haveVersion == FhirVersionEnum.DSTU3) {
                converted = VersionConvertorFactory_30_40.convertResource((Resource)this.toDstu3(responseResource));
            } else if (wantVersion == FhirVersionEnum.DSTU3 && haveVersion == FhirVersionEnum.R4) {
                converted = VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)this.toR4(responseResource));
            } else if (wantVersion == FhirVersionEnum.DSTU2 && haveVersion == FhirVersionEnum.R4) {
                converted = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.r4.model.Resource)this.toR4(responseResource), (BaseAdvisor_10_40)this.advisor40);
            } else if (wantVersion == FhirVersionEnum.R4 && haveVersion == FhirVersionEnum.DSTU2) {
                converted = VersionConvertorFactory_10_40.convertResource((org.hl7.fhir.dstu2.model.Resource)this.toDstu2(responseResource), (BaseAdvisor_10_40)this.advisor40);
            } else if (wantVersion == FhirVersionEnum.DSTU2 && haveVersion == FhirVersionEnum.DSTU3) {
                converted = VersionConvertorFactory_10_30.convertResource((Resource)this.toDstu3(responseResource), (BaseAdvisor_10_30)this.advisor30);
            } else if (wantVersion == FhirVersionEnum.DSTU3 && haveVersion == FhirVersionEnum.DSTU2) {
                converted = VersionConvertorFactory_10_30.convertResource((org.hl7.fhir.dstu2.model.Resource)this.toDstu2(responseResource), (BaseAdvisor_10_30)this.advisor30);
            }
        }
        catch (FHIRException e) {
            throw new InternalErrorException(Msg.code((int)73) + e);
        }
        if (converted != null) {
            theResponseDetails.setResponseResource((IBaseResource)converted);
        }
        return true;
    }

    private org.hl7.fhir.dstu2.model.Resource toDstu2(IBaseResource theResponseResource) {
        if (theResponseResource instanceof IResource) {
            return (org.hl7.fhir.dstu2.model.Resource)this.myCtxDstu2Hl7Org.newJsonParser().parseResource(this.myCtxDstu2.newJsonParser().encodeResourceToString(theResponseResource));
        }
        return (org.hl7.fhir.dstu2.model.Resource)theResponseResource;
    }

    private Resource toDstu3(IBaseResource theResponseResource) {
        return (Resource)theResponseResource;
    }

    private org.hl7.fhir.r4.model.Resource toR4(IBaseResource theResponseResource) {
        return (org.hl7.fhir.r4.model.Resource)theResponseResource;
    }
}

