/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jaxrs.client.JaxRsHttpRequest;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.HttpClientUtil;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public class JaxRsHttpClient
implements IHttpClient {
    private Client myClient;
    private List<Header> myHeaders;
    private StringBuilder myUrl;
    private Map<String, List<String>> myIfNoneExistParams;
    private String myIfNoneExistString;
    private RequestTypeEnum myRequestType;

    public JaxRsHttpClient(Client theClient, StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        this.myClient = theClient;
        this.myUrl = theUrl;
        this.myIfNoneExistParams = theIfNoneExistParams;
        this.myIfNoneExistString = theIfNoneExistString;
        this.myRequestType = theRequestType;
        this.myHeaders = theHeaders;
    }

    public IHttpRequest createByteRequest(FhirContext theContext, String theContents, String theContentType, EncodingEnum theEncoding) {
        Entity entity = Entity.entity((Object)theContents, (String)(theContentType + "; charset=UTF-8"));
        JaxRsHttpRequest retVal = this.createHttpRequest(entity);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        retVal.addHeader("Content-Type", theContentType + "; charset=UTF-8");
        return retVal;
    }

    public IHttpRequest createParamRequest(FhirContext theContext, Map<String, List<String>> theParams, EncodingEnum theEncoding) {
        MultivaluedHashMap map = new MultivaluedHashMap();
        for (Map.Entry<String, List<String>> nextParam : theParams.entrySet()) {
            List<String> value = nextParam.getValue();
            for (String s : value) {
                map.add((Object)nextParam.getKey(), (Object)s);
            }
        }
        Entity entity = Entity.form((MultivaluedMap)map);
        JaxRsHttpRequest retVal = this.createHttpRequest(entity);
        this.addHeadersToRequest(retVal, theEncoding, theContext);
        return retVal;
    }

    public IHttpRequest createBinaryRequest(FhirContext theContext, IBaseBinary theBinary) {
        Entity entity = Entity.entity((Object)theBinary.getContentAsBase64(), (String)theBinary.getContentType());
        JaxRsHttpRequest retVal = this.createHttpRequest(entity);
        this.addHeadersToRequest(retVal, null, theContext);
        return retVal;
    }

    public IHttpRequest createGetRequest(FhirContext theContext, EncodingEnum theEncoding) {
        JaxRsHttpRequest result = this.createHttpRequest(null);
        this.addHeadersToRequest(result, theEncoding, theContext);
        return result;
    }

    public void addHeadersToRequest(JaxRsHttpRequest theHttpRequest, EncodingEnum theEncoding, FhirContext theContext) {
        if (this.myHeaders != null) {
            for (Header next : this.myHeaders) {
                theHttpRequest.addHeader(next.getName(), next.getValue());
            }
        }
        theHttpRequest.addHeader("User-Agent", HttpClientUtil.createUserAgentString((FhirContext)theContext, (String)"jax-rs"));
        theHttpRequest.addHeader("Accept-Charset", "utf-8");
        Invocation.Builder request = theHttpRequest.getRequest();
        request.acceptEncoding(new String[]{"gzip"});
        MethodUtil.addAcceptHeaderToRequest((EncodingEnum)theEncoding, (IHttpRequest)theHttpRequest, (FhirContext)theContext);
    }

    private JaxRsHttpRequest createHttpRequest(Entity<?> entity) {
        Invocation.Builder request = this.myClient.target(this.myUrl.toString()).request();
        JaxRsHttpRequest result = new JaxRsHttpRequest(request, this.myRequestType, entity);
        this.addHeaderIfNoneExist(result);
        return result;
    }

    private void addHeaderIfNoneExist(IHttpRequest result) {
        StringBuilder b;
        if (this.myIfNoneExistParams != null) {
            BaseHttpClientInvocation.appendExtraParamsWithQuestionMark(this.myIfNoneExistParams, (StringBuilder)b, ((b = this.newHeaderBuilder(this.myUrl)).indexOf("?") == -1 ? 1 : 0) != 0);
            result.addHeader("If-None-Exist", b.toString());
        }
        if (this.myIfNoneExistString != null) {
            b.append((b = this.newHeaderBuilder(this.myUrl)).indexOf("?") == -1 ? (char)'?' : '&');
            b.append(this.myIfNoneExistString.substring(this.myIfNoneExistString.indexOf(63) + 1));
            result.addHeader("If-None-Exist", b.toString());
        }
    }

    private StringBuilder newHeaderBuilder(StringBuilder theUrlBase) {
        StringBuilder b = new StringBuilder();
        b.append((CharSequence)theUrlBase);
        if (theUrlBase.length() > 0 && theUrlBase.charAt(theUrlBase.length() - 1) == '/') {
            b.deleteCharAt(b.length() - 1);
        }
        return b;
    }
}

