/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jaxrs.client.JaxRsHttpClient;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

public class JaxRsRestfulClientFactory
extends RestfulClientFactory {
    private Client myNativeClient;
    private List<Class<?>> registeredComponents;

    public JaxRsRestfulClientFactory() {
    }

    public JaxRsRestfulClientFactory(FhirContext theFhirContext) {
        super(theFhirContext);
    }

    public synchronized Client getNativeClientClient() {
        if (this.myNativeClient == null) {
            ClientBuilder builder = ClientBuilder.newBuilder();
            this.myNativeClient = builder.build();
        }
        if (this.registeredComponents != null && !this.registeredComponents.isEmpty()) {
            for (Class<?> c : this.registeredComponents) {
                this.myNativeClient = (Client)this.myNativeClient.register(c);
            }
        }
        return this.myNativeClient;
    }

    public synchronized IHttpClient getHttpClient(StringBuilder url, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        Client client = this.getNativeClientClient();
        return new JaxRsHttpClient(client, url, theIfNoneExistParams, theIfNoneExistString, theRequestType, theHeaders);
    }

    public void setProxy(String theHost, Integer thePort) {
        throw new UnsupportedOperationException("Proxies are not supported yet in JAX-RS client");
    }

    public synchronized void setHttpClient(Object theHttpClient) {
        this.myNativeClient = (Client)theHttpClient;
    }

    public void register(List<Class<?>> components) {
        this.registeredComponents = components;
    }

    protected synchronized JaxRsHttpClient getHttpClient(String theServerBase) {
        return new JaxRsHttpClient(this.getNativeClientClient(), new StringBuilder(theServerBase), null, null, null, null);
    }

    protected void resetHttpClient() {
        if (this.myNativeClient != null) {
            this.myNativeClient.close();
        }
        this.myNativeClient = null;
    }
}

