/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.HardcodedServerAddressStrategy;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2016may.hapi.rest.server.ServerConformanceProvider;
import org.hl7.fhir.dstu3.hapi.rest.server.ServerCapabilityStatementProvider;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json", "application/xml"})
public abstract class AbstractJaxRsConformanceProvider
extends AbstractJaxRsProvider
implements IResourceProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(AbstractJaxRsConformanceProvider.class);
    private ResourceBinding myServerBinding = new ResourceBinding();
    private ConcurrentHashMap<String, ResourceBinding> myResourceNameToBinding = new ConcurrentHashMap();
    private RestfulServerConfiguration serverConfiguration = new RestfulServerConfiguration();
    private CapabilityStatement myR4CapabilityStatement;
    private org.hl7.fhir.dstu3.model.CapabilityStatement myDstu3CapabilityStatement;
    private org.hl7.fhir.dstu2016may.model.Conformance myDstu2_1Conformance;
    private Conformance myDstu2Hl7OrgConformance;
    private ca.uhn.fhir.model.dstu2.resource.Conformance myDstu2Conformance;
    private boolean myInitialized;

    protected AbstractJaxRsConformanceProvider(String implementationDescription, String serverName, String serverVersion) {
        this.serverConfiguration.setFhirContext(this.getFhirContext());
        this.serverConfiguration.setImplementationDescription((String)StringUtils.defaultIfEmpty((CharSequence)implementationDescription, (CharSequence)""));
        this.serverConfiguration.setServerName((String)StringUtils.defaultIfEmpty((CharSequence)serverName, (CharSequence)""));
        this.serverConfiguration.setServerVersion((String)StringUtils.defaultIfEmpty((CharSequence)serverVersion, (CharSequence)""));
    }

    protected AbstractJaxRsConformanceProvider(FhirContext ctx, String implementationDescription, String serverName, String serverVersion) {
        super(ctx);
        this.serverConfiguration.setFhirContext(ctx);
        this.serverConfiguration.setImplementationDescription((String)StringUtils.defaultIfEmpty((CharSequence)implementationDescription, (CharSequence)""));
        this.serverConfiguration.setServerName((String)StringUtils.defaultIfEmpty((CharSequence)serverName, (CharSequence)""));
        this.serverConfiguration.setServerVersion((String)StringUtils.defaultIfEmpty((CharSequence)serverVersion, (CharSequence)""));
    }

    @PostConstruct
    protected synchronized void setUpPostConstruct() {
        if (this.myInitialized) {
            return;
        }
        ConcurrentHashMap<Class<? extends IResourceProvider>, IResourceProvider> providers = this.getProviders();
        for (Map.Entry<Class<? extends IResourceProvider>, IResourceProvider> entry : providers.entrySet()) {
            this.addProvider(entry.getValue(), entry.getKey());
        }
        ArrayList serverBindings = new ArrayList();
        for (ResourceBinding baseMethodBinding : this.myResourceNameToBinding.values()) {
            serverBindings.addAll(baseMethodBinding.getMethodBindings());
        }
        this.serverConfiguration.setServerBindings(serverBindings);
        this.serverConfiguration.setResourceBindings(new LinkedList<ResourceBinding>(this.myResourceNameToBinding.values()));
        this.serverConfiguration.computeSharedSupertypeForResourcePerName(providers.values());
        HardcodedServerAddressStrategy hardcodedServerAddressStrategy = new HardcodedServerAddressStrategy();
        hardcodedServerAddressStrategy.setValue(this.getBaseForServer());
        this.serverConfiguration.setServerAddressStrategy((IServerAddressStrategy)hardcodedServerAddressStrategy);
        FhirVersionEnum fhirContextVersion = super.getFhirContext().getVersion().getVersion();
        switch (fhirContextVersion) {
            case R4: {
                ca.uhn.fhir.rest.server.provider.ServerCapabilityStatementProvider r4ServerCapabilityStatementProvider = new ca.uhn.fhir.rest.server.provider.ServerCapabilityStatementProvider(this.getFhirContext(), this.serverConfiguration);
                this.myR4CapabilityStatement = (CapabilityStatement)r4ServerCapabilityStatementProvider.getServerConformance(null, null);
                break;
            }
            case DSTU3: {
                ServerCapabilityStatementProvider dstu3ServerCapabilityStatementProvider = new ServerCapabilityStatementProvider(this.serverConfiguration);
                this.myDstu3CapabilityStatement = dstu3ServerCapabilityStatementProvider.getServerConformance(null, null);
                break;
            }
            case DSTU2_1: {
                ServerConformanceProvider dstu2_1ServerConformanceProvider = new ServerConformanceProvider(this.serverConfiguration);
                this.myDstu2_1Conformance = dstu2_1ServerConformanceProvider.getServerConformance(null, null);
                break;
            }
            case DSTU2_HL7ORG: {
                org.hl7.fhir.dstu2.hapi.rest.server.ServerConformanceProvider dstu2Hl7OrgServerConformanceProvider = new org.hl7.fhir.dstu2.hapi.rest.server.ServerConformanceProvider(this.serverConfiguration);
                this.myDstu2Hl7OrgConformance = dstu2Hl7OrgServerConformanceProvider.getServerConformance(null, null);
                break;
            }
            case DSTU2: {
                ca.uhn.fhir.rest.server.provider.dstu2.ServerConformanceProvider dstu2ServerConformanceProvider = new ca.uhn.fhir.rest.server.provider.dstu2.ServerConformanceProvider(this.serverConfiguration);
                this.myDstu2Conformance = dstu2ServerConformanceProvider.getServerConformance(null, null);
                break;
            }
            default: {
                throw new ConfigurationException("Unsupported Fhir version: " + fhirContextVersion);
            }
        }
        this.myInitialized = true;
    }

    protected abstract ConcurrentHashMap<Class<? extends IResourceProvider>, IResourceProvider> getProviders();

    @OPTIONS
    @Path(value="/metadata")
    public Response conformanceUsingOptions() throws IOException {
        return this.conformance();
    }

    @GET
    @Path(value="/metadata")
    public Response conformance() throws IOException {
        CapabilityStatement conformance;
        this.setUpPostConstruct();
        JaxRsRequest.Builder request = this.getRequest(RequestTypeEnum.OPTIONS, RestOperationTypeEnum.METADATA);
        IRestfulResponse response = request.build().getResponse();
        response.addHeader("Access-Control-Allow-Origin", "*");
        FhirVersionEnum fhirContextVersion = super.getFhirContext().getVersion().getVersion();
        switch (fhirContextVersion) {
            case R4: {
                conformance = this.myR4CapabilityStatement;
                break;
            }
            case DSTU3: {
                conformance = this.myDstu3CapabilityStatement;
                break;
            }
            case DSTU2_1: {
                conformance = this.myDstu2_1Conformance;
                break;
            }
            case DSTU2_HL7ORG: {
                conformance = this.myDstu2Hl7OrgConformance;
                break;
            }
            case DSTU2: {
                conformance = this.myDstu2Conformance;
                break;
            }
            default: {
                throw new ConfigurationException("Unsupported Fhir version: " + fhirContextVersion);
            }
        }
        if (conformance != null) {
            Set summaryMode = Collections.emptySet();
            return (Response)response.streamResponseAsResource((IBaseResource)conformance, false, summaryMode, 200, null, true, false);
        }
        return (Response)response.returnResponse(null, 500, true, null, this.getResourceType().getSimpleName());
    }

    public int addProvider(IResourceProvider theProvider, Class<? extends IResourceProvider> theProviderInterface) throws ConfigurationException {
        int count = 0;
        for (Method m : ReflectionUtil.getDeclaredMethods(theProviderInterface)) {
            ResourceBinding resourceBinding;
            BaseMethodBinding foundMethodBinding = BaseMethodBinding.bindMethod((Method)m, (FhirContext)this.getFhirContext(), (Object)theProvider);
            if (foundMethodBinding == null) continue;
            ++count;
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is not public, FHIR RESTful methods must be public");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is static, FHIR RESTful methods must not be static");
            }
            ourLog.debug("Scanning public method: {}#{}", theProvider.getClass(), (Object)m.getName());
            String resourceName = foundMethodBinding.getResourceName();
            if (resourceName == null) {
                resourceBinding = this.myServerBinding;
            } else {
                RuntimeResourceDefinition definition = this.getFhirContext().getResourceDefinition(resourceName);
                if (this.myResourceNameToBinding.containsKey(definition.getName())) {
                    resourceBinding = this.myResourceNameToBinding.get(definition.getName());
                } else {
                    resourceBinding = new ResourceBinding();
                    resourceBinding.setResourceName(resourceName);
                    this.myResourceNameToBinding.put(resourceName, resourceBinding);
                }
            }
            List allowableParams = foundMethodBinding.getAllowableParamAnnotations();
            if (allowableParams != null) {
                Annotation[][] annotationArray = m.getParameterAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation[] nextParamAnnotations;
                    for (Annotation annotation : nextParamAnnotations = annotationArray[i]) {
                        Package pack = annotation.annotationType().getPackage();
                        if (!pack.equals(IdParam.class.getPackage()) || allowableParams.contains(annotation.annotationType())) continue;
                        throw new ConfigurationException("Method[" + m.toString() + "] is not allowed to have a parameter annotated with " + annotation);
                    }
                }
            }
            resourceBinding.addMethod(foundMethodBinding);
            ourLog.debug(" * Method: {}#{} is a handler", theProvider.getClass(), (Object)m.getName());
        }
        return count;
    }

    public Class<IBaseResource> getResourceType() {
        FhirVersionEnum fhirContextVersion = super.getFhirContext().getVersion().getVersion();
        switch (fhirContextVersion) {
            case R4: {
                return (Class)Class.class.cast(CapabilityStatement.class);
            }
            case DSTU3: {
                return (Class)Class.class.cast(org.hl7.fhir.dstu3.model.CapabilityStatement.class);
            }
            case DSTU2_1: {
                return (Class)Class.class.cast(org.hl7.fhir.dstu2016may.model.Conformance.class);
            }
            case DSTU2_HL7ORG: {
                return (Class)Class.class.cast(Conformance.class);
            }
            case DSTU2: {
                return (Class)Class.class.cast(ca.uhn.fhir.model.dstu2.resource.Conformance.class);
            }
        }
        throw new ConfigurationException("Unsupported Fhir version: " + fhirContextVersion);
    }
}

