/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.AddProfileTagEnum;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsExceptionInterceptor;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsResponseException;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.ElementsSupportEnum;
import ca.uhn.fhir.rest.server.HardcodedServerAddressStrategy;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractJaxRsProvider
implements IRestfulServerDefaults {
    private static final String ERROR = "error";
    private static final String PROCESSING = "processing";
    private final FhirContext CTX;
    @Context
    private HttpHeaders myHeaders;
    @Context
    private UriInfo myUriInfo;

    protected AbstractJaxRsProvider() {
        this.CTX = FhirContext.forDstu2();
    }

    protected AbstractJaxRsProvider(FhirContext ctx) {
        this.CTX = ctx;
    }

    public IInterceptorService getInterceptorService() {
        return null;
    }

    public AddProfileTagEnum getAddProfileTag() {
        return AddProfileTagEnum.NEVER;
    }

    public String getBaseForRequest() {
        return this.getBaseForServer();
    }

    public String getBaseForServer() {
        String url = this.getUriInfo().getBaseUri().toASCIIString();
        return StringUtils.isNotBlank((CharSequence)url) && url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public EncodingEnum getDefaultResponseEncoding() {
        return EncodingEnum.JSON;
    }

    public ETagSupportEnum getETagSupport() {
        return ETagSupportEnum.DISABLED;
    }

    public ElementsSupportEnum getElementsSupport() {
        return ElementsSupportEnum.STANDARD;
    }

    public FhirContext getFhirContext() {
        return this.CTX;
    }

    public HttpHeaders getHeaders() {
        return this.myHeaders;
    }

    public List<IServerInterceptor> getInterceptors_() {
        return Collections.emptyList();
    }

    public IPagingProvider getPagingProvider() {
        return null;
    }

    public Map<String, String[]> getParameters() {
        MultivaluedMap queryParameters = this.getUriInfo().getQueryParameters();
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (Map.Entry paramEntry : queryParameters.entrySet()) {
            params.put((String)paramEntry.getKey(), ((List)paramEntry.getValue()).toArray(new String[((List)paramEntry.getValue()).size()]));
        }
        return params;
    }

    public JaxRsRequest.Builder getRequest(RequestTypeEnum requestType, RestOperationTypeEnum restOperation) {
        return this.getRequest(requestType, restOperation, null);
    }

    public JaxRsRequest.Builder getRequest(RequestTypeEnum requestType, RestOperationTypeEnum restOperation, String theResourceName) {
        return new JaxRsRequest.Builder(this, requestType, restOperation, this.myUriInfo.getRequestUri().toString(), theResourceName);
    }

    public IServerAddressStrategy getServerAddressStrategy() {
        HardcodedServerAddressStrategy addressStrategy = new HardcodedServerAddressStrategy();
        addressStrategy.setValue(this.getBaseForRequest());
        return addressStrategy;
    }

    public UriInfo getUriInfo() {
        return this.myUriInfo;
    }

    public Response handleException(JaxRsRequest theRequest, Throwable theException) throws IOException {
        if (theException instanceof JaxRsResponseException) {
            return new JaxRsExceptionInterceptor().convertExceptionIntoResponse(theRequest, (JaxRsResponseException)((Object)theException));
        }
        return new JaxRsExceptionInterceptor().convertExceptionIntoResponse(theRequest, new JaxRsExceptionInterceptor().convertException(this, theException));
    }

    public boolean isDefaultPrettyPrint() {
        return true;
    }

    public void setHeaders(HttpHeaders headers) {
        this.myHeaders = headers;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.myUriInfo = uriInfo;
    }

    public boolean withStackTrace() {
        return false;
    }
}

