/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server.util;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jaxrs.server.util.JaxRsResponse;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;

public class JaxRsRequest
extends RequestDetails {
    private HttpHeaders myHeaders;
    private String myResourceString;
    private AbstractJaxRsProvider myServer;
    private Map<String, Object> myAttributes = new HashMap<String, Object>();

    public JaxRsRequest(AbstractJaxRsProvider server, String resourceString, RequestTypeEnum requestType, RestOperationTypeEnum restOperation) {
        super((IInterceptorBroadcaster)server.getInterceptorService());
        this.myHeaders = server.getHeaders();
        this.myResourceString = resourceString;
        this.setRestOperationType(restOperation);
        this.setServer(server);
        this.setFhirServerBase(server.getBaseForServer());
        this.setParameters(server.getParameters());
        this.setRequestType(requestType);
    }

    protected byte[] getByteStreamRequestContents() {
        return StringUtils.defaultString((String)this.myResourceString, (String)"").getBytes(ResourceParameter.determineRequestCharset((RequestDetails)this));
    }

    public Charset getCharset() {
        String charset = null;
        if (this.myHeaders.getMediaType() != null && this.myHeaders.getMediaType().getParameters() != null) {
            charset = (String)this.myHeaders.getMediaType().getParameters().get("charset");
        }
        if (charset != null) {
            return Charset.forName(charset);
        }
        return null;
    }

    public FhirContext getFhirContext() {
        return this.myServer.getFhirContext();
    }

    public String getHeader(String headerKey) {
        List<String> requestHeader = this.getHeaders(headerKey);
        return requestHeader.isEmpty() ? null : requestHeader.get(0);
    }

    public List<String> getHeaders(String name) {
        List requestHeader = this.myHeaders.getRequestHeader(name);
        return requestHeader == null ? Collections.emptyList() : requestHeader;
    }

    public Object getAttribute(String theAttributeName) {
        return this.myAttributes.get(theAttributeName);
    }

    public void setAttribute(String theAttributeName, Object theAttributeValue) {
        this.myAttributes.put(theAttributeName, theAttributeValue);
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public Reader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public IRestfulResponse getResponse() {
        if (super.getResponse() == null) {
            this.setResponse((IRestfulResponse)new JaxRsResponse(this));
        }
        return super.getResponse();
    }

    public AbstractJaxRsProvider getServer() {
        return this.myServer;
    }

    public void setServer(AbstractJaxRsProvider theServer) {
        this.myServer = theServer;
    }

    public String getServerBaseForRequest() {
        return this.getServer().getServerAddressStrategy().determineServerBase(null, null);
    }

    public static class Builder {
        private final String myResourceName;
        private String myCompartment;
        private String myId;
        private RequestTypeEnum myRequestType;
        private String myRequestUrl;
        private String myResource;
        private RestOperationTypeEnum myRestOperation;
        private AbstractJaxRsProvider myServer;
        private String myVersion;

        public Builder(AbstractJaxRsProvider theServer, RequestTypeEnum theRequestType, RestOperationTypeEnum theRestOperation, String theRequestUrl, String theResourceName) {
            this.myServer = theServer;
            this.myRequestType = theRequestType;
            this.myRestOperation = theRestOperation;
            this.myRequestUrl = theRequestUrl;
            this.myResourceName = theResourceName;
        }

        public JaxRsRequest build() {
            String contentLocation;
            FhirVersionEnum fhirContextVersion;
            JaxRsRequest result;
            block25: {
                block24: {
                    result = new JaxRsRequest(this.myServer, this.myResource, this.myRequestType, this.myRestOperation);
                    if ((StringUtils.isNotBlank((CharSequence)this.myVersion) || StringUtils.isNotBlank((CharSequence)this.myCompartment)) && StringUtils.isBlank((CharSequence)this.myId)) {
                        throw new InvalidRequestException("Don't know how to handle request path: " + this.myServer.getUriInfo().getRequestUri().toASCIIString());
                    }
                    fhirContextVersion = this.myServer.getFhirContext().getVersion().getVersion();
                    if (!StringUtils.isNotBlank((CharSequence)this.myVersion)) break block24;
                    switch (fhirContextVersion) {
                        case R4: {
                            result.setId((IIdType)new IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId), UrlUtil.unescape((String)this.myVersion)));
                            break block25;
                        }
                        case DSTU3: {
                            result.setId((IIdType)new org.hl7.fhir.dstu3.model.IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId), UrlUtil.unescape((String)this.myVersion)));
                            break block25;
                        }
                        case DSTU2_1: {
                            result.setId((IIdType)new org.hl7.fhir.dstu2016may.model.IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId), UrlUtil.unescape((String)this.myVersion)));
                            break block25;
                        }
                        case DSTU2_HL7ORG: {
                            result.setId((IIdType)new org.hl7.fhir.dstu2.model.IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId), UrlUtil.unescape((String)this.myVersion)));
                            break block25;
                        }
                        case DSTU2: {
                            result.setId((IIdType)new IdDt(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId), UrlUtil.unescape((String)this.myVersion)));
                            break block25;
                        }
                        default: {
                            throw new ConfigurationException("Unsupported Fhir version: " + fhirContextVersion);
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)this.myId)) {
                    switch (fhirContextVersion) {
                        case R4: {
                            result.setId((IIdType)new IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId)));
                            break;
                        }
                        case DSTU3: {
                            result.setId((IIdType)new org.hl7.fhir.dstu3.model.IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId)));
                            break;
                        }
                        case DSTU2_1: {
                            result.setId((IIdType)new org.hl7.fhir.dstu2016may.model.IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId)));
                            break;
                        }
                        case DSTU2_HL7ORG: {
                            result.setId((IIdType)new org.hl7.fhir.dstu2.model.IdType(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId)));
                            break;
                        }
                        case DSTU2: {
                            result.setId((IIdType)new IdDt(this.myServer.getBaseForRequest(), UrlUtil.unescape((String)this.myId)));
                            break;
                        }
                        default: {
                            throw new ConfigurationException("Unsupported Fhir version: " + fhirContextVersion);
                        }
                    }
                }
            }
            if (this.myRestOperation == RestOperationTypeEnum.UPDATE && (contentLocation = result.getHeader("Content-Location")) != null) {
                switch (fhirContextVersion) {
                    case R4: {
                        result.setId((IIdType)new IdType(contentLocation));
                        break;
                    }
                    case DSTU3: {
                        result.setId((IIdType)new org.hl7.fhir.dstu3.model.IdType(contentLocation));
                        break;
                    }
                    case DSTU2_1: {
                        result.setId((IIdType)new org.hl7.fhir.dstu2016may.model.IdType(contentLocation));
                        break;
                    }
                    case DSTU2_HL7ORG: {
                        result.setId((IIdType)new org.hl7.fhir.dstu2.model.IdType(contentLocation));
                        break;
                    }
                    case DSTU2: {
                        result.setId((IIdType)new IdDt(contentLocation));
                        break;
                    }
                    default: {
                        throw new ConfigurationException("Unsupported Fhir version: " + fhirContextVersion);
                    }
                }
            }
            result.setCompartmentName(this.myCompartment);
            result.setCompleteUrl(this.myRequestUrl);
            result.setResourceName(this.myResourceName);
            return result;
        }

        public Builder compartment(String compartment) {
            this.myCompartment = compartment;
            return this;
        }

        public Builder id(String id) {
            this.myId = id;
            return this;
        }

        public Builder resource(String resource) {
            this.myResource = resource;
            return this;
        }

        public Builder version(String version) {
            this.myVersion = version;
            return this;
        }
    }
}

