/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch2;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.coordinator.BatchWorkChunk;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.MarkWorkChunkAsErrorRequest;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import ca.uhn.fhir.jpa.dao.data.IBatch2JobInstanceRepository;
import ca.uhn.fhir.jpa.dao.data.IBatch2WorkChunkRepository;
import ca.uhn.fhir.jpa.entity.Batch2JobInstanceEntity;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import ca.uhn.fhir.jpa.util.JobInstanceUtil;
import ca.uhn.fhir.model.api.PagingIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.transaction.Transactional;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Transactional(value=Transactional.TxType.REQUIRES_NEW)
public class JpaJobPersistenceImpl
implements IJobPersistence {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaJobPersistenceImpl.class);
    private final IBatch2JobInstanceRepository myJobInstanceRepository;
    private final IBatch2WorkChunkRepository myWorkChunkRepository;

    public JpaJobPersistenceImpl(IBatch2JobInstanceRepository theJobInstanceRepository, IBatch2WorkChunkRepository theWorkChunkRepository) {
        Validate.notNull((Object)theJobInstanceRepository);
        Validate.notNull((Object)theWorkChunkRepository);
        this.myJobInstanceRepository = theJobInstanceRepository;
        this.myWorkChunkRepository = theWorkChunkRepository;
    }

    public String storeWorkChunk(BatchWorkChunk theBatchWorkChunk) {
        Batch2WorkChunkEntity entity = new Batch2WorkChunkEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setSequence(theBatchWorkChunk.sequence);
        entity.setJobDefinitionId(theBatchWorkChunk.jobDefinitionId);
        entity.setJobDefinitionVersion(theBatchWorkChunk.jobDefinitionVersion);
        entity.setTargetStepId(theBatchWorkChunk.targetStepId);
        entity.setInstanceId(theBatchWorkChunk.instanceId);
        entity.setSerializedData(theBatchWorkChunk.serializedData);
        entity.setCreateTime(new Date());
        entity.setStartTime(new Date());
        entity.setStatus(StatusEnum.QUEUED);
        this.myWorkChunkRepository.save(entity);
        return entity.getId();
    }

    public Optional<WorkChunk> fetchWorkChunkSetStartTimeAndMarkInProgress(String theChunkId) {
        this.myWorkChunkRepository.updateChunkStatusForStart(theChunkId, new Date(), StatusEnum.IN_PROGRESS);
        Optional chunk = this.myWorkChunkRepository.findById(theChunkId);
        return chunk.map(t -> this.toChunk((Batch2WorkChunkEntity)t, true));
    }

    public String storeNewInstance(JobInstance theInstance) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)theInstance.getInstanceId()));
        Batch2JobInstanceEntity entity = new Batch2JobInstanceEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setDefinitionId(theInstance.getJobDefinitionId());
        entity.setDefinitionVersion(theInstance.getJobDefinitionVersion());
        entity.setStatus(theInstance.getStatus());
        entity.setParams(theInstance.getParameters());
        entity.setCurrentGatedStepId(theInstance.getCurrentGatedStepId());
        entity.setCreateTime(new Date());
        entity.setStartTime(new Date());
        entity.setReport(theInstance.getReport());
        entity = (Batch2JobInstanceEntity)this.myJobInstanceRepository.save(entity);
        return entity.getId();
    }

    public Optional<JobInstance> fetchInstanceAndMarkInProgress(String theInstanceId) {
        this.myJobInstanceRepository.updateInstanceStatus(theInstanceId, StatusEnum.IN_PROGRESS);
        return this.fetchInstance(theInstanceId);
    }

    public List<JobInstance> fetchInstancesByJobDefinitionIdAndStatus(String theJobDefinitionId, Set<StatusEnum> theRequestedStatuses, int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"myCreateTime"});
        return this.toInstanceList(this.myJobInstanceRepository.fetchInstancesByJobDefinitionIdAndStatus(theJobDefinitionId, theRequestedStatuses, (Pageable)pageRequest));
    }

    public List<JobInstance> fetchInstancesByJobDefinitionId(String theJobDefinitionId, int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"myCreateTime"});
        return this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobDefinitionId(theJobDefinitionId, (Pageable)pageRequest));
    }

    public Page<JobInstance> fetchJobInstances(JobInstanceFetchRequest theRequest) {
        PageRequest pageRequest = PageRequest.of((int)theRequest.getPageStart(), (int)theRequest.getBatchSize(), (Sort)theRequest.getSort());
        Page pageOfEntities = this.myJobInstanceRepository.findAll((Pageable)pageRequest);
        return pageOfEntities.map(this::toInstance);
    }

    private List<JobInstance> toInstanceList(List<Batch2JobInstanceEntity> theInstancesByJobDefinitionId) {
        return theInstancesByJobDefinitionId.stream().map(this::toInstance).collect(Collectors.toList());
    }

    @Nonnull
    public Optional<JobInstance> fetchInstance(String theInstanceId) {
        return this.myJobInstanceRepository.findById(theInstanceId).map(t -> this.toInstance((Batch2JobInstanceEntity)t));
    }

    public List<JobInstance> fetchInstances(FetchJobInstancesRequest theRequest, int thePage, int theBatchSize) {
        String definitionId = theRequest.getJobDefinition();
        String params = theRequest.getParameters();
        Set statuses = theRequest.getStatuses();
        PageRequest pageable = PageRequest.of((int)thePage, (int)theBatchSize);
        List<Batch2JobInstanceEntity> instanceEntities = statuses != null && !statuses.isEmpty() ? this.myJobInstanceRepository.findInstancesByJobIdParamsAndStatus(definitionId, params, statuses, (Pageable)pageable) : this.myJobInstanceRepository.findInstancesByJobIdAndParams(definitionId, params, (Pageable)pageable);
        return this.toInstanceList(instanceEntities);
    }

    public List<JobInstance> fetchInstances(int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"myCreateTime"});
        return this.myJobInstanceRepository.findAll((Pageable)pageRequest).stream().map(t -> this.toInstance((Batch2JobInstanceEntity)t)).collect(Collectors.toList());
    }

    public List<JobInstance> fetchRecentInstances(int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"myCreateTime"});
        return this.myJobInstanceRepository.findAll((Pageable)pageRequest).stream().map(this::toInstance).collect(Collectors.toList());
    }

    private WorkChunk toChunk(Batch2WorkChunkEntity theEntity, boolean theIncludeData) {
        return JobInstanceUtil.fromEntityToWorkChunk(theEntity, theIncludeData);
    }

    private JobInstance toInstance(Batch2JobInstanceEntity theEntity) {
        return JobInstanceUtil.fromEntityToInstance(theEntity);
    }

    public void markWorkChunkAsErroredAndIncrementErrorCount(String theChunkId, String theErrorMessage) {
        this.myWorkChunkRepository.updateChunkStatusAndIncrementErrorCountForEndError(theChunkId, new Date(), theErrorMessage, StatusEnum.ERRORED);
    }

    public Optional<WorkChunk> markWorkChunkAsErroredAndIncrementErrorCount(MarkWorkChunkAsErrorRequest theParameters) {
        this.markWorkChunkAsErroredAndIncrementErrorCount(theParameters.getChunkId(), theParameters.getErrorMsg());
        Optional op = this.myWorkChunkRepository.findById(theParameters.getChunkId());
        return op.map(c -> this.toChunk((Batch2WorkChunkEntity)c, theParameters.isIncludeData()));
    }

    public void markWorkChunkAsFailed(String theChunkId, String theErrorMessage) {
        String errorMessage;
        if (theErrorMessage.length() > 500) {
            ourLog.warn("Truncating error message that is too long to store in database: {}", (Object)theErrorMessage);
            errorMessage = theErrorMessage.substring(0, 500);
        } else {
            errorMessage = theErrorMessage;
        }
        this.myWorkChunkRepository.updateChunkStatusAndIncrementErrorCountForEndError(theChunkId, new Date(), errorMessage, StatusEnum.FAILED);
    }

    public void markWorkChunkAsCompletedAndClearData(String theChunkId, int theRecordsProcessed) {
        this.myWorkChunkRepository.updateChunkStatusAndClearDataForEndSuccess(theChunkId, new Date(), theRecordsProcessed, StatusEnum.COMPLETED);
    }

    public void markWorkChunksWithStatusAndWipeData(String theInstanceId, List<String> theChunkIds, StatusEnum theStatus, String theErrorMsg) {
        List listOfListOfIds = ListUtils.partition(theChunkIds, (int)100);
        for (List idList : listOfListOfIds) {
            this.myWorkChunkRepository.updateAllChunksForInstanceStatusClearDataAndSetError(idList, new Date(), theStatus, theErrorMsg);
        }
    }

    public void incrementWorkChunkErrorCount(String theChunkId, int theIncrementBy) {
        this.myWorkChunkRepository.incrementWorkChunkErrorCount(theChunkId, theIncrementBy);
    }

    public List<WorkChunk> fetchWorkChunksWithoutData(String theInstanceId, int thePageSize, int thePageIndex) {
        ArrayList<WorkChunk> chunks = new ArrayList<WorkChunk>();
        this.fetchChunks(theInstanceId, false, thePageSize, thePageIndex, chunks::add);
        return chunks;
    }

    private void fetchChunks(String theInstanceId, boolean theIncludeData, int thePageSize, int thePageIndex, Consumer<WorkChunk> theConsumer) {
        List<Batch2WorkChunkEntity> chunks = this.myWorkChunkRepository.fetchChunks((Pageable)PageRequest.of((int)thePageIndex, (int)thePageSize), theInstanceId);
        for (Batch2WorkChunkEntity chunk : chunks) {
            theConsumer.accept(this.toChunk(chunk, theIncludeData));
        }
    }

    private void fetchChunksForStep(String theInstanceId, String theStepId, int thePageSize, int thePageIndex, Consumer<WorkChunk> theConsumer) {
        List<Batch2WorkChunkEntity> chunks = this.myWorkChunkRepository.fetchChunksForStep((Pageable)PageRequest.of((int)thePageIndex, (int)thePageSize), theInstanceId, theStepId);
        for (Batch2WorkChunkEntity chunk : chunks) {
            theConsumer.accept(this.toChunk(chunk, true));
        }
    }

    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String theInstanceId, boolean theWithData) {
        return new PagingIterator((thePageIndex, theBatchSize, theConsumer) -> this.fetchChunks(theInstanceId, theWithData, theBatchSize, thePageIndex, theConsumer));
    }

    public Iterator<WorkChunk> fetchAllWorkChunksForStepIterator(String theInstanceId, String theStepId) {
        return new PagingIterator((thePageIndex, theBatchSize, theConsumer) -> this.fetchChunksForStep(theInstanceId, theStepId, theBatchSize, thePageIndex, theConsumer));
    }

    public boolean updateInstance(JobInstance theInstance) {
        int recordsChangedByStatusUpdate = this.myJobInstanceRepository.updateInstanceStatus(theInstance.getInstanceId(), theInstance.getStatus());
        Optional instanceOpt = this.myJobInstanceRepository.findById(theInstance.getInstanceId());
        Batch2JobInstanceEntity instance = (Batch2JobInstanceEntity)instanceOpt.orElseThrow(() -> new IllegalArgumentException("Unknown instance ID: " + theInstance.getInstanceId()));
        instance.setStartTime(theInstance.getStartTime());
        instance.setEndTime(theInstance.getEndTime());
        instance.setStatus(theInstance.getStatus());
        instance.setCancelled(theInstance.isCancelled());
        instance.setCombinedRecordsProcessed(theInstance.getCombinedRecordsProcessed());
        instance.setCombinedRecordsProcessedPerSecond(theInstance.getCombinedRecordsProcessedPerSecond());
        instance.setTotalElapsedMillis(theInstance.getTotalElapsedMillis());
        instance.setWorkChunksPurged(theInstance.isWorkChunksPurged());
        instance.setProgress(theInstance.getProgress());
        instance.setErrorMessage(theInstance.getErrorMessage());
        instance.setErrorCount(theInstance.getErrorCount());
        instance.setEstimatedTimeRemaining(theInstance.getEstimatedTimeRemaining());
        instance.setCurrentGatedStepId(theInstance.getCurrentGatedStepId());
        instance.setReport(theInstance.getReport());
        this.myJobInstanceRepository.save(instance);
        return recordsChangedByStatusUpdate > 0;
    }

    public void deleteInstanceAndChunks(String theInstanceId) {
        this.myWorkChunkRepository.deleteAllForInstance(theInstanceId);
        this.myJobInstanceRepository.deleteById(theInstanceId);
    }

    public void deleteChunks(String theInstanceId) {
        this.myWorkChunkRepository.deleteAllForInstance(theInstanceId);
    }

    public boolean markInstanceAsCompleted(String theInstanceId) {
        int recordsChanged = this.myJobInstanceRepository.updateInstanceStatus(theInstanceId, StatusEnum.COMPLETED);
        return recordsChanged > 0;
    }

    public JobOperationResultJson cancelInstance(String theInstanceId) {
        int recordsChanged = this.myJobInstanceRepository.updateInstanceCancelled(theInstanceId, true);
        String operationString = "Cancel job instance " + theInstanceId;
        if (recordsChanged > 0) {
            return JobOperationResultJson.newSuccess((String)operationString, (String)("Job instance <" + theInstanceId + "> successfully cancelled."));
        }
        Optional<JobInstance> instance = this.fetchInstance(theInstanceId);
        if (instance.isPresent()) {
            return JobOperationResultJson.newFailure((String)operationString, (String)("Job instance <" + theInstanceId + "> was already cancelled.  Nothing to do."));
        }
        return JobOperationResultJson.newFailure((String)operationString, (String)("Job instance <" + theInstanceId + "> not found."));
    }
}

