/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binstore;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.binary.api.StoredDetails;
import ca.uhn.fhir.jpa.binary.svc.BaseBinaryStorageSvcImpl;
import ca.uhn.fhir.jpa.dao.data.IBinaryStorageEntityDao;
import ca.uhn.fhir.jpa.model.entity.BinaryStorageEntity;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.hash.HashingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.hibernate.LobHelper;
import org.hibernate.Session;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

@Transactional
public class DatabaseBlobBinaryStorageSvcImpl
extends BaseBinaryStorageSvcImpl {
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private IBinaryStorageEntityDao myBinaryStorageEntityDao;
    @Autowired
    private PlatformTransactionManager myPlatformTransactionManager;
    @Autowired
    private DaoConfig myDaoConfig;

    @Transactional(value=Transactional.TxType.REQUIRED)
    public StoredDetails storeBlob(IIdType theResourceId, String theBlobIdOrNull, String theContentType, InputStream theInputStream) throws IOException {
        Date publishedDate = new Date();
        HashingInputStream hashingInputStream = this.createHashingInputStream(theInputStream);
        CountingInputStream countingInputStream = this.createCountingInputStream((InputStream)hashingInputStream);
        String id = super.provideIdForNewBlob(theBlobIdOrNull);
        BinaryStorageEntity entity = new BinaryStorageEntity();
        entity.setResourceId(theResourceId.toUnqualifiedVersionless().getValue());
        entity.setBlobId(id);
        entity.setBlobContentType(theContentType);
        entity.setPublished(publishedDate);
        Session session = (Session)this.myEntityManager.getDelegate();
        LobHelper lobHelper = session.getLobHelper();
        byte[] loadedStream = IOUtils.toByteArray((InputStream)countingInputStream);
        Blob dataBlob = lobHelper.createBlob(loadedStream);
        entity.setBlob(dataBlob);
        long bytes = countingInputStream.getCount();
        String hash = hashingInputStream.hash().toString();
        entity.setSize((int)bytes);
        entity.setHash(hash);
        this.myEntityManager.persist((Object)entity);
        return new StoredDetails().setBlobId(id).setBytes(bytes).setPublished(publishedDate).setHash(hash).setContentType(theContentType);
    }

    public StoredDetails fetchBlobDetails(IIdType theResourceId, String theBlobId) {
        Optional<BinaryStorageEntity> entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBlobId, theResourceId.toUnqualifiedVersionless().getValue());
        if (!entityOpt.isPresent()) {
            return null;
        }
        BinaryStorageEntity entity = entityOpt.get();
        return new StoredDetails().setBlobId(theBlobId).setContentType(entity.getBlobContentType()).setHash(entity.getHash()).setPublished(entity.getPublished()).setBytes((long)entity.getSize());
    }

    public boolean writeBlob(IIdType theResourceId, String theBlobId, OutputStream theOutputStream) throws IOException {
        Optional<BinaryStorageEntity> entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBlobId, theResourceId.toUnqualifiedVersionless().getValue());
        if (!entityOpt.isPresent()) {
            return false;
        }
        this.copyBlobToOutputStream(theOutputStream, entityOpt.get());
        return true;
    }

    public void expungeBlob(IIdType theResourceId, String theBlobId) {
        Optional<BinaryStorageEntity> entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBlobId, theResourceId.toUnqualifiedVersionless().getValue());
        entityOpt.ifPresent(theBinaryStorageEntity -> this.myBinaryStorageEntityDao.deleteByPid(theBinaryStorageEntity.getBlobId()));
    }

    public byte[] fetchBlob(IIdType theResourceId, String theBlobId) throws IOException {
        BinaryStorageEntity entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBlobId, theResourceId.toUnqualifiedVersionless().getValue()).orElseThrow(() -> new ResourceNotFoundException("Unknown blob ID: " + theBlobId + " for resource ID " + theResourceId));
        return this.copyBlobToByteArray(entityOpt);
    }

    void copyBlobToOutputStream(OutputStream theOutputStream, BinaryStorageEntity theEntity) throws IOException {
        try (InputStream inputStream = theEntity.getBlob().getBinaryStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)theOutputStream);
        }
        catch (SQLException e) {
            throw new IOException(Msg.code((int)1341) + e);
        }
    }

    byte[] copyBlobToByteArray(BinaryStorageEntity theEntity) throws IOException {
        int size = theEntity.getSize();
        try {
            return IOUtils.toByteArray((InputStream)theEntity.getBlob().getBinaryStream(), (int)size);
        }
        catch (SQLException e) {
            throw new IOException(Msg.code((int)1342) + e);
        }
    }
}

