/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobParametersBuilder;

public class BulkExportJobParametersBuilder
extends JobParametersBuilder {
    public BulkExportJobParametersBuilder setResourceTypes(List<String> resourceTypes) {
        String resourceTypesString = resourceTypes.stream().collect(Collectors.joining(","));
        this.addString("resourceTypes", resourceTypesString);
        return this;
    }

    public BulkExportJobParametersBuilder setSince(Date theSince) {
        this.addDate("since", theSince);
        return this;
    }

    public BulkExportJobParametersBuilder setOutputFormat(String theOutputFormat) {
        theOutputFormat = "application/fhir+ndjson";
        this.addString("outputFormat", theOutputFormat);
        return this;
    }

    public BulkExportJobParametersBuilder setFilters(Set<String> theFilters) {
        this.addString("filters", theFilters.stream().collect(Collectors.joining(",")));
        return this;
    }

    public BulkExportJobParametersBuilder setJobUUID(String theJobUUID) {
        this.addString("jobUUID", theJobUUID);
        return this;
    }

    public BulkExportJobParametersBuilder setReadChunkSize(Long theReadChunkSize) {
        this.addLong("readChunkSize", theReadChunkSize);
        return this;
    }

    public BulkExportJobParametersBuilder setExportStyle(BulkDataExportOptions.ExportStyle theExportStyle) {
        this.addString("exportStyle", theExportStyle.name());
        return this;
    }
}

